/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.metadata.replace;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.GO_GenericName;
import org.apache.sis.internal.jaxb.metadata.replace.Parameter;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.iso.DefaultMemberName;
import org.apache.sis.util.iso.Names;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.MemberName;
import org.opengis.util.TypeName;

@XmlType(name="SV_Parameter_Type", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", propOrder={"memberName", "legacyName", "description", "optionality", "optionalityLabel", "repeatability", "legacyValueType"})
@XmlRootElement(name="SV_Parameter", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
public final class ServiceParameter
extends Parameter {
    @XmlElement(required=true, name="name")
    @XmlJavaTypeAdapter(value=GO_GenericName.Since2014.class)
    MemberName memberName;
    @XmlElement
    InternationalString description;
    boolean optionality;
    @XmlElement(required=true)
    boolean repeatability;

    ServiceParameter() {
    }

    private ServiceParameter(ParameterDescriptor<?> parameterDescriptor) {
        super(parameterDescriptor);
        this.memberName = ServiceParameter.getMemberName(parameterDescriptor);
        this.optionality = parameterDescriptor.getMinimumOccurs() > 0;
        this.repeatability = parameterDescriptor.getMaximumOccurs() > 1;
    }

    public static ServiceParameter castOrCopy(ParameterDescriptor<?> parameterDescriptor) {
        if (parameterDescriptor == null || parameterDescriptor instanceof ServiceParameter) {
            return (ServiceParameter)parameterDescriptor;
        }
        return new ServiceParameter(parameterDescriptor);
    }

    public static MemberName getMemberName(ParameterDescriptor<?> parameterDescriptor) {
        if (parameterDescriptor != null) {
            Object object;
            ReferenceIdentifier referenceIdentifier = parameterDescriptor.getName();
            if (referenceIdentifier instanceof MemberName) {
                return (MemberName)referenceIdentifier;
            }
            Object object2 = CollectionsExt.nonNull(parameterDescriptor.getAlias()).iterator();
            while (object2.hasNext()) {
                object = (GenericName)object2.next();
                if (!(object instanceof MemberName)) continue;
                return (MemberName)object;
            }
            if (referenceIdentifier != null && (object2 = referenceIdentifier.getCode()) != null) {
                object = referenceIdentifier.getCodeSpace();
                TypeName typeName = ReferencingServices.getInstance().getValueType(parameterDescriptor);
                if (typeName != null) {
                    return Names.createMemberName((CharSequence)object, null, (CharSequence)object2, typeName);
                }
                Class clazz = parameterDescriptor.getValueClass();
                if (clazz != null) {
                    return Names.createMemberName((CharSequence)object, null, (CharSequence)object2, clazz);
                }
            }
        }
        return null;
    }

    @Override
    public synchronized ReferenceIdentifier getName() {
        if (this.name == null && this.memberName != null) {
            this.name = this.memberName instanceof ReferenceIdentifier ? (ReferenceIdentifier)this.memberName : new NameToIdentifier((GenericName)this.memberName);
        }
        return this.name;
    }

    @XmlElement(name="name", namespace="http://www.isotc211.org/2005/srv")
    private DefaultMemberName getLegacyName() {
        return FilterByVersion.LEGACY_METADATA.accept() ? DefaultMemberName.castOrCopy(this.memberName) : null;
    }

    private void setLegacyName(DefaultMemberName defaultMemberName) {
        if (this.memberName == null) {
            this.memberName = defaultMemberName;
        }
    }

    @XmlElement(name="valueType", namespace="http://www.isotc211.org/2005/srv")
    @XmlJavaTypeAdapter(value=GO_GenericName.class)
    private TypeName getLegacyValueType() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.getValueType() : null;
    }

    @Override
    public TypeName getValueType() {
        TypeName typeName = super.getValueType();
        if (typeName == null && this.memberName != null) {
            typeName = this.memberName.getAttributeType();
        }
        return typeName;
    }

    public Class<?> getValueClass() {
        Class clazz = super.getValueClass();
        return clazz != null ? clazz : Names.toClass(this.getValueType());
    }

    public InternationalString getDescription() {
        return this.description;
    }

    @XmlElement(name="optionality", required=true)
    final Boolean getOptionality() {
        return FilterByVersion.CURRENT_METADATA.accept() ? Boolean.valueOf(this.optionality) : null;
    }

    final void setOptionality(Boolean bl) {
        if (bl != null) {
            this.optionality = bl;
        }
    }

    @XmlElement(name="optionality", namespace="http://www.isotc211.org/2005/srv")
    final String getOptionalityLabel() {
        return FilterByVersion.LEGACY_METADATA.accept() ? (this.optionality ? "Optional" : "Mandatory") : null;
    }

    final void setOptionalityLabel(String string) {
        if (string != null) {
            this.optionality = Boolean.parseBoolean(string) || string.equalsIgnoreCase("Optional");
        }
    }

    public int getMinimumOccurs() {
        return this.optionality ? 0 : 1;
    }

    public int getMaximumOccurs() {
        return this.repeatability ? Integer.MAX_VALUE : 1;
    }
}

