/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.Locale;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.internal.storage.xml.stream.StaxDataStore;
import org.apache.sis.internal.storage.xml.stream.StaxStreamWriter;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.ReadOnlyStorageException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;

public abstract class RewriteOnUpdate
implements AutoCloseable {
    protected final FeatureSet source;
    private final Path location;
    private boolean isSourceEmpty;
    private Stream<? extends AbstractFeature> filtered;
    private boolean modified;

    public RewriteOnUpdate(FeatureSet featureSet, Path path) throws IOException {
        this.source = featureSet;
        this.location = path;
        this.isSourceEmpty = path == null || Files.notExists(path, new LinkOption[0]) || Files.size(path) == 0L;
    }

    protected final Locale getLocale() {
        return this.source instanceof StaxDataStore ? ((StaxDataStore)this.source).locale : null;
    }

    private boolean isEmpty() throws ReadOnlyStorageException {
        if (this.isSourceEmpty) {
            return this.filtered == null;
        }
        if (this.location != null) {
            return false;
        }
        throw new ReadOnlyStorageException();
    }

    private Stream<? extends AbstractFeature> filtered() throws DataStoreException {
        if (this.filtered == null) {
            this.filtered = this.features();
        }
        return this.filtered;
    }

    protected Stream<? extends AbstractFeature> features() throws DataStoreException {
        return this.source.features(false);
    }

    public void add(Iterator<? extends AbstractFeature> iterator) throws DataStoreException {
        ArgumentChecks.ensureNonNull("features", iterator);
        Stream<? extends AbstractFeature> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
        this.filtered = this.isEmpty() ? stream : Stream.concat(this.filtered(), stream);
    }

    public boolean removeIf(Predicate<? super AbstractFeature> predicate) throws DataStoreException {
        ArgumentChecks.ensureNonNull("filter", predicate);
        if (this.isEmpty()) {
            return false;
        }
        this.filtered = this.filtered().filter(abstractFeature -> {
            boolean bl = predicate.test((AbstractFeature)abstractFeature);
            if (bl) {
                this.modified = true;
            }
            return !bl;
        });
        this.modified = false;
        this.flush();
        return this.modified;
    }

    public void replaceIf(Predicate<? super AbstractFeature> predicate, UnaryOperator<AbstractFeature> unaryOperator) throws DataStoreException {
        ArgumentChecks.ensureNonNull("filter", predicate);
        ArgumentChecks.ensureNonNull("updater", unaryOperator);
        if (!this.isEmpty()) {
            this.filtered = this.filtered().map(abstractFeature -> abstractFeature != null && predicate.test((AbstractFeature)abstractFeature) ? (AbstractFeature)unaryOperator.apply((AbstractFeature)abstractFeature) : abstractFeature);
        }
    }

    protected abstract Path createTemporaryFile() throws IOException;

    protected abstract StaxStreamWriter createWriter(OutputStream var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws DataStoreException {
        block25: {
            try (Stream<? extends AbstractFeature> stream = this.filtered;){
                if (stream == null) break block25;
                this.filtered = null;
                OutputStream outputStream = null;
                Path path = this.isSourceEmpty ? null : this.createTemporaryFile();
                try {
                    if (path != null) {
                        outputStream = Files.newOutputStream(path, new OpenOption[0]);
                    }
                    try (StaxStreamWriter staxStreamWriter = this.createWriter(outputStream);){
                        outputStream = null;
                        this.isSourceEmpty = false;
                        staxStreamWriter.writeStartDocument();
                        ((Stream)stream.sequential()).forEachOrdered(staxStreamWriter);
                        staxStreamWriter.writeEndDocument();
                    }
                    if (path != null) {
                        Files.move(path, this.location, StandardCopyOption.REPLACE_EXISTING);
                        path = null;
                    }
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (path != null) {
                        Files.delete(path);
                    }
                }
            }
            catch (DataStoreException dataStoreException) {
                throw dataStoreException;
            }
            catch (BackingStoreException backingStoreException) {
                Throwable throwable = backingStoreException.getCause();
                if (throwable instanceof DataStoreException) {
                    throw (DataStoreException)throwable;
                }
                throw new DataStoreException(backingStoreException.getLocalizedMessage(), throwable);
            }
            catch (Exception exception) {
                IOException iOException;
                if (exception instanceof UncheckedIOException) {
                    iOException = ((UncheckedIOException)exception).getCause();
                }
                throw new DataStoreException((Throwable)iOException);
            }
        }
    }

    @Override
    public void close() {
        Stream<? extends AbstractFeature> stream = this.filtered;
        if (stream != null) {
            this.filtered = null;
            stream.close();
        }
    }
}

