/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml.stream;

import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sis.internal.xml.StreamWriterDelegate;

final class FormattedWriter
extends StreamWriterDelegate {
    private static final char[] SPACES = new char[12];
    private final String lineSeparator;
    private final int indentation;
    private int margin;
    private boolean inline;

    FormattedWriter(XMLStreamWriter xMLStreamWriter, int n) throws XMLStreamException {
        super(xMLStreamWriter);
        this.indentation = n;
        this.lineSeparator = System.lineSeparator();
    }

    private void indent() throws XMLStreamException {
        int n;
        this.out.writeCharacters(this.lineSeparator);
        int n2 = SPACES.length;
        for (n = this.margin; n > n2; n -= n2) {
            this.out.writeCharacters(SPACES, 0, n2);
        }
        this.out.writeCharacters(SPACES, 0, n);
    }

    private void emptyIndent() throws XMLStreamException {
        this.indent();
        this.inline = false;
    }

    final void startIndent() throws XMLStreamException {
        this.indent();
        this.inline = true;
        this.margin += this.indentation;
    }

    public void writeStartElement(String string) throws XMLStreamException {
        this.startIndent();
        this.out.writeStartElement(string);
    }

    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.startIndent();
        this.out.writeStartElement(string, string2);
    }

    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.startIndent();
        this.out.writeStartElement(string, string2, string3);
    }

    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.emptyIndent();
        this.out.writeEmptyElement(string, string2);
    }

    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.emptyIndent();
        this.out.writeEmptyElement(string, string2, string3);
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        this.emptyIndent();
        this.out.writeEmptyElement(string);
    }

    public void writeEndElement() throws XMLStreamException {
        this.margin -= this.indentation;
        if (!this.inline) {
            this.indent();
        }
        this.inline = false;
        this.out.writeEndElement();
    }

    public void writeEndDocument() throws XMLStreamException {
        this.out.writeCharacters(this.lineSeparator);
        this.out.writeEndDocument();
        this.out.writeCharacters(this.lineSeparator);
    }

    static {
        Arrays.fill(SPACES, ' ');
    }
}

