/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.storage.gpx.Metadata;
import org.apache.sis.internal.storage.gpx.Store;
import org.apache.sis.internal.storage.gpx.StoreProvider;
import org.apache.sis.internal.storage.gpx.Updater;
import org.apache.sis.internal.storage.gpx.Writer;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.IllegalFeatureTypeException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.WritableFeatureSet;
import org.apache.sis.util.collection.BackingStoreException;

public final class WritableStore
extends Store
implements WritableFeatureSet {
    public WritableStore(StoreProvider storeProvider, StorageConnector storageConnector) throws DataStoreException {
        super(storeProvider, storageConnector);
    }

    public void updateType(DefaultFeatureType defaultFeatureType) throws DataStoreException {
        if (!defaultFeatureType.equals(this.getType())) {
            throw new IllegalFeatureTypeException(this.getLocale(), "GPX", defaultFeatureType.getName());
        }
    }

    public synchronized void add(Iterator<? extends AbstractFeature> iterator) throws DataStoreException {
        try (Updater updater = this.updater();){
            updater.add(iterator);
            updater.flush();
        }
    }

    public synchronized boolean removeIf(Predicate<? super AbstractFeature> predicate) throws DataStoreException {
        try (Updater updater = this.updater();){
            boolean bl = updater.removeIf(predicate);
            return bl;
        }
    }

    public synchronized void replaceIf(Predicate<? super AbstractFeature> predicate, UnaryOperator<AbstractFeature> unaryOperator) throws DataStoreException {
        try (Updater updater = this.updater();){
            updater.replaceIf(predicate, unaryOperator);
            updater.flush();
        }
    }

    private Updater updater() throws DataStoreException {
        try {
            return new Updater(this, this.getSpecifiedPath());
        }
        catch (IOException iOException) {
            throw new DataStoreException((Throwable)iOException);
        }
    }

    @Deprecated
    public synchronized void write(org.opengis.metadata.Metadata metadata, Stream<? extends AbstractFeature> stream) throws DataStoreException {
        try {
            this.closeReader();
            try (Writer writer = new Writer(this, Metadata.castOrCopy(metadata, this.locale), null);){
                writer.writeStartDocument();
                if (stream != null) {
                    stream.forEachOrdered(writer);
                }
                writer.writeEndDocument();
            }
        }
        catch (BackingStoreException backingStoreException) {
            Throwable throwable = backingStoreException.getCause();
            if (throwable instanceof DataStoreException) {
                throw (DataStoreException)throwable;
            }
            throw new DataStoreException(backingStoreException.getLocalizedMessage(), throwable);
        }
        catch (Exception exception) {
            IOException iOException;
            if (exception instanceof UncheckedIOException) {
                iOException = ((UncheckedIOException)exception).getCause();
            }
            throw new DataStoreException((Throwable)iOException);
        }
    }
}

