/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.io.EOFException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.internal.storage.gpx.Bounds;
import org.apache.sis.internal.storage.gpx.Link;
import org.apache.sis.internal.storage.gpx.Metadata;
import org.apache.sis.internal.storage.gpx.Person;
import org.apache.sis.internal.storage.gpx.Store;
import org.apache.sis.internal.storage.gpx.StoreProvider;
import org.apache.sis.internal.storage.gpx.Types;
import org.apache.sis.internal.storage.xml.stream.StaxStreamReader;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.gps.Fix;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.BackingStoreException;

final class Reader
extends StaxStreamReader {
    private String namespace;
    private Metadata metadata;
    private int wayPointId;
    private int routeId;
    private int trackId;

    Reader(Store store) throws Exception {
        super(store);
    }

    private static boolean isGPX(String string) {
        return string == null || string.startsWith("http://www.topografix.com/GPX/");
    }

    private boolean isGPX() {
        String string = this.reader.getNamespaceURI();
        return Objects.equals(this.namespace, string) || Reader.isGPX(string);
    }

    private boolean isEndGPX() {
        assert (this.reader.isEndElement());
        return "gpx".equals(this.reader.getLocalName()) && Objects.equals(this.namespace, this.reader.getNamespaceURI());
    }

    /*
     * Enabled aggressive block sorting
     */
    public Version initialize(boolean bl) throws DataStoreException, XMLStreamException, JAXBException, URISyntaxException, EOFException {
        this.moveToRootElement(Reader::isGPX, "gpx");
        this.namespace = this.reader.getNamespaceURI();
        String string = this.reader.getAttributeValue(null, "version");
        Version version = null;
        if (string != null) {
            version = new Version(string);
            if (version.compareTo(StoreProvider.V1_0, 2) < 0 || version.compareTo(StoreProvider.V1_1, 2) > 0) {
                throw new DataStoreContentException(this.errors().getString((short)159, this.owner.getFormatName(), version));
            }
        } else if (this.namespace != null) {
            switch (this.namespace) {
                case "http://www.topografix.com/GPX/1/0": {
                    version = StoreProvider.V1_0;
                    break;
                }
                case "http://www.topografix.com/GPX/1/1": {
                    version = StoreProvider.V1_1;
                    break;
                }
            }
        }
        block54: while (this.reader.hasNext()) {
            switch (this.next()) {
                case 1: {
                    if (!this.isGPX()) break;
                    String string2 = this.reader.getLocalName();
                    if (bl) {
                        switch (string2) {
                            case "metadata": {
                                this.metadata = this.unmarshal(Metadata.class);
                                break;
                            }
                            case "name": {
                                this.metadata().name = this.getElementText();
                                break;
                            }
                            case "desc": {
                                this.metadata().description = this.getElementText();
                                break;
                            }
                            case "author": {
                                this.author().name = this.getElementText();
                                break;
                            }
                            case "email": {
                                this.author().email = this.getElementText();
                                break;
                            }
                            case "url": {
                                this.link().uri = this.getElementAsURI();
                                break;
                            }
                            case "urlname": {
                                this.link().text = this.getElementText();
                                break;
                            }
                            case "time": {
                                this.metadata().time = this.getElementAsDate();
                                break;
                            }
                            case "keywords": {
                                this.metadata().keywords = this.getElementAsList();
                                break;
                            }
                            case "bounds": {
                                this.metadata().bounds = this.unmarshal(Bounds.class);
                                break;
                            }
                            case "wpt": 
                            case "trk": 
                            case "rte": {
                                break block54;
                            }
                            case "gpx": {
                                throw new DataStoreContentException(this.nestedElement("gpx"));
                            }
                        }
                        break;
                    }
                    switch (string2) {
                        case "metadata": {
                            this.skipUntilEnd(this.reader.getName());
                            break;
                        }
                        case "wpt": 
                        case "trk": 
                        case "rte": {
                            break block54;
                        }
                        case "gpx": {
                            throw new DataStoreContentException(this.nestedElement("gpx"));
                        }
                    }
                    break;
                }
                case 2: {
                    if (this.isEndGPX()) break block54;
                }
            }
        }
        if (bl) {
            this.metadata().store = (Store)this.owner;
        }
        return version;
    }

    private Metadata metadata() {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        return this.metadata;
    }

    private Person author() {
        Metadata metadata = this.metadata();
        if (metadata.author == null) {
            metadata.author = new Person();
        }
        return metadata.author;
    }

    private Link link() {
        Link link;
        Metadata metadata = this.metadata();
        List<Link> list = metadata.links;
        if (list == null) {
            metadata.links = list = new ArrayList<Link>();
        }
        if (list.isEmpty()) {
            link = new Link();
            list.add(link);
        } else {
            link = list.get(0);
        }
        return link;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean tryAdvance(Consumer<? super AbstractFeature> consumer) throws BackingStoreException {
        try {
            return this.parse(consumer, false);
        }
        catch (Exception exception) {
            throw new BackingStoreException(this.canNotParseFile(), exception);
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super AbstractFeature> consumer) throws BackingStoreException {
        try {
            this.parse(consumer, true);
        }
        catch (Exception exception) {
            throw new BackingStoreException(this.canNotParseFile(), exception);
        }
    }

    private boolean parse(Consumer<? super AbstractFeature> consumer, boolean bl) throws Exception {
        int n = this.reader.getEventType();
        while (true) {
            block0 : switch (n) {
                case 1: {
                    AbstractFeature abstractFeature;
                    switch (this.isGPX() ? this.reader.getLocalName() : "") {
                        case "wpt": {
                            abstractFeature = this.parseWayPoint(++this.wayPointId);
                            break;
                        }
                        case "rte": {
                            abstractFeature = this.parseRoute(++this.routeId);
                            break;
                        }
                        case "trk": {
                            abstractFeature = this.parseTrack(++this.trackId);
                            break;
                        }
                        case "gpx": {
                            throw new DataStoreContentException(this.nestedElement("gpx"));
                        }
                        default: {
                            this.skipUntilEnd(this.reader.getName());
                            break block0;
                        }
                    }
                    consumer.accept(abstractFeature);
                    if (bl) break;
                    this.reader.next();
                    return true;
                }
                case 2: {
                    if (!this.isEndGPX()) break;
                }
                case 8: {
                    return false;
                }
            }
            n = this.reader.next();
        }
    }

    private AbstractFeature parseWayPoint(int n) throws Exception {
        assert (this.reader.isStartElement());
        String string = this.reader.getLocalName();
        String string2 = this.reader.getAttributeValue(null, "lat");
        String string3 = this.reader.getAttributeValue(null, "lon");
        if (string2 == null || string3 == null) {
            throw new DataStoreContentException(this.errors().getString((short)76, string2 == null ? "lat" : "lon", string));
        }
        Types types = ((Store)this.owner).types;
        AbstractFeature abstractFeature = types.wayPoint.newInstance();
        abstractFeature.setPropertyValue("sis:identifier", n);
        abstractFeature.setPropertyValue("sis:geometry", types.geometries.createPoint(Reader.parseDouble(string3), Reader.parseDouble(string2)));
        List<Link> list = null;
        while (true) {
            block0 : switch (this.next()) {
                case 1: {
                    Object object;
                    String string4 = this.reader.getLocalName();
                    switch (this.isGPX() ? string4 : "") {
                        case "name": 
                        case "cmt": 
                        case "desc": 
                        case "src": 
                        case "sym": 
                        case "type": {
                            object = this.getElementText();
                            break;
                        }
                        case "time": {
                            object = this.getElementAsTemporal();
                            break;
                        }
                        case "magvar": 
                        case "geoidheight": 
                        case "ageofdgpsdata": 
                        case "hdop": 
                        case "pdop": 
                        case "vdop": 
                        case "ele": {
                            object = this.getElementAsDouble();
                            break;
                        }
                        case "sat": 
                        case "dgpsid": {
                            object = this.getElementAsInteger();
                            break;
                        }
                        case "fix": {
                            object = Fix.fromGPX(this.getElementText());
                            break;
                        }
                        case "link": {
                            list = Metadata.addIfNonNull(list, this.unmarshal(Link.class));
                            break block0;
                        }
                        case "url": {
                            list = Metadata.addIfNonNull(list, Link.valueOf(this.getElementAsURI()));
                            break block0;
                        }
                        default: {
                            if (!string4.equals(string)) break block0;
                            throw new DataStoreContentException(this.nestedElement(string4));
                        }
                    }
                    abstractFeature.setPropertyValue(string4, object);
                    break;
                }
                case 2: {
                    if (!string.equals(this.reader.getLocalName()) || !this.isGPX()) break;
                    if (list != null) {
                        abstractFeature.setPropertyValue("link", list);
                    }
                    return abstractFeature;
                }
                case 8: {
                    throw new EOFException(this.endOfFile());
                }
            }
        }
    }

    private AbstractFeature parseRoute(int n) throws Exception {
        assert (this.reader.isStartElement() && "rte".equals(this.reader.getLocalName()));
        AbstractFeature abstractFeature = ((Store)this.owner).types.route.newInstance();
        abstractFeature.setPropertyValue("sis:identifier", n);
        ArrayList<AbstractFeature> arrayList = null;
        List<Link> list = null;
        while (true) {
            block0 : switch (this.next()) {
                case 1: {
                    Object object;
                    String string = this.reader.getLocalName();
                    switch (this.isGPX() ? string : "") {
                        default: {
                            break block0;
                        }
                        case "name": 
                        case "cmt": 
                        case "desc": 
                        case "src": 
                        case "type": {
                            object = this.getElementText();
                            break;
                        }
                        case "number": {
                            object = this.getElementAsInteger();
                            break;
                        }
                        case "link": {
                            list = Metadata.addIfNonNull(list, this.unmarshal(Link.class));
                            break block0;
                        }
                        case "url": {
                            list = Metadata.addIfNonNull(list, Link.valueOf(this.getElementAsURI()));
                            break block0;
                        }
                        case "rte": {
                            throw new DataStoreContentException(this.nestedElement(string));
                        }
                        case "rtept": {
                            if (arrayList == null) {
                                arrayList = new ArrayList<AbstractFeature>(8);
                            }
                            arrayList.add(this.parseWayPoint(arrayList.size() + 1));
                            break block0;
                        }
                    }
                    abstractFeature.setPropertyValue(string, object);
                    break;
                }
                case 2: {
                    if (!"rte".equals(this.reader.getLocalName()) || !this.isGPX()) break;
                    if (arrayList != null) {
                        abstractFeature.setPropertyValue("rtept", arrayList);
                    }
                    if (list != null) {
                        abstractFeature.setPropertyValue("link", list);
                    }
                    return abstractFeature;
                }
                case 8: {
                    throw new EOFException(this.endOfFile());
                }
            }
        }
    }

    private AbstractFeature parseTrackSegment(int n) throws Exception {
        assert (this.reader.isStartElement() && "trkseg".equals(this.reader.getLocalName()));
        AbstractFeature abstractFeature = ((Store)this.owner).types.trackSegment.newInstance();
        abstractFeature.setPropertyValue("sis:identifier", n);
        ArrayList<AbstractFeature> arrayList = null;
        while (true) {
            block0 : switch (this.reader.next()) {
                case 1: {
                    String string = this.reader.getLocalName();
                    switch (this.isGPX() ? string : "") {
                        default: {
                            break block0;
                        }
                        case "trkpt": {
                            if (arrayList == null) {
                                arrayList = new ArrayList<AbstractFeature>(8);
                            }
                            arrayList.add(this.parseWayPoint(arrayList.size() + 1));
                            break block0;
                        }
                        case "trkseg": {
                            throw new DataStoreContentException(this.nestedElement(string));
                        }
                    }
                }
                case 2: {
                    if (!"trkseg".equals(this.reader.getLocalName()) || !this.isGPX()) break;
                    if (arrayList != null) {
                        abstractFeature.setPropertyValue("trkpt", arrayList);
                    }
                    return abstractFeature;
                }
                case 8: {
                    throw new EOFException(this.endOfFile());
                }
            }
        }
    }

    private AbstractFeature parseTrack(int n) throws Exception {
        assert (this.reader.isStartElement() && "trk".equals(this.reader.getLocalName()));
        AbstractFeature abstractFeature = ((Store)this.owner).types.track.newInstance();
        abstractFeature.setPropertyValue("sis:identifier", n);
        ArrayList<AbstractFeature> arrayList = null;
        List<Link> list = null;
        while (true) {
            block0 : switch (this.next()) {
                case 1: {
                    Object object;
                    String string = this.reader.getLocalName();
                    switch (this.isGPX() ? string : "") {
                        default: {
                            break block0;
                        }
                        case "name": 
                        case "cmt": 
                        case "desc": 
                        case "src": 
                        case "type": {
                            object = this.getElementText();
                            break;
                        }
                        case "number": {
                            object = this.getElementAsInteger();
                            break;
                        }
                        case "link": {
                            list = Metadata.addIfNonNull(list, this.unmarshal(Link.class));
                            break block0;
                        }
                        case "url": {
                            list = Metadata.addIfNonNull(list, Link.valueOf(this.getElementAsURI()));
                            break block0;
                        }
                        case "trk": {
                            throw new DataStoreContentException(this.nestedElement(string));
                        }
                        case "trkseg": {
                            if (arrayList == null) {
                                arrayList = new ArrayList<AbstractFeature>(8);
                            }
                            arrayList.add(this.parseTrackSegment(arrayList.size() + 1));
                            break block0;
                        }
                    }
                    abstractFeature.setPropertyValue(string, object);
                    break;
                }
                case 2: {
                    if (!"trk".equals(this.reader.getLocalName()) || !this.isGPX()) break;
                    if (arrayList != null) {
                        abstractFeature.setPropertyValue("trkseg", arrayList);
                    }
                    if (list != null) {
                        abstractFeature.setPropertyValue("link", list);
                    }
                    return abstractFeature;
                }
                case 8: {
                    throw new EOFException(this.endOfFile());
                }
            }
        }
    }
}

