/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.Shapes2D;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.j2d.IntervalRectangle;
import org.apache.sis.internal.referencing.provider.PolarStereographicA;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.gazetteer.AbstractLocation;
import org.apache.sis.referencing.gazetteer.GazetteerException;
import org.apache.sis.referencing.gazetteer.ModifiableLocationType;
import org.apache.sis.referencing.gazetteer.ReferenceVerifyException;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.referencing.gazetteer.SimpleLocation;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public class MilitaryGridReferenceSystem
extends ReferencingByIdentifiers {
    private static final long serialVersionUID = 8337394374656125471L;
    static final String IDENTIFIER = "MGRS";
    static final double LATITUDE_BAND_HEIGHT = 8.0;
    static final double GRID_SQUARE_SIZE = 100000.0;
    static final int GRID_ROW_COUNT = 20;
    static final int METRE_PRECISION_DIGITS = 5;
    private static final char EXCLUDE_I = 'I';
    private static final char EXCLUDE_O = 'O';
    private static final byte[] POLAR_COLUMNS = new byte[]{65, 66, 67, 70, 71, 72, 74, 75, 76, 80, 81, 82, 83, 84, 85, 88, 89, 90};
    private static final TransverseMercator.Zoner ZONER = TransverseMercator.Zoner.UTM;
    final CommonCRS datum;
    final boolean avoidDatumChange;
    private transient short southOffset;
    private transient short northOffset;
    private static MilitaryGridReferenceSystem INSTANCE;

    static synchronized MilitaryGridReferenceSystem getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MilitaryGridReferenceSystem();
        }
        return INSTANCE;
    }

    public MilitaryGridReferenceSystem() {
        super(MilitaryGridReferenceSystem.properties(), MilitaryGridReferenceSystem.types());
        this.datum = CommonCRS.WGS84;
        this.avoidDatumChange = false;
    }

    public MilitaryGridReferenceSystem(Map<String, ?> map, CommonCRS commonCRS) {
        super(map, MilitaryGridReferenceSystem.types());
        this.datum = commonCRS != null ? commonCRS : CommonCRS.WGS84;
        this.avoidDatumChange = commonCRS == null;
    }

    private static Map<String, ?> properties() {
        AbstractParty abstractParty = new AbstractParty("North Atlantic Treaty Organization", null);
        return MilitaryGridReferenceSystem.properties(new NamedIdentifier(null, "NATO", (CharSequence)org.apache.sis.internal.gazetteer.Resources.formatInternational((short)15), null, null), IDENTIFIER, abstractParty);
    }

    private static ModifiableLocationType[] types() {
        ModifiableLocationType modifiableLocationType = new ModifiableLocationType((CharSequence)org.apache.sis.internal.gazetteer.Resources.formatInternational((short)13));
        ModifiableLocationType modifiableLocationType2 = new ModifiableLocationType((CharSequence)org.apache.sis.internal.gazetteer.Resources.formatInternational((short)14));
        ModifiableLocationType modifiableLocationType3 = new ModifiableLocationType((CharSequence)org.apache.sis.internal.gazetteer.Resources.formatInternational((short)12));
        modifiableLocationType.addIdentification((CharSequence)Vocabulary.formatInternational((short)28));
        modifiableLocationType3.addIdentification((CharSequence)Vocabulary.formatInternational((short)35));
        modifiableLocationType2.addParent(modifiableLocationType);
        modifiableLocationType3.addParent(modifiableLocationType2);
        return new ModifiableLocationType[]{modifiableLocationType};
    }

    final int polarOffset(boolean bl) throws TransformException {
        short s;
        short s2 = s = bl ? this.southOffset : this.northOffset;
        if (s == 0) {
            DirectPosition2D directPosition2D = new DirectPosition2D(bl ? -80.0 : 84.0, 0.0);
            double d = this.datum.universal(directPosition2D.x * 1.01, directPosition2D.y).getConversionFromBase().getMathTransform().transform((DirectPosition)directPosition2D, (DirectPosition)directPosition2D).getOrdinate(1);
            if (bl) {
                d = 4000000.0 - d;
            }
            if ((double)(s = (short)(d = Math.floor(d / 100000.0))) != d) {
                throw new GazetteerException();
            }
            if (bl) {
                this.southOffset = s;
            } else {
                this.northOffset = s;
            }
        }
        return s;
    }

    @Override
    public Coder createCoder() {
        return new Coder();
    }

    public class Coder
    extends ReferencingByIdentifiers.Coder {
        private byte digits;
        private String separator;
        private String trimmedSeparator;
        private boolean clipToValidArea;
        private final Map<CoordinateReferenceSystem, Encoder> encoders;
        transient DirectPosition normalized;
        transient DirectPosition geographic;
        final StringBuilder buffer = new StringBuilder(18);

        protected Coder() {
            this.digits = (byte)5;
            this.trimmedSeparator = "";
            this.separator = "";
            this.encoders = new IdentityHashMap<CoordinateReferenceSystem, Encoder>();
            this.clipToValidArea = true;
        }

        Coder(Coder coder) {
            this.digits = coder.digits;
            this.separator = coder.separator;
            this.trimmedSeparator = coder.trimmedSeparator;
            this.clipToValidArea = coder.clipToValidArea;
            this.encoders = coder.encoders;
        }

        @Override
        public final MilitaryGridReferenceSystem getReferenceSystem() {
            return MilitaryGridReferenceSystem.this;
        }

        public double getPrecision() {
            return MathFunctions.pow10(5 - this.digits);
        }

        public void setPrecision(double d) {
            int n;
            try {
                n = DecimalFunctions.floorLog10(d);
            }
            catch (ArithmeticException arithmeticException) {
                throw new IllegalArgumentException(Errors.format((short)45, "precision", d), arithmeticException);
            }
            int n2 = Math.max(-3, Math.min(6, n));
            this.digits = (byte)(5 - n2);
        }

        final int digits() {
            return this.digits;
        }

        public Quantity<Length> getPrecision(DirectPosition directPosition) {
            return Quantities.create(this.getPrecision(), Units.METRE);
        }

        @Override
        public void setPrecision(Quantity<?> quantity, DirectPosition directPosition) throws IncommensurableException {
            ArgumentChecks.ensureNonNull("precision", quantity);
            double d = quantity.getValue().doubleValue();
            Unit unit = quantity.getUnit();
            if (Units.isAngular(unit)) {
                CoordinateReferenceSystem coordinateReferenceSystem;
                Ellipsoid ellipsoid = this.getEllipsoid();
                double d2 = 0.0;
                if (directPosition != null && (coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem()) != null) {
                    try {
                        double d3 = this.encoder(coordinateReferenceSystem).getLatitude(this, directPosition);
                        double d4 = Math.toRadians(d3);
                        d2 = Formulas.getRadius((Ellipsoid)ellipsoid, (double)d4);
                        if (d3 >= -80.0 && d3 < 84.0) {
                            d2 *= Math.cos(d4);
                        }
                    }
                    catch (IllegalArgumentException | TransformException | FactoryException throwable) {
                        Coder.recoverableException(Coder.class, "setPrecision", (Exception)throwable);
                    }
                }
                if (!(d2 > 0.0)) {
                    d2 = ellipsoid.getSemiMajorAxis();
                }
                d = unit.getConverterToAny(Units.RADIAN).convert(d) * d2;
            } else {
                d = unit.getConverterToAny(Units.METRE).convert(d);
            }
            this.setPrecision(d);
        }

        final Ellipsoid getEllipsoid() {
            return MilitaryGridReferenceSystem.this.datum.geographic().getDatum().getEllipsoid();
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String string) {
            ArgumentChecks.ensureNonNull("separator", string);
            this.separator = string;
            this.trimmedSeparator = CharSequences.trimWhitespaces(string);
        }

        public boolean getClipToValidArea() {
            return this.clipToValidArea;
        }

        public void setClipToValidArea(boolean bl) {
            this.clipToValidArea = bl;
        }

        final ProjectedCRS projection(double d, double d2) {
            return MilitaryGridReferenceSystem.this.datum.universal(d, d2);
        }

        final Encoder encoder(CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException, TransformException {
            if (coordinateReferenceSystem == null) {
                throw new GazetteerException(Errors.format((short)157));
            }
            Encoder encoder = this.encoders.get(coordinateReferenceSystem);
            if (encoder == null && this.encoders.put(coordinateReferenceSystem, encoder = new Encoder(MilitaryGridReferenceSystem.this.avoidDatumChange ? null : MilitaryGridReferenceSystem.this.datum, coordinateReferenceSystem)) != null) {
                throw new ConcurrentModificationException();
            }
            return encoder;
        }

        @Override
        public String encode(DirectPosition directPosition) throws TransformException {
            ArgumentChecks.ensureNonNull("position", directPosition);
            try {
                return this.encoder(directPosition.getCoordinateReferenceSystem()).encode(this, directPosition, true, this.getSeparator(), this.digits(), 0.0);
            }
            catch (IllegalArgumentException | FactoryException throwable) {
                throw new GazetteerException(throwable.getLocalizedMessage(), throwable);
            }
        }

        @Override
        public String encode(DirectPosition directPosition, Quantity<?> quantity) throws IncommensurableException, TransformException {
            ArgumentChecks.ensureNonNull("position", directPosition);
            ArgumentChecks.ensureNonNull("precision", quantity);
            double d = quantity.getValue().doubleValue();
            Unit unit = quantity.getUnit();
            if (Units.isAngular(unit)) {
                d = unit.getConverterToAny(Units.RADIAN).convert(d);
            } else {
                this.setPrecision(unit.getConverterToAny(Units.METRE).convert(d));
                d = 0.0;
            }
            try {
                return this.encoder(directPosition.getCoordinateReferenceSystem()).encode(this, directPosition, true, this.getSeparator(), this.digits(), d);
            }
            catch (IllegalArgumentException | FactoryException throwable) {
                throw new GazetteerException(throwable.getLocalizedMessage(), throwable);
            }
        }

        public Iterator<String> encode(Envelope envelope) throws TransformException {
            ArgumentChecks.ensureNonNull("areaOfInterest", envelope);
            try {
                return Spliterators.iterator(new IteratorAllZones(envelope).simplify());
            }
            catch (IllegalArgumentException | FactoryException throwable) {
                throw new GazetteerException(throwable);
            }
        }

        public Stream<String> encode(Envelope envelope, boolean bl) throws TransformException {
            ArgumentChecks.ensureNonNull("areaOfInterest", envelope);
            try {
                return StreamSupport.stream(new IteratorAllZones(envelope).simplify(), bl);
            }
            catch (IllegalArgumentException | FactoryException throwable) {
                throw new GazetteerException(throwable);
            }
        }

        @Override
        public AbstractLocation decode(CharSequence charSequence) throws TransformException {
            ArgumentChecks.ensureNonEmpty("reference", charSequence);
            return new Decoder(this, charSequence);
        }

        private final class IteratorAllZones
        implements Spliterator<String> {
            private final Spliterator<String>[] iterators;
            private int index;
            private int upper;

            IteratorAllZones(Envelope envelope) throws FactoryException, TransformException {
                SingleCRS singleCRS = CRS.getHorizontalComponent((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem());
                if (singleCRS == null) {
                    throw new GazetteerException(Resources.format((short)71, (Object)"areaOfInterest"));
                }
                int n = (int)Coder.this.getPrecision();
                if (n <= 0 || n > 100000) {
                    throw new GazetteerException(Errors.format((short)166, "precision", 1, 100000, n));
                }
                IntervalRectangle intervalRectangle = new IntervalRectangle(envelope.getLowerCorner(), envelope.getUpperCorner());
                Envelope envelope2 = Envelopes.transform((Envelope)envelope, (CoordinateReferenceSystem)MilitaryGridReferenceSystem.this.datum.normalizedGeographic());
                double d = envelope2.getMinimum(1);
                double d2 = envelope2.getMaximum(1);
                boolean bl = d < -80.0;
                boolean bl2 = d2 > 84.0;
                boolean bl3 = false;
                boolean bl4 = false;
                int n2 = 0;
                int n3 = 0;
                int n4 = ZONER.zoneCount();
                if (d2 >= -80.0 && d < 84.0) {
                    bl3 = d < 0.0;
                    boolean bl5 = bl4 = d2 >= 0.0;
                    if (envelope2.getSpan(0) > 360.0 - ZONER.width) {
                        n3 = n4;
                    } else {
                        n2 = ZONER.zone(0.0, envelope2.getLowerCorner().getOrdinate(0)) - 1;
                        n3 = ZONER.zone(0.0, envelope2.getUpperCorner().getOrdinate(0));
                        if (n3 < n2) {
                            n3 += n4;
                        }
                    }
                }
                this.upper = n3 - n2;
                if (bl3 & bl4) {
                    this.upper *= 2;
                }
                if (bl) {
                    this.upper += 2;
                }
                if (bl2) {
                    this.upper += 2;
                }
                this.iterators = new Spliterator[this.upper];
                int n5 = n2;
                this.upper = 0;
                do {
                    double d3;
                    double d4 = ZONER.centralMeridian(n5 % n4 + 1);
                    if (bl) {
                        d3 = -90.0;
                        bl = false;
                    } else if (bl3) {
                        d3 = -1.0;
                        if (++n5 >= n3) {
                            n5 = n2;
                            bl3 = false;
                        }
                    } else if (bl4) {
                        d3 = 1.0;
                        if (++n5 >= n3) {
                            bl4 = false;
                        }
                    } else if (bl2) {
                        d3 = 90.0;
                        bl2 = false;
                    } else {
                        throw new AssertionError();
                    }
                    ProjectedCRS projectedCRS = MilitaryGridReferenceSystem.this.datum.universal(d3, d4);
                    Spliterator<String> spliterator = new IteratorOneZone(Coder.this, (Rectangle2D)intervalRectangle, envelope2, singleCRS, projectedCRS, n);
                    do {
                        this.iterators[this.upper++] = spliterator;
                    } while ((spliterator = spliterator.trySplit()) != null);
                } while (bl | bl2 | bl3 | bl4);
            }

            private IteratorAllZones(IteratorAllZones iteratorAllZones) {
                this.iterators = iteratorAllZones.iterators;
                this.index = iteratorAllZones.index;
                iteratorAllZones.index = this.upper = (iteratorAllZones.upper + this.index) / 2;
            }

            @Override
            public Spliterator<String> trySplit() {
                return this.upper - this.index >= 2 ? new IteratorAllZones(this).simplify() : null;
            }

            final Spliterator<String> simplify() {
                return this.upper - this.index == 1 ? this.iterators[this.index] : this;
            }

            @Override
            public long estimateSize() {
                long l = 0L;
                for (int i = this.index; i < this.upper; ++i) {
                    l += this.iterators[i].estimateSize();
                }
                return l;
            }

            @Override
            public boolean tryAdvance(Consumer<? super String> consumer) {
                while (this.index < this.upper) {
                    if (this.iterators[this.index].tryAdvance(consumer)) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super String> consumer) {
                while (this.index < this.upper) {
                    this.iterators[this.index++].forEachRemaining(consumer);
                }
            }

            @Override
            public int characteristics() {
                return 1281;
            }
        }
    }

    static final class Decoder
    extends SimpleLocation.Projected {
        static final int NORTHING_BITS_COUNT = 4;
        static final int NORTHING_BITS_MASK = 15;
        private static final int[] ROW_RESOLVER = new int[]{16744464, 16369, 4190209, 14682097, 1047554, 16253426, 261891, 16646259, 65476, 16744452, 8176, 0x3FF000, 14682096, 1047553, 16253425, 261890, 16646258, 65475, 16760835, 0x83FFF3};
        private final ProjectedCRS crs;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Decoder(Coder coder, CharSequence charSequence) throws TransformException {
            super(coder.getReferenceSystem().rootType(), charSequence);
            String string;
            double d;
            double d2;
            double d3;
            int n;
            int n2;
            double d4;
            boolean bl;
            double d5;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            boolean bl2 = true;
            int n8 = CharSequences.skipTrailingWhitespaces(charSequence, 0, charSequence.length());
            int n9 = CharSequences.skipLeadingWhitespaces(charSequence, 0, n8);
            int n10 = Decoder.endOfDigits(charSequence, n9, n8);
            if (n10 == n9 && n10 < n8) {
                n7 = 0;
                n6 = 0;
                boolean bl3 = false;
                n5 = 0;
                int n11 = 0;
                block23: for (n4 = 0; n4 <= 2; ++n4) {
                    CharSequence charSequence2;
                    short s;
                    n3 = Character.codePointAt(charSequence, n10);
                    int n12 = n10 + Character.charCount(n3);
                    if (Decoder.isLetter(n3) || Decoder.isLetter(n3 -= 32)) {
                        block1 : switch (n4) {
                            case 0: {
                                switch (n3) {
                                    case 65: {
                                        n6 = 1;
                                        bl3 = true;
                                        break;
                                    }
                                    case 66: {
                                        n6 = 1;
                                        break;
                                    }
                                    case 89: {
                                        bl3 = true;
                                        break;
                                    }
                                    case 90: {
                                        break;
                                    }
                                    default: {
                                        break block1;
                                    }
                                }
                                n10 = Decoder.nextComponent(coder, charSequence, n9, n12, n8);
                                continue block23;
                            }
                            case 1: {
                                n5 = Arrays.binarySearch(POLAR_COLUMNS, (byte)n3);
                                if (n5 < 0) break;
                                if (bl3) {
                                    n5 -= POLAR_COLUMNS.length;
                                }
                                n5 = (int)((double)n5 + 20.0);
                                n10 = Decoder.nextComponent(coder, charSequence, n9, n12, n8);
                                continue block23;
                            }
                            case 2: {
                                if (n3 >= 79) {
                                    --n3;
                                }
                                if (n3 >= 73) {
                                    --n3;
                                }
                                n11 = n3 - 65 + coder.getReferenceSystem().polarOffset(n6 != 0);
                                n10 = n12;
                                continue block23;
                            }
                        }
                    }
                    if (n4 == 0) {
                        s = 4;
                        charSequence2 = charSequence.subSequence(n10, n12);
                        throw new GazetteerException(org.apache.sis.internal.gazetteer.Resources.format(s, charSequence2));
                    }
                    s = 3;
                    charSequence2 = CharSequences.token(charSequence, n10);
                    throw new GazetteerException(org.apache.sis.internal.gazetteer.Resources.format(s, charSequence2));
                }
                d5 = n6 != 0 ? -90.0 : 90.0;
                this.crs = coder.projection(d5, 0.0);
                this.minX = (double)n5 * 100000.0;
                this.minY = (double)n11 * 100000.0;
                bl = true;
                d4 = 0.0;
            } else {
                int n13;
                n7 = Decoder.parseInt(charSequence, n9, n10, (short)5);
                if (n7 < 1) throw new GazetteerException(org.apache.sis.internal.gazetteer.Resources.format((short)5, n7));
                if (n7 > 60) {
                    throw new GazetteerException(org.apache.sis.internal.gazetteer.Resources.format((short)5, n7));
                }
                n6 = -1;
                int n14 = 1;
                n5 = 0;
                bl = true;
                for (n13 = 0; n13 <= 2; ++n13) {
                    if (n13 == 1 && n10 >= n8) {
                        bl = false;
                        break;
                    }
                    n10 = Decoder.nextComponent(coder, charSequence, n9, n10, n8);
                    n4 = Character.codePointAt(charSequence, n10);
                    n3 = n10 + Character.charCount(n4);
                    if (!Decoder.isLetter(n4) && !Decoder.isLetter(n4 -= 32)) {
                        CharSequence charSequence3;
                        short s;
                        if (n13 == 0) {
                            s = 2;
                            charSequence3 = charSequence.subSequence(n10, n3);
                            throw new GazetteerException(org.apache.sis.internal.gazetteer.Resources.format(s, charSequence3));
                        }
                        s = 3;
                        charSequence3 = CharSequences.token(charSequence, n10);
                        throw new GazetteerException(org.apache.sis.internal.gazetteer.Resources.format(s, charSequence3));
                    }
                    if (n4 >= 79) {
                        --n4;
                    }
                    if (n4 >= 73) {
                        --n4;
                    }
                    switch (n13) {
                        case 0: {
                            n6 = n4 - 67;
                            break;
                        }
                        case 1: {
                            switch (n7 % 3) {
                                case 1: {
                                    n14 = n4 - 64;
                                    break;
                                }
                                case 2: {
                                    n14 = n4 - 72;
                                    break;
                                }
                                case 0: {
                                    n14 = n4 - 80;
                                    break;
                                }
                            }
                            break;
                        }
                        case 2: {
                            if ((n7 & 1) != 0) {
                                n5 = n4 - 65;
                                break;
                            }
                            n5 = n4 - 70;
                            if (n5 >= 0) break;
                            n5 += 20;
                            break;
                        }
                    }
                    n10 = n3;
                }
                d5 = (double)n6 * 8.0 + -80.0;
                if (n6 < 0) throw new GazetteerException(org.apache.sis.internal.gazetteer.Resources.format((short)2, Character.valueOf(Encoder.latitudeBand(d5))));
                if (n6 >= ROW_RESOLVER.length) {
                    throw new GazetteerException(org.apache.sis.internal.gazetteer.Resources.format((short)2, Character.valueOf(Encoder.latitudeBand(d5))));
                }
                d4 = ZONER.centralMeridian(n7);
                this.crs = coder.projection(Math.signum(d5), d4);
                n13 = ROW_RESOLVER[n6];
                if (bl) {
                    n4 = 1 << n5 + 4;
                    boolean bl4 = bl2 = (n13 & n4) != 0;
                    if (bl2) {
                        n4 = Integer.lowestOneBit(~(n13 | n4 - 1));
                    }
                    if ((n13 & -n4) != 0) {
                        n5 += 20;
                    }
                }
                this.minX = (double)n14 * 100000.0;
                this.minY = (double)(n5 += (n13 & 0xF) * 20) * 100000.0;
            }
            if (n10 < n8) {
                double d6;
                n4 = Decoder.endOfDigits(charSequence, n10 = Decoder.nextComponent(coder, charSequence, n9, n10, n8), n8);
                if (n4 >= n8) {
                    n2 = n4 - n10;
                    if ((n2 & 1) != 0) {
                        throw new GazetteerException(org.apache.sis.internal.gazetteer.Resources.format((short)7, charSequence.subSequence(n10, n4)));
                    }
                    n = n10 + (n2 >>>= 1);
                    d2 = d3 = MathFunctions.pow10(5 - n2);
                    d6 = Decoder.parseCoordinate(charSequence, n10, n, d2);
                    d = Decoder.parseCoordinate(charSequence, n, n4, d3);
                } else {
                    d2 = MathFunctions.pow10(5 - (n4 - n10));
                    d6 = Decoder.parseCoordinate(charSequence, n10, n4, d2);
                    n10 = Decoder.nextComponent(coder, charSequence, n9, n4, n8);
                    n4 = Decoder.endOfDigits(charSequence, n10, n8);
                    d3 = MathFunctions.pow10(5 - (n4 - n10));
                    d = Decoder.parseCoordinate(charSequence, n10, n4, d3);
                    if (n4 < n8) {
                        throw new GazetteerException(Errors.format((short)135, charSequence.subSequence(n9, n4), CharSequences.trimWhitespaces(charSequence, n4, n8)));
                    }
                }
                this.minX += d6;
                this.minY += d;
            } else if (bl) {
                d3 = 100000.0;
                d2 = 100000.0;
            } else {
                d2 = (ZONER.easting - 100000.0) * 2.0;
                d3 = ZONER.northing;
            }
            this.maxX = this.minX + d2;
            this.maxY = this.minY + d3;
            if (!bl) {
                if (n7 != 0) {
                    if (d5 < 0.0) {
                        this.southBoundLatitude = -80.0;
                        this.northBoundLatitude = 0.0;
                    } else {
                        this.southBoundLatitude = 0.0;
                        this.northBoundLatitude = 84.0;
                    }
                    this.westBoundLongitude = d4 - ZONER.width / 2.0;
                    this.eastBoundLongitude = d4 + ZONER.width / 2.0;
                } else {
                    if (d5 < 0.0) {
                        this.southBoundLatitude = -90.0;
                        this.northBoundLatitude = -80.0;
                    } else {
                        this.southBoundLatitude = 84.0;
                        this.northBoundLatitude = 90.0;
                    }
                    this.westBoundLongitude = -180.0;
                    this.eastBoundLongitude = 180.0;
                }
            } else {
                MathTransform mathTransform = this.crs.getConversionFromBase().getMathTransform();
                this.computeGeographicBoundingBox(mathTransform.inverse());
                this.setTypeToChild();
                if (d2 < 100000.0 || d3 < 100000.0) {
                    this.setTypeToChild();
                }
                if (bl2 && n7 != 0) {
                    boolean bl5 = bl2 = this.northBoundLatitude >= d5 && this.southBoundLatitude < Decoder.upperBound(d5);
                    if (bl2) {
                        double d7 = (this.westBoundLongitude + this.eastBoundLongitude) / 2.0;
                        d = (this.southBoundLatitude + this.northBoundLatitude) / 2.0;
                        n2 = ZONER.zone(d, d7) - n7;
                        if (n2 != 0) {
                            n = ZONER.zoneCount();
                            if (n2 < n / -2) {
                                n2 += n;
                            }
                            if (n2 > n / 2) {
                                n2 -= n;
                            }
                            if (ZONER.isSpecialCase(n7, d)) {
                                bl2 = Math.abs(n2) <= 2;
                            } else {
                                double d8 = Math.IEEEremainder(d7 - ZONER.origin, ZONER.width);
                                double d9 = (this.minX - ZONER.easting) / (d7 - d4);
                                boolean bl6 = bl2 = Math.abs(d8) * d9 <= d2;
                                if (bl2) {
                                    boolean bl7 = bl2 = n2 == (d8 < 0.0 ? -1 : 1);
                                }
                            }
                        }
                    }
                }
                if (bl2 && coder.getClipToValidArea()) {
                    boolean bl8;
                    if (n7 != 0) {
                        double d10 = ZONER.width;
                        if (!ZONER.isSpecialCase(n7, d5)) {
                            d10 /= 2.0;
                        }
                        bl8 = this.clipGeographicBoundingBox(d4 - d10, d5, d4 + d10, Decoder.upperBound(d5));
                    } else {
                        bl8 = d5 < 0.0 ? this.clipGeographicBoundingBox(-180.0, -90.0, 180.0, -80.0) : this.clipGeographicBoundingBox(-180.0, 84.0, 180.0, 90.0);
                    }
                    if (bl8) {
                        this.clipProjectedEnvelope(mathTransform, d2 / 100.0, d3 / 100.0);
                    }
                }
            }
            if (bl2) return;
            try {
                string = coder.encoder((CoordinateReferenceSystem)this.crs).encode(coder, this.getDirectPosition(), true, "", 0, 0.0);
            }
            catch (IllegalArgumentException | FactoryException throwable) {
                throw new GazetteerException(throwable.getLocalizedMessage(), throwable);
            }
            CharSequence charSequence4 = charSequence.subSequence(n9, n8);
            throw new ReferenceVerifyException(org.apache.sis.internal.gazetteer.Resources.format((short)6, charSequence4, string));
        }

        private static int nextComponent(Coder coder, CharSequence charSequence, int n, int n2, int n3) throws GazetteerException {
            if ((n2 = CharSequences.skipLeadingWhitespaces(charSequence, n2, n3)) < n3) {
                if (!CharSequences.regionMatches(charSequence, n2, coder.trimmedSeparator)) {
                    return n2;
                }
                n2 += coder.trimmedSeparator.length();
                if ((n2 = CharSequences.skipLeadingWhitespaces(charSequence, n2, n3)) < n3) {
                    return n2;
                }
            }
            throw new GazetteerException(Errors.format((short)138, charSequence.subSequence(n, n3)));
        }

        private static boolean isLetter(int n) {
            return n >= 65 && n <= 90 && n != 73 && n != 79;
        }

        private static int endOfDigits(CharSequence charSequence, int n, int n2) {
            char c;
            while (n < n2 && (c = charSequence.charAt(n)) >= '0' && c <= '9') {
                ++n;
            }
            return n;
        }

        private static int parseInt(CharSequence charSequence, int n, int n2, short s) throws GazetteerException {
            CharSequence charSequence2;
            NumberFormatException numberFormatException = null;
            if (n == n2) {
                charSequence2 = CharSequences.token(charSequence, n);
            } else {
                charSequence2 = charSequence.subSequence(n, n2);
                try {
                    return Integer.parseInt(charSequence2.toString());
                }
                catch (NumberFormatException numberFormatException2) {
                    numberFormatException = numberFormatException2;
                }
            }
            throw new GazetteerException(org.apache.sis.internal.gazetteer.Resources.format(s, charSequence2), numberFormatException);
        }

        private static double parseCoordinate(CharSequence charSequence, int n, int n2, double d) throws GazetteerException {
            return (double)Decoder.parseInt(charSequence, n, n2, (short)1) * d;
        }

        static double upperBound(double d) {
            return d < 72.0 ? d + 8.0 : 84.0;
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return this.crs;
        }
    }

    static final class Encoder {
        private static final int POLE = 100;
        private final CommonCRS datum;
        final int crsZone;
        private final MathTransform toNormalized;
        private final MathTransform toGeographic;
        private MathTransform toActualZone;
        private int actualZone;
        char latitudeBand;

        Encoder(CommonCRS commonCRS, CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException, TransformException {
            SingleCRS singleCRS = CRS.getHorizontalComponent((CoordinateReferenceSystem)coordinateReferenceSystem);
            if (singleCRS == null) {
                singleCRS = coordinateReferenceSystem;
            }
            if (commonCRS == null) {
                commonCRS = CommonCRS.forDatum((CoordinateReferenceSystem)singleCRS);
            }
            this.datum = commonCRS;
            if (singleCRS instanceof ProjectedCRS) {
                ProjectedCRS projectedCRS = (ProjectedCRS)singleCRS;
                Projection projection = projectedCRS.getConversionFromBase();
                OperationMethod operationMethod = projection.getMethod();
                this.crsZone = IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)operationMethod, (String)"Transverse Mercator") ? ZONER.zone(projection.getParameterValues()) : (IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)operationMethod, (String)"Polar Stereographic (variant A)") ? 100 * PolarStereographicA.isUPS((ParameterValueGroup)projection.getParameterValues()) : 0);
                if (this.crsZone != 0) {
                    DefaultProjectedCRS defaultProjectedCRS = DefaultProjectedCRS.castOrCopy((ProjectedCRS)projectedCRS);
                    projectedCRS = defaultProjectedCRS.forConvention(AxesConvention.NORMALIZED);
                    if (coordinateReferenceSystem != singleCRS || projectedCRS != defaultProjectedCRS) {
                        this.toNormalized = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)projectedCRS, null).getMathTransform();
                        projection = projectedCRS.getConversionFromBase();
                        singleCRS = projectedCRS;
                        coordinateReferenceSystem = projectedCRS;
                    } else {
                        this.toNormalized = null;
                    }
                } else {
                    this.toNormalized = null;
                }
                if (coordinateReferenceSystem == singleCRS && Utilities.equalsIgnoreMetadata(projectedCRS.getBaseCRS(), commonCRS.geographic())) {
                    this.toGeographic = projection.getMathTransform().inverse();
                    return;
                }
            } else {
                this.crsZone = 0;
                this.toNormalized = null;
            }
            this.toGeographic = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)commonCRS.geographic(), null).getMathTransform();
        }

        static char latitudeBand(double d) {
            int n = 67 + (int)((d - -80.0) / 8.0);
            if (n >= 73 && ++n >= 79 && ++n == 89) {
                n = 88;
            }
            assert (n >= 67 && n <= 88) : n;
            return (char)n;
        }

        final double getLatitude(Coder coder, DirectPosition directPosition) throws TransformException {
            if (this.toNormalized != null) {
                coder.normalized = directPosition = this.toNormalized.transform(directPosition, coder.normalized);
            }
            coder.geographic = directPosition = this.toGeographic.transform(directPosition, coder.geographic);
            return directPosition.getOrdinate(0);
        }

        String encode(Coder coder, DirectPosition directPosition, boolean bl, String string, int n, double d) throws FactoryException, TransformException {
            int n2;
            DirectPosition directPosition2;
            if (this.toNormalized != null) {
                coder.normalized = directPosition = this.toNormalized.transform(directPosition, coder.normalized);
            }
            coder.geographic = directPosition2 = this.toGeographic.transform(directPosition, coder.geographic);
            double d2 = directPosition2.getOrdinate(1);
            double d3 = directPosition2.getOrdinate(0);
            boolean bl2 = d3 >= -80.0 && d3 < 84.0;
            int n3 = bl2 ? ZONER.zone(d3, d2) : 100;
            int n4 = n2 = MathFunctions.isNegative(d3) ? -n3 : n3;
            if (n2 == 0) {
                throw new GazetteerException(Errors.format((short)110, "longitude"));
            }
            if (n2 != this.crsZone) {
                if (!bl) {
                    return null;
                }
                if (n2 != this.actualZone) {
                    this.actualZone = 0;
                    this.toActualZone = CRS.findOperation((CoordinateReferenceSystem)this.datum.geographic(), (CoordinateReferenceSystem)this.datum.universal(d3, d2), null).getMathTransform();
                    this.actualZone = n2;
                }
                directPosition2.setOrdinate(1, Longitude.normalize(d2));
                coder.normalized = directPosition = this.toActualZone.transform(directPosition2, coder.normalized);
            }
            if (d > 0.0) {
                double d4 = Math.toRadians(d3);
                d *= Formulas.getRadius((Ellipsoid)coder.getEllipsoid(), (double)d4);
                if (bl2) {
                    d *= Math.cos(d4);
                }
                coder.setPrecision(d);
                n = coder.digits();
            }
            StringBuilder stringBuilder = coder.buffer;
            stringBuilder.setLength(0);
            if (bl2) {
                stringBuilder.append(n3).append(string);
                this.latitudeBand = Encoder.latitudeBand(d3);
            } else {
                this.latitudeBand = (char)(n2 < 0 ? 65 : 89);
                if (d2 >= 0.0) {
                    this.latitudeBand = (char)(this.latitudeBand + '\u0001');
                }
            }
            stringBuilder.append(this.latitudeBand);
            if (n >= 0) {
                double d5 = directPosition.getOrdinate(0);
                double d6 = directPosition.getOrdinate(1);
                double d7 = Math.floor(d5 / 100000.0);
                double d8 = Math.floor(d6 / 100000.0);
                int n5 = (int)d7;
                int n6 = (int)d8;
                if (bl2) {
                    if (n5 < 1 || n5 > 8) {
                        throw new GazetteerException(Errors.format((short)119));
                    }
                    switch (n3 % 3) {
                        case 1: {
                            n5 += 64;
                            break;
                        }
                        case 2: {
                            if ((n5 += 73) < 79) break;
                            ++n5;
                            break;
                        }
                        case 0: {
                            n5 += 82;
                        }
                    }
                    if ((n3 & 1) == 0) {
                        n6 += 5;
                    }
                    n6 %= 20;
                } else {
                    byte[] byArray = POLAR_COLUMNS;
                    n5 = (int)((double)n5 - 20.0);
                    if (!(d2 >= 0.0)) {
                        n5 += byArray.length;
                    }
                    if (n5 < 0 || n5 >= byArray.length) {
                        throw new GazetteerException(Errors.format((short)119));
                    }
                    n5 = byArray[n5];
                    n6 -= coder.getReferenceSystem().polarOffset(n2 < 0);
                }
                if ((n6 += 65) >= 73 && ++n6 >= 79) {
                    ++n6;
                }
                stringBuilder.append(string).append(Encoder.letter(n5)).append(Encoder.letter(n6));
                if (n > 0) {
                    d = MathFunctions.pow10(5 - n);
                    Encoder.append(stringBuilder.append(string), (int)((d5 - d7 * 100000.0) / d), n);
                    Encoder.append(stringBuilder.append(string), (int)((d6 - d8 * 100000.0) / d), n);
                }
            }
            return stringBuilder.toString();
        }

        private static char letter(int n) throws GazetteerException {
            if (n >= 65 && n <= 90) {
                return (char)n;
            }
            throw new GazetteerException(Errors.format((short)119));
        }

        private static void append(StringBuilder stringBuilder, int n, int n2) throws GazetteerException {
            if (n >= 0) {
                int n3 = stringBuilder.length();
                if ((n2 -= stringBuilder.append(n).length() - n3) >= 0) {
                    StringBuilders.repeat(stringBuilder, n3, '0', n2);
                    return;
                }
            }
            throw new GazetteerException(Errors.format((short)119));
        }
    }

    private final class IteratorOneZone
    extends Coder
    implements Spliterator<String> {
        private final Rectangle2D areaOfInterest;
        private final MathTransform2D gridToAOI;
        private final Encoder encoder;
        private final int xCenter;
        private final int xEnd;
        private int yStart;
        private int yEnd;
        private int gridX;
        private int gridY;
        private final int step;
        private final boolean downward;
        private final boolean optimize;
        private char latitudeBand;
        private String pending;
        private final Envelope2D cell;

        IteratorOneZone(Coder coder, Rectangle2D rectangle2D, Envelope envelope, SingleCRS singleCRS, ProjectedCRS projectedCRS, int n) throws FactoryException, TransformException {
            CoordinateOperation coordinateOperation;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            super(coder);
            this.cell = new Envelope2D();
            this.areaOfInterest = rectangle2D;
            this.encoder = this.encoder((CoordinateReferenceSystem)projectedCRS);
            this.step = n;
            int n2 = Math.abs(this.encoder.crsZone);
            if (n2 == 100) {
                this.xCenter = 2000000;
                if (this.encoder.crsZone < 0) {
                    d9 = -90.0;
                    d8 = -80.0;
                } else {
                    d9 = 84.0;
                    d8 = 90.0;
                }
                d7 = -180.0;
                d6 = 180.0;
            } else {
                this.xCenter = (int)ZONER.easting;
                if (this.encoder.crsZone < 0) {
                    d9 = -80.0;
                    d8 = 0.0;
                } else {
                    d9 = 0.0;
                    d8 = 84.0;
                }
                d5 = ZONER.centralMeridian(n2);
                d7 = d5 - ZONER.width / 2.0;
                d6 = d5 + ZONER.width / 2.0;
            }
            boolean bl = false;
            d5 = envelope.getMinimum(1);
            if (d4 >= d9) {
                d9 = d5;
            } else {
                bl = true;
            }
            d5 = envelope.getMaximum(1);
            if (d3 <= d8) {
                d8 = d5;
            } else {
                bl = true;
            }
            d5 = envelope.getMinimum(0);
            if (d2 >= d7) {
                d7 = d5;
            } else {
                bl = true;
            }
            d5 = envelope.getMaximum(0);
            if (d <= d6) {
                d6 = d5;
            } else {
                bl = true;
            }
            boolean bl2 = ZONER.isSpecialCase(d9, d8, d7, d6);
            if (bl) {
                coordinateOperation = new IntervalRectangle(d7, d9, d6, d8);
                coordinateOperation.setRect(Shapes2D.transform((CoordinateOperation)CRS.findOperation((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)singleCRS, null), (Rectangle2D)coordinateOperation, (Rectangle2D)coordinateOperation));
                coordinateOperation.intersect(rectangle2D);
                if (coordinateOperation.xmax < coordinateOperation.xmin) {
                    coordinateOperation.xmin = d7;
                    coordinateOperation.xmax = d6;
                }
                rectangle2D = coordinateOperation;
            }
            coordinateOperation = CRS.findOperation((CoordinateReferenceSystem)singleCRS, (CoordinateReferenceSystem)projectedCRS, null);
            Rectangle2D rectangle2D2 = Shapes2D.transform((CoordinateOperation)coordinateOperation, (Rectangle2D)rectangle2D, null);
            this.gridX = (int)(rectangle2D2.getMinX() / (double)n) * n;
            this.gridY = (int)(rectangle2D2.getMinY() / (double)n) * n;
            this.xEnd = (int)Math.ceil(rectangle2D2.getMaxX() / (double)n) * n;
            this.yEnd = (int)Math.ceil(rectangle2D2.getMaxY() / (double)n) * n;
            if (n2 != 100) {
                this.downward = this.encoder.crsZone < 0;
            } else {
                boolean bl3 = this.downward = this.yEnd <= 2000000;
                bl2 |= d7 != -180.0 || d6 != 180.0 || (this.encoder.crsZone < 0 ? d9 != -90.0 : d8 != 90.0);
            }
            if (this.downward) {
                int n3 = this.gridY;
                this.gridY = this.yEnd - n;
                this.yEnd = n3 - n;
            }
            this.yStart = this.gridY;
            this.gridToAOI = MathTransforms.bidimensional((MathTransform)coordinateOperation.getMathTransform().inverse());
            this.optimize = !bl2 && Utilities.equalsIgnoreMetadata(envelope.getCoordinateReferenceSystem(), singleCRS);
        }

        private IteratorOneZone(IteratorOneZone iteratorOneZone) {
            super(iteratorOneZone);
            this.cell = new Envelope2D();
            this.areaOfInterest = iteratorOneZone.areaOfInterest;
            this.gridToAOI = iteratorOneZone.gridToAOI;
            this.encoder = iteratorOneZone.encoder;
            this.optimize = iteratorOneZone.optimize;
            this.step = iteratorOneZone.step;
            this.gridX = iteratorOneZone.gridX;
            this.xCenter = iteratorOneZone.xCenter;
            this.xEnd = iteratorOneZone.xEnd;
            this.yEnd = iteratorOneZone.yStart - this.step;
            this.yStart = 2000000 - this.step;
            iteratorOneZone.gridY = iteratorOneZone.yStart = 2000000;
            this.gridY = this.yStart;
            this.downward = true;
            assert (!iteratorOneZone.downward);
        }

        @Override
        public Spliterator<String> trySplit() {
            if (!this.downward && Math.abs(this.encoder.crsZone) == 100 && this.gridY < 2000000) {
                return new IteratorOneZone(this);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return ((long)this.xEnd - (long)this.gridX) * Math.abs((long)this.yEnd - (long)this.yStart) / JDK9.multiplyFull(this.step, this.step);
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> consumer) {
            return this.advance(consumer, false);
        }

        @Override
        public void forEachRemaining(Consumer<? super String> consumer) {
            this.advance(consumer, true);
            if (this.pending != null) {
                consumer.accept(this.pending);
                this.pending = null;
            }
        }

        private boolean advance(Consumer<? super String> consumer, boolean bl) {
            int n = this.digits();
            String string = this.getSeparator();
            if (this.normalized == null) {
                this.normalized = new DirectPosition2D();
            }
            boolean bl2 = false;
            try {
                do {
                    int n2;
                    if (this.pending != null) {
                        consumer.accept(this.pending);
                        this.pending = null;
                        bl2 = true;
                        continue;
                    }
                    this.cell.setRect((double)this.gridX, (double)this.gridY, (double)this.step, (double)this.step);
                    this.cell.setRect(Shapes2D.transform((MathTransform2D)this.gridToAOI, (Rectangle2D)this.cell, (Rectangle2D)this.cell));
                    if (this.cell.intersects(this.areaOfInterest)) {
                        n2 = this.gridX;
                        int n3 = this.gridY;
                        if (n2 < this.xCenter) {
                            n2 += this.step - 1;
                        }
                        if (this.downward) {
                            n3 += this.step - 1;
                        }
                        this.normalized.setOrdinate(0, (double)n2);
                        this.normalized.setOrdinate(1, (double)n3);
                        String string2 = this.encoder.encode(this, this.normalized, false, string, n, 0.0);
                        if (string2 != null) {
                            char c = this.latitudeBand;
                            this.latitudeBand = this.encoder.latitudeBand;
                            if (this.latitudeBand != c && c != '\u0000') {
                                this.pending = string2;
                                this.normalized.setOrdinate(1, (double)(n3 + (this.downward ? 1 : -1)));
                                string2 = this.encoder.encode(this, this.normalized, false, string, n, 0.0);
                                if (string2 == null || this.encoder.latitudeBand == c) {
                                    string2 = this.pending;
                                    this.pending = null;
                                }
                            }
                            consumer.accept(string2);
                            bl2 = true;
                        }
                    } else if (this.optimize) {
                        this.gridY = this.yEnd;
                    }
                    int n4 = this.downward ? ((this.gridY -= this.step) <= this.yEnd ? 1 : 0) : (n2 = (this.gridY += this.step) >= this.yEnd ? 1 : 0);
                    if (n2 == 0) continue;
                    this.gridY = this.yStart;
                    this.latitudeBand = '\u0000';
                    if ((this.gridX += this.step) >= this.xEnd) break;
                } while (bl || !bl2);
            }
            catch (TransformException | FactoryException throwable) {
                throw (ArithmeticException)new ArithmeticException(Errors.format((short)119)).initCause(throwable);
            }
            return bl2;
        }

        @Override
        public int characteristics() {
            return 1281;
        }

        public String toString() {
            return Strings.toString(this.getClass(), "zone", this.encoder.crsZone, "downward", this.downward, "yStart", this.yStart, "yEnd", this.yEnd, "gridX", this.gridX, "xEnd", this.xEnd);
        }
    }
}

