/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.gazetteer.AbstractLocation;
import org.apache.sis.referencing.gazetteer.GazetteerException;
import org.apache.sis.referencing.gazetteer.ModifiableLocationType;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.referencing.gazetteer.SimpleLocation;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public class GeohashReferenceSystem
extends ReferencingByIdentifiers {
    private static final long serialVersionUID = 9162259764027168776L;
    static final String IDENTIFIER = "Geohash";
    final Format format;
    final DefaultGeographicCRS normalizedCRS;
    final CoordinateOperation denormalize;
    private static GeohashReferenceSystem INSTANCE;

    static synchronized GeohashReferenceSystem getInstance() throws GazetteerException {
        if (INSTANCE == null) {
            INSTANCE = new GeohashReferenceSystem(Format.BASE32, CommonCRS.WGS84.geographic());
        }
        return INSTANCE;
    }

    public GeohashReferenceSystem(Format format, GeographicCRS geographicCRS) throws GazetteerException {
        super(GeohashReferenceSystem.properties(IDENTIFIER, IDENTIFIER, null), GeohashReferenceSystem.types());
        ArgumentChecks.ensureNonNull("format", (Object)format);
        ArgumentChecks.ensureNonNull("crs", geographicCRS);
        ArgumentChecks.ensureDimensionMatches("crs", 2, (CoordinateReferenceSystem)geographicCRS);
        this.format = format;
        this.normalizedCRS = DefaultGeographicCRS.castOrCopy((GeographicCRS)geographicCRS).forConvention(AxesConvention.NORMALIZED);
        try {
            this.denormalize = CRS.findOperation((CoordinateReferenceSystem)this.normalizedCRS, (CoordinateReferenceSystem)geographicCRS, null);
        }
        catch (FactoryException factoryException) {
            throw new GazetteerException(factoryException.getLocalizedMessage(), factoryException);
        }
    }

    private static ModifiableLocationType[] types() {
        ModifiableLocationType modifiableLocationType = new ModifiableLocationType(IDENTIFIER);
        modifiableLocationType.addIdentification((CharSequence)Vocabulary.formatInternational((short)28));
        return new ModifiableLocationType[]{modifiableLocationType};
    }

    public Format getFormat() {
        return this.format;
    }

    @Override
    public Coder createCoder() {
        return new Coder();
    }

    public static enum Format {
        BASE32(16, new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 98, 99, 100, 101, 102, 103, 104, 106, 107, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122});

        final int highestOneBit;
        final byte[] encoding;
        final byte[] decodingLowerCase;
        final byte[] decodingUpperCase;

        private Format(int n2, byte[] byArray) {
            this.highestOneBit = n2;
            this.encoding = byArray;
            byte[] byArray2 = new byte[26];
            for (int n3 = 10; n3 < byArray.length; n3 = (int)((byte)(n3 + 1))) {
                byArray2[byArray[n3] - 97] = n3;
            }
            this.decodingLowerCase = byArray2;
            this.decodingUpperCase = byArray2;
        }
    }

    public class Coder
    extends ReferencingByIdentifiers.Coder {
        private int length = 12;
        private transient char[] buffer;
        private transient CoordinateOperation lastOp;
        private final transient double[] coordinates;

        protected Coder() {
            this.coordinates = GeohashReferenceSystem.this.denormalize.getMathTransform().isIdentity() ? null : new double[8];
        }

        @Override
        public final GeohashReferenceSystem getReferenceSystem() {
            return GeohashReferenceSystem.this;
        }

        public int getHashLength() {
            return this.length;
        }

        public void setHashLength(int n) {
            ArgumentChecks.ensureBetween("length", 1, 255, n);
            this.length = n;
            this.buffer = null;
        }

        public Quantity<Length> getPrecision(DirectPosition directPosition) {
            Ellipsoid ellipsoid = GeohashReferenceSystem.this.normalizedCRS.getDatum().getEllipsoid();
            Unit unit = ellipsoid.getAxisUnit();
            int n = 5 * this.length >>> 1;
            int n2 = n + (this.length & 1);
            if (directPosition != null) {
                try {
                    directPosition = this.toGeographic(directPosition);
                    double d = Math.toRadians(directPosition.getOrdinate(1));
                    double d2 = 1.5707963267948966 * Formulas.getRadius((Ellipsoid)ellipsoid, (double)d);
                    double d3 = Math.cos(d) * (2.0 * d2) / (double)(1 << n2);
                    return Quantities.create(Math.max(d2 /= (double)(1 << n), d3), unit);
                }
                catch (TransformException | FactoryException throwable) {
                    Coder.recoverableException(Coder.class, "getPrecision", (Exception)throwable);
                }
            }
            double d = Math.PI * ellipsoid.getSemiMajorAxis() / (double)(1 << n2);
            return Quantities.create(d, unit);
        }

        @Override
        public void setPrecision(Quantity<?> quantity, DirectPosition directPosition) throws IncommensurableException {
            long l;
            ArgumentChecks.ensureNonNull("precision", quantity);
            double d = quantity.getValue().doubleValue();
            Unit unit = quantity.getUnit();
            double d2 = 0.0;
            double d3 = 0.0;
            if (Units.isAngular(unit)) {
                d = unit.getConverterToAny(Units.DEGREE).convert(d);
                d2 = 90.0 / d;
                d3 = 180.0 / d;
            } else {
                Ellipsoid ellipsoid = GeohashReferenceSystem.this.normalizedCRS.getDatum().getEllipsoid();
                d = unit.getConverterToAny(ellipsoid.getAxisUnit()).convert(d);
                if (directPosition != null) {
                    try {
                        directPosition = this.toGeographic(directPosition);
                        double d4 = Math.toRadians(directPosition.getOrdinate(1));
                        d2 = 1.5707963267948966 * Formulas.getRadius((Ellipsoid)ellipsoid, (double)d4) / d;
                        d3 = Math.cos(d4) * (2.0 * d2);
                    }
                    catch (TransformException | FactoryException throwable) {
                        Coder.recoverableException(Coder.class, "setPrecision", (Exception)throwable);
                        directPosition = null;
                    }
                }
                if (directPosition == null) {
                    d2 = 1.5707963267948966 * ellipsoid.getSemiMajorAxis() / d;
                    d3 = 2.0 * d2;
                }
            }
            int n = 0;
            if (d2 > 0.0) {
                l = Math.round(d2);
                n = 63 - Long.numberOfLeadingZeros(l);
                if (1L << n != l) {
                    ++n;
                }
                this.length = Math.max(Numerics.ceilDiv(n << 1, 5), 1);
            }
            if (d3 > d2) {
                l = Math.round(d3);
                int n2 = 63 - Long.numberOfLeadingZeros(l);
                if (1L << n2 != l) {
                    ++n2;
                }
                if (n2 != n + 1 || (this.length & 1) == 0) {
                    this.length = Math.max(Numerics.ceilDiv(n2 << 1, 5), 1);
                }
            }
        }

        public String encode(double d, double d2) throws TransformException {
            d = Latitude.clamp(d);
            d2 = Longitude.normalize(d2);
            byte[] byArray = GeohashReferenceSystem.this.format.encoding;
            int n = GeohashReferenceSystem.this.format.highestOneBit;
            char[] cArray = this.buffer;
            if (cArray == null || cArray.length != this.length) {
                this.buffer = cArray = new char[this.length];
            }
            boolean bl = true;
            double d3 = -180.0;
            double d4 = -90.0;
            double d5 = 180.0;
            double d6 = 90.0;
            int n2 = 0;
            int n3 = n;
            int n4 = 0;
            while (n4 < cArray.length) {
                double d7;
                if (bl) {
                    d7 = (d3 + d5) / 2.0;
                    if (d2 > d7) {
                        n2 |= n3;
                        d3 = d7;
                    } else {
                        d5 = d7;
                    }
                } else {
                    d7 = (d4 + d6) / 2.0;
                    if (d > d7) {
                        n2 |= n3;
                        d4 = d7;
                    } else {
                        d6 = d7;
                    }
                }
                boolean bl2 = bl = !bl;
                if ((n3 >>>= 1) != 0) continue;
                cArray[n4++] = (char)byArray[n2];
                n3 = n;
                n2 = 0;
            }
            return new String(cArray);
        }

        @Override
        public String encode(DirectPosition directPosition) throws TransformException {
            ArgumentChecks.ensureNonNull("position", directPosition);
            try {
                directPosition = this.toGeographic(directPosition);
            }
            catch (FactoryException factoryException) {
                throw new GazetteerException(factoryException.getLocalizedMessage(), factoryException);
            }
            return this.encode(directPosition.getOrdinate(1), directPosition.getOrdinate(0));
        }

        @Override
        public String encode(DirectPosition directPosition, Quantity<?> quantity) throws IncommensurableException, TransformException {
            ArgumentChecks.ensureNonNull("position", directPosition);
            ArgumentChecks.ensureNonNull("precision", quantity);
            try {
                directPosition = this.toGeographic(directPosition);
            }
            catch (FactoryException factoryException) {
                throw new GazetteerException(factoryException.getLocalizedMessage(), factoryException);
            }
            this.setPrecision(quantity, directPosition);
            return this.encode(directPosition.getOrdinate(1), directPosition.getOrdinate(0));
        }

        private DirectPosition toGeographic(DirectPosition directPosition) throws FactoryException, TransformException {
            CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
            if (coordinateReferenceSystem == null || GeohashReferenceSystem.this.normalizedCRS.equals((Object)coordinateReferenceSystem, ComparisonMode.IGNORE_METADATA)) {
                return directPosition;
            }
            if (this.lastOp == null || !Utilities.equalsIgnoreMetadata(this.lastOp.getSourceCRS(), coordinateReferenceSystem)) {
                this.lastOp = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)GeohashReferenceSystem.this.normalizedCRS, null);
            }
            return this.lastOp.getMathTransform().transform(directPosition, null);
        }

        @Override
        public AbstractLocation decode(CharSequence charSequence) throws TransformException {
            ArgumentChecks.ensureNonEmpty("geohash", charSequence);
            return new Decoder(charSequence, this.coordinates);
        }
    }

    private final class Decoder
    extends SimpleLocation {
        Decoder(CharSequence charSequence, double[] dArray) throws TransformException {
            int n;
            super(GeohashReferenceSystem.this.rootType(), charSequence);
            int n2 = charSequence.length();
            int n3 = GeohashReferenceSystem.this.format.highestOneBit;
            byte[] byArray = GeohashReferenceSystem.this.format.decodingLowerCase;
            byte[] byArray2 = GeohashReferenceSystem.this.format.decodingUpperCase;
            boolean bl = true;
            this.minX = -180.0;
            this.maxX = 180.0;
            this.minY = -90.0;
            this.maxY = 90.0;
            for (int i = 0; i < n2; i += n) {
                int n4 = Character.codePointAt(charSequence, i);
                n = Character.charCount(n4);
                if (n4 >= 48 && n4 <= 57) {
                    n4 -= 48;
                } else if ((n4 = n4 >= 97 && n4 <= 122 ? byArray[n4 - 97] : (n4 >= 65 && n4 <= 90 ? byArray2[n4 - 65] : 0)) == 0) {
                    throw new GazetteerException(Errors.format((short)155, "GeoHash", charSequence, charSequence.subSequence(i, i + n)));
                }
                int n5 = n3;
                do {
                    double d;
                    if (bl) {
                        d = (this.minX + this.maxX) / 2.0;
                        if ((n4 & n5) != 0) {
                            this.minX = d;
                        } else {
                            this.maxX = d;
                        }
                    } else {
                        d = (this.minY + this.maxY) / 2.0;
                        if ((n4 & n5) != 0) {
                            this.minY = d;
                        } else {
                            this.maxY = d;
                        }
                    }
                    boolean bl2 = bl = !bl;
                } while ((n5 >>>= 1) != 0);
            }
            if (dArray != null) {
                this.convert(GeohashReferenceSystem.this.denormalize.getMathTransform(), dArray);
            }
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return GeohashReferenceSystem.this.denormalize.getTargetCRS();
        }
    }
}

