/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.sis.internal.gazetteer.Resources;
import org.apache.sis.referencing.gazetteer.GazetteerException;
import org.apache.sis.referencing.gazetteer.GeohashReferenceSystem;
import org.apache.sis.referencing.gazetteer.MilitaryGridReferenceSystem;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.util.iso.AbstractFactory;

public class GazetteerFactory
extends AbstractFactory {
    public Set<String> getSupportedNames() {
        return new LinkedHashSet<String>(Arrays.asList("MGRS", "Geohash"));
    }

    public ReferencingByIdentifiers forName(String string) throws GazetteerException {
        return this.forNameIfKnown(string).orElseThrow(() -> new GazetteerException(Resources.format((short)16, string)));
    }

    public Optional<ReferencingByIdentifiers> forNameIfKnown(String string) throws GazetteerException {
        int n = string.lastIndexOf(58);
        if (n < 0 || string.substring(0, n).trim().equalsIgnoreCase("SIS")) {
            switch (string = string.substring(n + 1).trim()) {
                case "MGRS": {
                    return Optional.of(MilitaryGridReferenceSystem.getInstance());
                }
                case "Geohash": {
                    return Optional.of(GeohashReferenceSystem.getInstance());
                }
            }
        }
        return Optional.empty();
    }
}

