/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.metadata.MetadataCopier;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.util.InternationalString;

final class FinalLocationType
extends AbstractLocationType
implements Serializable {
    private static final long serialVersionUID = 9032473745502779734L;
    private final InternationalString name;
    private final InternationalString theme;
    private final List<InternationalString> identifications;
    private final InternationalString definition;
    private final ReferencingByIdentifiers referenceSystem;
    private final GeographicExtent territoryOfUse;
    private final AbstractParty owner;
    private final List<AbstractLocationType> parents;
    final List<AbstractLocationType> children;

    private FinalLocationType(AbstractLocationType abstractLocationType, ReferencingByIdentifiers referencingByIdentifiers, Map<AbstractLocationType, FinalLocationType> map) {
        map.put(abstractLocationType, this);
        this.name = abstractLocationType.getName();
        InternationalString internationalString = abstractLocationType.getTheme();
        this.identifications = FinalLocationType.snapshot(abstractLocationType.getIdentifications());
        this.definition = abstractLocationType.getDefinition();
        GeographicExtent geographicExtent = (GeographicExtent)FinalLocationType.unmodifiable(abstractLocationType.getTerritoryOfUse());
        AbstractParty abstractParty = (AbstractParty)FinalLocationType.unmodifiable(abstractLocationType.getOwner());
        this.parents = FinalLocationType.snapshot(abstractLocationType.getParents(), referencingByIdentifiers, map);
        this.children = FinalLocationType.snapshot(abstractLocationType.getChildren(), referencingByIdentifiers, map);
        this.referenceSystem = referencingByIdentifiers;
        if (referencingByIdentifiers != null) {
            Extent extent;
            if (internationalString == null) {
                internationalString = referencingByIdentifiers.getTheme();
            }
            if (abstractParty == null) {
                abstractParty = referencingByIdentifiers.getOverallOwner();
            }
            if (geographicExtent == null && (extent = referencingByIdentifiers.getDomainOfValidity()) instanceof GeographicExtent) {
                geographicExtent = (GeographicExtent)extent;
            }
        }
        this.theme = internationalString;
        this.territoryOfUse = geographicExtent;
        this.owner = abstractParty;
    }

    static List<AbstractLocationType> snapshot(Collection<? extends AbstractLocationType> collection, ReferencingByIdentifiers referencingByIdentifiers, Map<AbstractLocationType, FinalLocationType> map) {
        AbstractLocationType[] abstractLocationTypeArray = collection.toArray(new AbstractLocationType[collection.size()]);
        for (int i = 0; i < abstractLocationTypeArray.length; ++i) {
            AbstractLocationType abstractLocationType = abstractLocationTypeArray[i];
            ArgumentChecks.ensureNonNullElement("types", i, abstractLocationType);
            FinalLocationType finalLocationType = map.get(abstractLocationType);
            if (finalLocationType == null) {
                finalLocationType = new FinalLocationType(abstractLocationType, referencingByIdentifiers, map);
            }
            abstractLocationTypeArray[i] = finalLocationType;
        }
        switch (abstractLocationTypeArray.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(abstractLocationTypeArray[0]);
            }
        }
        return UnmodifiableArrayList.wrap(abstractLocationTypeArray);
    }

    private static List<InternationalString> snapshot(Collection<? extends InternationalString> collection) {
        if (collection instanceof UnmodifiableArrayList) {
            return (List)collection;
        }
        return UnmodifiableArrayList.wrap(collection.toArray(new InternationalString[collection.size()]));
    }

    private static Object unmodifiable(Object object) {
        if (object instanceof ModifiableMetadata) {
            object = MetadataCopier.forModifiable(((ModifiableMetadata)object).getStandard()).copy(object);
            ((ModifiableMetadata)object).transitionTo(ModifiableMetadata.State.FINAL);
        }
        return object;
    }

    @Override
    public InternationalString getName() {
        return this.name;
    }

    @Override
    public InternationalString getTheme() {
        return this.theme;
    }

    public Collection<InternationalString> getIdentifications() {
        return this.identifications;
    }

    @Override
    public InternationalString getDefinition() {
        return this.definition;
    }

    @Override
    public GeographicExtent getTerritoryOfUse() {
        return this.territoryOfUse;
    }

    @Override
    public ReferencingByIdentifiers getReferenceSystem() {
        return this.referenceSystem;
    }

    @Override
    public AbstractParty getOwner() {
        return this.owner;
    }

    public Collection<AbstractLocationType> getParents() {
        return this.parents;
    }

    public Collection<AbstractLocationType> getChildren() {
        return this.children;
    }
}

