/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.gazetteer.Resources;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.referencing.gazetteer.FinalLocationType;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.util.InternationalString;

abstract class AbstractLocationType
implements LenientComparable {
    protected AbstractLocationType() {
    }

    public static List<AbstractLocationType> snapshot(ReferencingByIdentifiers referencingByIdentifiers, AbstractLocationType ... abstractLocationTypeArray) {
        ArgumentChecks.ensureNonNull("types", abstractLocationTypeArray);
        List<AbstractLocationType> list = FinalLocationType.snapshot(Arrays.asList(abstractLocationTypeArray), referencingByIdentifiers, new IdentityHashMap<AbstractLocationType, FinalLocationType>());
        IdentityHashMap<AbstractLocationType, Boolean> identityHashMap = new IdentityHashMap<AbstractLocationType, Boolean>();
        for (AbstractLocationType abstractLocationType : list) {
            AbstractLocationType.checkForCycles(abstractLocationType, identityHashMap);
        }
        return list;
    }

    private static void checkForCycles(AbstractLocationType abstractLocationType, Map<AbstractLocationType, Boolean> map) {
        if (map.put(abstractLocationType, Boolean.TRUE) != null) {
            throw new IllegalArgumentException(Resources.format((short)11, abstractLocationType.getName()));
        }
        for (AbstractLocationType abstractLocationType2 : abstractLocationType.getChildren()) {
            AbstractLocationType.checkForCycles(abstractLocationType2, map);
        }
        map.remove(abstractLocationType);
    }

    final void checkForCycles() {
        AbstractLocationType.checkForCycles(this, new IdentityHashMap<AbstractLocationType, Boolean>());
    }

    public abstract InternationalString getName();

    public abstract InternationalString getTheme();

    public abstract Collection<? extends InternationalString> getIdentifications();

    public abstract InternationalString getDefinition();

    public abstract GeographicExtent getTerritoryOfUse();

    public abstract ReferencingByIdentifiers getReferenceSystem();

    public abstract AbstractParty getOwner();

    public abstract Collection<? extends AbstractLocationType> getParents();

    public abstract Collection<? extends AbstractLocationType> getChildren();

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            switch (comparisonMode) {
                case STRICT: {
                    if (this.getClass() != object.getClass()) break;
                }
                case BY_CONTRACT: {
                    if (!(object instanceof AbstractLocationType)) break;
                    AbstractLocationType abstractLocationType = (AbstractLocationType)object;
                    if (!Utilities.deepEquals(this.getTheme(), abstractLocationType.getTheme(), comparisonMode) || !Utilities.deepEquals(this.getIdentifications(), abstractLocationType.getIdentifications(), comparisonMode) || !Utilities.deepEquals(this.getDefinition(), abstractLocationType.getDefinition(), comparisonMode) || !Utilities.deepEquals(this.getTerritoryOfUse(), abstractLocationType.getTerritoryOfUse(), comparisonMode) || !Utilities.deepEquals(this.getOwner(), abstractLocationType.getOwner(), comparisonMode)) break;
                }
                default: {
                    if (!(object instanceof AbstractLocationType)) break;
                    AbstractLocationType abstractLocationType = (AbstractLocationType)object;
                    if (!Objects.equals(this.getName(), abstractLocationType.getName())) break;
                    return Utilities.deepEquals(this.getChildren(), abstractLocationType.getChildren(), comparisonMode);
                }
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        int n = Objects.hashCode(this.getName());
        for (AbstractLocationType abstractLocationType : this.getChildren()) {
            n = n * 31 + Objects.hashCode(abstractLocationType.getName());
        }
        return n;
    }

    public String toString() {
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(TableColumn.NAME, TableColumn.VALUE_AS_TEXT);
        AbstractLocationType.format(this, defaultTreeTable.getRoot());
        return defaultTreeTable.toString();
    }

    private static void format(AbstractLocationType abstractLocationType, TreeTable.Node node) {
        node.setValue(TableColumn.NAME, abstractLocationType.getName());
        node.setValue(TableColumn.VALUE_AS_TEXT, abstractLocationType.getDefinition());
        for (AbstractLocationType abstractLocationType2 : abstractLocationType.getChildren()) {
            AbstractLocationType.format(abstractLocationType2, node.newChild());
        }
    }
}

