/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.AxisType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.ucar.DecoderWrapper;
import org.apache.sis.internal.netcdf.ucar.DimensionWrapper;
import org.apache.sis.internal.netcdf.ucar.VariableWrapper;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;

final class GridWrapper
extends Grid {
    private final CoordinateSystem netcdfCS;
    private final List<ucar.nc2.Dimension> domain;
    private final Map<List<ucar.nc2.Dimension>, GridWrapper> reordered;

    GridWrapper(CoordinateSystem coordinateSystem) {
        this.netcdfCS = coordinateSystem;
        this.reordered = new HashMap<List<ucar.nc2.Dimension>, GridWrapper>(4);
        this.domain = new ArrayList<ucar.nc2.Dimension>((Collection<ucar.nc2.Dimension>)coordinateSystem.getDomain());
        HashMap<ucar.nc2.Dimension, ucar.nc2.constants.AxisType> hashMap = new HashMap<ucar.nc2.Dimension, ucar.nc2.constants.AxisType>();
        for (CoordinateAxis coordinateAxis : coordinateSystem.getCoordinateAxes()) {
            ucar.nc2.Dimension dimension3;
            ucar.nc2.constants.AxisType axisType = coordinateAxis.getAxisType();
            UnmodifiableIterator unmodifiableIterator = coordinateAxis.getDimensions().iterator();
            while (unmodifiableIterator.hasNext() && hashMap.putIfAbsent(dimension3 = (ucar.nc2.Dimension)unmodifiableIterator.next(), axisType) != null) {
            }
        }
        this.domain.sort((dimension, dimension2) -> {
            ucar.nc2.constants.AxisType axisType;
            ucar.nc2.constants.AxisType axisType2 = (ucar.nc2.constants.AxisType)hashMap.get(dimension);
            if (axisType2 == (axisType = (ucar.nc2.constants.AxisType)hashMap.get(dimension2))) {
                return 0;
            }
            if (axisType2 == null) {
                return 1;
            }
            if (axisType == null) {
                return -1;
            }
            return axisType2.axisOrder() - axisType.axisOrder();
        });
    }

    private GridWrapper(GridWrapper gridWrapper, List<ucar.nc2.Dimension> list) {
        this.netcdfCS = gridWrapper.netcdfCS;
        this.reordered = gridWrapper.reordered;
        this.domain = list;
        assert (this.netcdfCS.getDomain().containsAll(list));
    }

    @Override
    protected Grid forDimensions(Dimension[] dimensionArray) {
        return this.forDimensions(UnmodifiableArrayList.wrap(DimensionWrapper.unwrap(dimensionArray)));
    }

    private GridWrapper forDimensions(List<ucar.nc2.Dimension> list2) {
        if (list2.size() > this.domain.size()) {
            list2 = new ArrayList<ucar.nc2.Dimension>(list2);
            list2.retainAll(this.domain);
        }
        if (this.domain.equals(list2)) {
            return this;
        }
        return this.reordered.computeIfAbsent(list2, list -> {
            if (this.domain.size() == list.size() && this.domain.containsAll((Collection<?>)list)) {
                return new GridWrapper(this, (List<ucar.nc2.Dimension>)list);
            }
            return null;
        });
    }

    final GridWrapper forVariable(Variable variable, List<CoordinateSystem> list, String[] stringArray) {
        if (list.contains(this.netcdfCS) && this.containsAllNamedAxes(stringArray)) {
            return this.forDimensions((List<ucar.nc2.Dimension>)variable.getDimensions());
        }
        return null;
    }

    @Override
    public String getName() {
        return this.netcdfCS.getName();
    }

    @Override
    public int getSourceDimensions() {
        return this.netcdfCS.getRankDomain();
    }

    @Override
    protected List<Dimension> getDimensions() {
        return DimensionWrapper.wrap(this.domain);
    }

    @Override
    protected boolean containsAllNamedAxes(String[] stringArray) {
        if (stringArray != null) {
            block0: for (String string : stringArray) {
                for (CoordinateAxis coordinateAxis : this.netcdfCS.getCoordinateAxes()) {
                    if (!string.equalsIgnoreCase(coordinateAxis.getShortName())) continue;
                    continue block0;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected Axis[] createAxes(Decoder decoder) throws IOException, DataStoreException {
        ImmutableList immutableList = this.netcdfCS.getCoordinateAxes();
        int n = 0;
        int n2 = immutableList.size();
        Axis[] axisArray = new Axis[n2];
        while (--n2 >= 0) {
            CoordinateAxis coordinateAxis = (CoordinateAxis)immutableList.get(n2);
            VariableWrapper variableWrapper = ((DecoderWrapper)decoder).getWrapperFor((Variable)coordinateAxis);
            char c = '\u0000';
            ucar.nc2.constants.AxisType axisType = coordinateAxis.getAxisType();
            if (axisType != null) {
                switch (axisType) {
                    case GeoX: {
                        c = this.netcdfCS.isGeoXY() ? (char)'E' : 'x';
                        break;
                    }
                    case GeoY: {
                        c = this.netcdfCS.isGeoXY() ? (char)'N' : 'y';
                        break;
                    }
                    case GeoZ: {
                        c = this.netcdfCS.isGeoXY() ? (char)'H' : 'z';
                        break;
                    }
                    case Lon: {
                        c = '\u03bb';
                        break;
                    }
                    case Lat: {
                        c = '\u03c6';
                        break;
                    }
                    case Pressure: 
                    case Height: {
                        c = 'H';
                        break;
                    }
                    case RunTime: 
                    case Time: {
                        c = 't';
                        break;
                    }
                    case RadialAzimuth: {
                        c = '\u03b8';
                        break;
                    }
                    case RadialElevation: {
                        c = '\u03a9';
                        break;
                    }
                    case RadialDistance: {
                        c = 'r';
                    }
                }
            }
            if (c == '\u0000') {
                c = AxisType.abbreviation(variableWrapper);
            }
            int n3 = 0;
            ImmutableList immutableList2 = coordinateAxis.getDimensions();
            int[] nArray = new int[immutableList2.size()];
            int[] nArray2 = new int[nArray.length];
            for (ucar.nc2.Dimension dimension : immutableList2) {
                int n4 = this.domain.lastIndexOf(dimension);
                if (n4 < 0) continue;
                nArray[n3] = n4;
                nArray2[n3++] = dimension.getLength();
            }
            if (n3 == 0) continue;
            axisArray[n++] = new Axis(c, coordinateAxis.getPositive(), ArraysExt.resize(nArray, n3), ArraysExt.resize(nArray2, n3), variableWrapper);
        }
        return ArraysExt.resize(axisArray, n);
    }
}

