/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.setup;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.sis.internal.setup.FXFinder;
import org.apache.sis.internal.setup.WizardPage;

final class Wizard
extends FileFilter
implements ActionListener,
PropertyChangeListener,
DropTargetListener {
    private static final int WIDTH = 700;
    private static final String BACK = "Back";
    private static final String NEXT = "Next";
    private static final String CANCEL = "Cancel";
    private static final String JAVAFX_HOME = "Open JavaFX home page";
    private static final String BROWSE = "Browse";
    private static final String SELECT = "Select";
    private final Color TITLE_COLOR = new Color(36, 113, 163);
    private final Color SELECTED_TITLE_COLOR = new Color(21, 67, 96);
    private static final String TITLE_BULLET = "\u2022 ";
    private static final String SELECTED_TITLE_BULLET = "\u2023 ";
    private final Border JAVAFX_PATH_BORDER = new LineBorder(Color.GRAY);
    private final Border JAVAFX_PATH_BORDER_DND = new LineBorder(new Color(40, 180, 99), 3);
    private final JFrame wizard;
    private final JPanel cardPanel;
    private final JButton nextButton;
    private final JButton backButton;
    private final JButton cancelButton;
    private JButton selectButton;
    private final JLabel[] titles;
    private WizardPage currentPage;
    private boolean acceptLocation;
    final FXFinder javafxFinder;
    private final JLabel javafxPath;
    private final JLabel javafxPathError;
    private JLabel finalMessage;
    private JLabel finalJavafxPath;
    final JProgressBar inflateProgress;

    private Wizard(final FXFinder javafxFinder) {
        this.javafxFinder = javafxFinder;
        this.wizard = new JFrame("Apache SIS setup");
        Container content = this.wizard.getContentPane();
        content.setLayout(new BorderLayout());
        Box buttons = Box.createHorizontalBox();
        buttons.setBorder(new EmptyBorder(9, 12, 9, 15));
        this.backButton = this.createButton(buttons, BACK);
        buttons.add(Box.createHorizontalStrut(10));
        this.nextButton = this.createButton(buttons, NEXT);
        buttons.add(Box.createHorizontalStrut(30));
        this.cancelButton = this.createButton(buttons, CANCEL);
        this.backButton.setEnabled(false);
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)new JSeparator(), "North");
        bottom.add((Component)buttons, "East");
        content.add((Component)bottom, "South");
        WizardPage[] pages = WizardPage.values();
        this.titles = new JLabel[pages.length];
        EmptyBorder padding = new EmptyBorder(3, 0, 3, 0);
        Box summary = Box.createVerticalBox();
        for (int i = 0; i < pages.length; ++i) {
            String title = (i == 0 ? SELECTED_TITLE_BULLET : TITLE_BULLET) + pages[i].title;
            JLabel label = new JLabel(title, 2);
            label.setForeground(i == 0 ? this.SELECTED_TITLE_COLOR : this.TITLE_COLOR);
            label.setBorder(padding);
            this.titles[i] = label;
            summary.add(this.titles[i]);
        }
        JPanel pane = new JPanel();
        pane.setBackground(new Color(169, 204, 227));
        pane.setBorder(new EmptyBorder(40, 15, 9, 24));
        pane.add(summary);
        content.add((Component)pane, "West");
        Font font = new Font("Serif", 0, 14);
        this.javafxPath = new JLabel();
        this.javafxPath.setBorder(this.JAVAFX_PATH_BORDER);
        this.javafxPathError = new JLabel();
        this.javafxPathError.setForeground(Color.RED);
        this.javafxPathError.setFont(font);
        this.inflateProgress = new JProgressBar();
        this.cardPanel = new JPanel(new CardLayout());
        this.cardPanel.setBorder(new EmptyBorder(30, 30, 9, 30));
        this.cardPanel.setBackground(Color.WHITE);
        for (WizardPage page : pages) {
            this.cardPanel.add((Component)this.createPage(page, font), page.name());
        }
        this.currentPage = pages[0];
        content.add((Component)this.cardPanel, "Center");
        this.wizard.setSize(700, 500);
        this.wizard.setResizable(false);
        this.wizard.setLocationRelativeTo(null);
        this.wizard.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                javafxFinder.cancel();
            }
        });
    }

    private Box createPage(WizardPage page, Font font) {
        Box content = Box.createVerticalBox();
        JLabel text = new JLabel(page.text, 2);
        text.setFont(font);
        content.add(text);
        content.add(Box.createVerticalStrut(30));
        switch (page) {
            case DOWNLOAD_JAVAFX: {
                JButton button = this.createButton(content, JAVAFX_HOME);
                button.setToolTipText("https://openjfx.io/");
                button.setEnabled(Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE));
                JLabel instruction = new JLabel(WizardPage.downloadSteps());
                instruction.setFont(font.deriveFont(12.0f));
                content.add(instruction);
                break;
            }
            case JAVAFX_LOCATION: {
                this.javafxPath.setMinimumSize(new Dimension(100, 30));
                this.javafxPath.setMaximumSize(new Dimension(700, 30));
                content.add(this.javafxPath);
                content.add(Box.createVerticalStrut(12));
                this.createButton(content, BROWSE);
                content.add(Box.createVerticalStrut(24));
                content.add(this.javafxPathError);
                content.setDropTarget(new DropTarget(content, this));
                break;
            }
            case DECOMPRESS: {
                this.inflateProgress.setMinimumSize(new Dimension(100, 21));
                this.inflateProgress.setMaximumSize(new Dimension(700, 21));
                content.add(this.inflateProgress);
                break;
            }
            case COMPLETED: {
                this.finalMessage = text;
                EmptyBorder vb = new EmptyBorder(0, 15, 9, 0);
                Font fn = new Font("Monospaced", 1, 13);
                Font fv = new Font("SansSerif", 0, 13);
                for (String[] variable : this.javafxFinder.getEnvironmentVariables()) {
                    JLabel name = new JLabel(variable[0] + ":");
                    JLabel value = new JLabel(variable[1]);
                    name.setForeground(Color.DARK_GRAY);
                    value.setForeground(Color.DARK_GRAY);
                    name.setFont(fn);
                    value.setFont(fv);
                    value.setBorder(vb);
                    name.setLabelFor(value);
                    content.add(name);
                    content.add(value);
                    if (!"PATH_TO_FX".equals(variable[0])) continue;
                    this.finalJavafxPath = value;
                }
                break;
            }
        }
        return content;
    }

    private JButton createButton(Box addTo, String label) {
        JButton button = new JButton(label);
        button.setActionCommand(label);
        button.addActionListener(this);
        addTo.add(button);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        switch (event.getActionCommand()) {
            case "Cancel": {
                this.javafxFinder.cancel();
                break;
            }
            case "Back": {
                this.nextOrPreviousPage(-1);
                break;
            }
            case "Next": {
                this.nextOrPreviousPage(1);
                break;
            }
            case "Open JavaFX home page": {
                this.openJavafxHomePage();
                break;
            }
            case "Browse": {
                this.showDirectoryChooser();
            }
        }
    }

    private void nextOrPreviousPage(int n) {
        int index = this.currentPage.ordinal();
        JLabel title = this.titles[index];
        title.setForeground(this.TITLE_COLOR);
        title.setText(TITLE_BULLET + this.currentPage.title);
        WizardPage[] pages = WizardPage.values();
        if ((index += n) >= pages.length) {
            this.wizard.dispose();
            System.exit(0);
            return;
        }
        this.currentPage = pages[index];
        title = this.titles[index];
        title.setForeground(this.SELECTED_TITLE_COLOR);
        title.setText(SELECTED_TITLE_BULLET + this.currentPage.title);
        this.backButton.setEnabled(index > 0);
        this.nextButton.setEnabled(true);
        switch (this.currentPage) {
            case JAVAFX_LOCATION: {
                this.nextButton.setEnabled(this.acceptLocation);
                break;
            }
            case DECOMPRESS: {
                this.backButton.setEnabled(false);
                this.nextButton.setEnabled(false);
                if (this.javafxFinder.decompress(this)) break;
                this.nextOrPreviousPage(n);
                return;
            }
            case COMPLETED: {
                this.backButton.setEnabled(false);
                this.nextButton.setText("Finish");
                try {
                    this.javafxFinder.commit();
                    this.cancelButton.setEnabled(false);
                    this.finalJavafxPath.setText(this.javafxFinder.getValidatedDirectory());
                    break;
                }
                catch (IOException e) {
                    this.nextButton.setEnabled(false);
                    this.finalMessage.setForeground(Color.RED);
                    this.finalMessage.setText(Wizard.getHtmlMessage("Apache SIS setup cannot be completed.", e));
                }
            }
        }
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, this.currentPage.name());
    }

    final void decompressionFinished(File destination, Exception failure) {
        boolean isValid;
        if (failure != null) {
            isValid = false;
            this.javafxPathError.setText(Wizard.getHtmlMessage("Cannot decompress the file.", failure));
        } else {
            isValid = this.setJavafxPath(destination);
        }
        this.javafxFinder.useRelativePath = isValid;
        this.nextOrPreviousPage(isValid ? 1 : -1);
    }

    private static String getHtmlMessage(String header, Exception e) {
        StringBuilder buffer = new StringBuilder(100).append("<html>").append(header).append("<br><b>").append(e.getClass().getSimpleName()).append("</b>");
        String message = e.getLocalizedMessage();
        if (message != null) {
            message = message.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
            buffer.append(": ").append(message);
        }
        return buffer.append("</html>").toString();
    }

    private void openJavafxHomePage() {
        try {
            Desktop.getDesktop().browse(new URI("https://openjfx.io/"));
        }
        catch (IOException | RuntimeException | URISyntaxException e) {
            JOptionPane.showMessageDialog(this.wizard, e.toString(), "Error", 0);
        }
    }

    private void showDirectoryChooser() {
        JFileChooser fd = new JFileChooser(this.javafxFinder.getDirectory());
        fd.addChoosableFileFilter(this);
        fd.setFileFilter(this);
        fd.setFileSelectionMode(2);
        fd.setDialogTitle("JavaFX installation directory");
        fd.setApproveButtonText(SELECT);
        this.selectButton = Wizard.findSelectButton(fd);
        fd.setApproveButtonText(null);
        if (this.selectButton != null) {
            this.selectButton.setEnabled(false);
            fd.addPropertyChangeListener(this);
        }
        if (fd.showOpenDialog(this.wizard) == 0) {
            this.setJavafxPath(fd.getSelectedFile());
        }
        this.selectButton = null;
    }

    private static JButton findSelectButton(Container c) {
        int n = c.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JButton button;
            Component child = c.getComponent(i);
            if (!(child instanceof JButton ? SELECT.equals((button = (JButton)child).getText()) : child instanceof Container && (button = Wizard.findSelectButton((Container)child)) != null)) continue;
            return button;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "ZIP files";
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName();
        int s = name.lastIndexOf(46);
        return s >= 0 && name.regionMatches(true, s + 1, "zip", 0, 3);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        File file;
        switch (event.getPropertyName()) {
            default: {
                return;
            }
            case "SelectedFileChangedProperty": {
                file = (File)event.getNewValue();
                break;
            }
            case "directoryChanged": {
                file = ((JFileChooser)event.getSource()).getSelectedFile();
            }
        }
        boolean enabled = false;
        if (file != null) {
            if (file.isFile()) {
                enabled = true;
            } else if (file.isDirectory()) {
                enabled = this.javafxFinder.setDirectory(file);
            }
        }
        this.selectButton.setEnabled(enabled);
    }

    private boolean setJavafxPath(File dir) {
        String error = null;
        boolean isValid = this.javafxFinder.setDirectory(dir);
        if (!isValid) {
            if (dir.isFile()) {
                try {
                    error = FXFinder.checkZip(dir);
                    isValid = error == null;
                }
                catch (IOException e) {
                    error = Wizard.getHtmlMessage("Cannot open the file.", e);
                }
            } else {
                error = "<html>Not a recognized JavaFX directory or ZIP file.</html>";
            }
        }
        this.javafxPath.setText(dir != null ? dir.getPath() : null);
        this.javafxPath.setForeground(isValid ? Color.DARK_GRAY : Color.RED);
        if (this.currentPage == WizardPage.JAVAFX_LOCATION) {
            this.nextButton.setEnabled(isValid);
        }
        this.javafxPathError.setText(error);
        this.acceptLocation = isValid;
        return isValid;
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        for (DataFlavor flavor : event.getCurrentDataFlavors()) {
            if (!flavor.isFlavorJavaFileListType()) continue;
            this.javafxPath.setBorder(this.JAVAFX_PATH_BORDER);
            event.acceptDrop(0x40000000);
            try {
                File file;
                Iterator iterator = ((Iterable)event.getTransferable().getTransferData(DataFlavor.javaFileListFlavor)).iterator();
                while (iterator.hasNext() && !this.setJavafxPath(file = (File)iterator.next())) {
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                this.javafxPathError.setText(Wizard.getHtmlMessage("Cannot open the file.", e));
            }
            event.dropComplete(true);
            return;
        }
        event.rejectDrop();
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        for (DataFlavor flavor : event.getCurrentDataFlavors()) {
            if (!flavor.isFlavorJavaFileListType()) continue;
            this.javafxPath.setBorder(this.JAVAFX_PATH_BORDER_DND);
            break;
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        this.javafxPath.setBorder(this.JAVAFX_PATH_BORDER);
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    public static boolean show(FXFinder javafxFinder) {
        String diagnostic = javafxFinder.diagnostic();
        if (diagnostic != null) {
            JOptionPane.showMessageDialog(null, diagnostic, "Configuration error", 0);
            return false;
        }
        Wizard wizard = new Wizard(javafxFinder);
        wizard.wizard.setVisible(true);
        return true;
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ReflectiveOperationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
    }
}

