/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.setup;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JProgressBar;
import org.apache.sis.internal.setup.Wizard;

final class Inflater
implements Runnable {
    private final Wizard wizard;
    private final File source;
    private File destination;
    private File subdir;
    private Exception failure;
    private volatile boolean cancelled;

    Inflater(Wizard wizard, File source) {
        this.wizard = wizard;
        this.source = source;
    }

    @Override
    public synchronized void run() {
        try {
            this.doInBackground();
        }
        catch (Exception e) {
            this.failure = e;
            Inflater.delete(this.destination);
        }
        EventQueue.invokeLater(this::done);
    }

    private void doInBackground() throws Exception {
        this.destination = this.wizard.javafxFinder.getDestinationDirectory();
        JProgressBar progressBar = this.wizard.inflateProgress;
        byte[] buffer = new byte[65536];
        try (ZipFile zip = new ZipFile(this.source);){
            int size = zip.size();
            EventQueue.invokeAndWait(() -> progressBar.setMaximum(size));
            Enumeration<? extends ZipEntry> entries = zip.entries();
            int progressValue = 0;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File file = new File(this.destination, entry.getName());
                if (entry.isDirectory()) {
                    if (!file.isDirectory() && !file.mkdir()) {
                        throw new IOException("Directory cannot be created: " + String.valueOf(file));
                    }
                    if (this.subdir == null && entry.getName().startsWith("javafx-sdk-")) {
                        this.subdir = file;
                    }
                } else {
                    try (InputStream in = zip.getInputStream(entry);
                         FileOutputStream out = new FileOutputStream(file);){
                        int n;
                        while ((n = in.read(buffer)) >= 0) {
                            if (this.cancelled) {
                                return;
                            }
                            ((OutputStream)out).write(buffer, 0, n);
                        }
                    }
                }
                int p = progressValue++;
                EventQueue.invokeLater(() -> progressBar.setValue(p));
            }
        }
    }

    private void done() {
        if (!this.cancelled) {
            if (this.subdir == null) {
                this.subdir = this.destination;
            }
            this.wizard.decompressionFinished(this.subdir, this.failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cancel() {
        this.cancelled = true;
        Inflater inflater = this;
        synchronized (inflater) {
            Inflater.delete(this.destination);
        }
    }

    private static void delete(File directory) {
        if (directory != null) {
            File[] content = directory.listFiles();
            if (content != null) {
                for (File file : content) {
                    Inflater.delete(file);
                }
            }
            directory.delete();
        }
    }
}

