/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.List;
import java.util.ListIterator;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javafx.util.Duration;
import org.apache.sis.measure.Range;
import org.apache.sis.util.collection.RangeSet;

final class FileAccessItem
implements Runnable,
EventHandler<ActionEvent> {
    private static final int HEIGHT = 16;
    private static final int MARGIN_TOP = 1;
    private static final int MARGIN_RIGHT = 6;
    private static final Color FILL_COLOR = Color.LIGHTSEAGREEN;
    private static final Color BORDER_COLOR = FILL_COLOR.darker();
    private static final int CURSOR_WIDTH = 10;
    private static final Duration CURSOR_DURATION = Duration.seconds((double)4.0);
    private static final Duration SEEK_DURATION = Duration.minutes((double)1.0);
    final List<FileAccessItem> owner;
    final String filename;
    private final RangeSet<Long> accessRanges;
    final Pane accessView;
    private final ObservableList<Node> staticGroup;
    private final ObservableList<Node> seeksGroup;
    private FadeTransition cursor;
    private long cursorPosition;
    private long fileSize;
    private double columnWidth;

    FileAccessItem(List<FileAccessItem> owner, String filename) {
        this.owner = owner;
        this.filename = filename;
        Group staticView = new Group();
        Group seeksView = new Group();
        this.staticGroup = staticView.getChildren();
        this.seeksGroup = seeksView.getChildren();
        this.accessView = new Pane(new Node[]{staticView, seeksView});
        this.accessRanges = RangeSet.create(Long.class, true, false);
        staticView.setAutoSizeChildren(false);
        Rectangle background = new Rectangle();
        background.setY(1.0);
        background.setHeight(16.0);
        background.setStroke((Paint)FILL_COLOR.brighter());
        background.setFill((Paint)Color.TRANSPARENT);
        background.setStrokeType(StrokeType.INSIDE);
        this.staticGroup.add((Object)background);
        this.accessView.widthProperty().addListener((p, o, n) -> this.resize(n.doubleValue()));
    }

    private void resize(double width) {
        double old = this.columnWidth;
        this.columnWidth = width - 6.0;
        double scale = this.columnWidth / (double)this.fileSize;
        if (Double.isFinite(scale)) {
            this.adjustSizes(scale, true);
            if (this.cursor != null) {
                Rectangle r = (Rectangle)this.cursor.getNode();
                r.setX(Math.max(0.0, Math.min(scale * (double)this.cursorPosition - 5.0, this.columnWidth - 10.0)));
            }
            double ratio = this.columnWidth / old;
            for (Node node : this.seeksGroup) {
                Line line = (Line)node;
                double x = line.getStartX() * ratio;
                line.setStartX(x);
                line.setEndX(x);
            }
        }
    }

    private void addSeek(long position) {
        double x = (double)position * (this.columnWidth / (double)this.fileSize);
        Line line = new Line(x, 1.0, x, 17.0);
        line.setStroke((Paint)Color.DARKBLUE);
        this.seeksGroup.add((Object)line);
        FadeTransition t = new FadeTransition(CURSOR_DURATION, (Node)line);
        t.setDelay(SEEK_DURATION);
        t.setFromValue(1.0);
        t.setToValue(0.0);
        t.setOnFinished((EventHandler)this);
        t.play();
    }

    private void addRange(long position, int count, boolean write) {
        this.cursorPosition = position;
        boolean add = this.accessRanges.add(position, position + (long)count);
        double scale = this.columnWidth / (double)this.fileSize;
        if (Double.isFinite(scale)) {
            Rectangle r;
            if (add) {
                this.adjustSizes(scale, false);
            }
            if (this.cursor == null) {
                r = new Rectangle(0.0, 1.0, 10.0, 16.0);
                r.setArcWidth(4.0);
                r.setArcHeight(6.0);
                r.setStroke((Paint)Color.ORANGE);
                r.setFill((Paint)Color.YELLOW);
                this.accessView.getChildren().add((Object)r);
                this.cursor = new FadeTransition(CURSOR_DURATION, (Node)r);
                this.cursor.setOnFinished((EventHandler)this);
                this.cursor.setFromValue(1.0);
                this.cursor.setToValue(0.0);
            } else {
                r = (Rectangle)this.cursor.getNode();
            }
            r.setX(Math.max(0.0, Math.min(scale * (double)position - 5.0, this.columnWidth - 10.0)));
            this.cursor.playFromStart();
        }
    }

    public void handle(ActionEvent event) {
        ObservableList list;
        FadeTransition animation = (FadeTransition)event.getSource();
        if (animation == this.cursor) {
            this.cursor = null;
            list = this.accessView.getChildren();
        } else {
            list = this.seeksGroup;
        }
        boolean removed = list.remove((Object)animation.getNode());
        assert (removed) : animation;
    }

    final void adjustSizes(double scale, boolean resized) {
        ListIterator bars = this.staticGroup.listIterator();
        ((Rectangle)bars.next()).setWidth(this.columnWidth);
        for (Range<Long> range : this.accessRanges) {
            Rectangle r;
            long min = range.getMinValue();
            long max = range.getMaxValue();
            double x = scale * (double)min;
            double width = scale * (double)(max - min);
            if (bars.hasNext()) {
                r = (Rectangle)bars.next();
                if (resized || r.getX() + r.getWidth() >= x) {
                    r.setX(x);
                    r.setWidth(width);
                    continue;
                }
                bars.remove();
            }
            r = new Rectangle(x, 1.0, width, 16.0);
            r.setStrokeType(StrokeType.INSIDE);
            r.setStroke((Paint)BORDER_COLOR);
            r.setFill((Paint)FILL_COLOR);
            bars.add(r);
        }
        this.staticGroup.remove(bars.nextIndex(), this.staticGroup.size());
    }

    @Override
    public void run() {
        this.owner.remove(this);
    }

    final class Observer
    implements SeekableByteChannel {
        private final SeekableByteChannel channel;

        Observer(SeekableByteChannel channel) throws IOException {
            this.channel = channel;
            FileAccessItem.this.fileSize = channel.size();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            long position = this.position();
            int count = this.channel.read(dst);
            Platform.runLater(() -> FileAccessItem.this.addRange(position, count, false));
            return count;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            long position = this.position();
            int count = this.channel.write(src);
            Platform.runLater(() -> FileAccessItem.this.addRange(position, count, true));
            return count;
        }

        @Override
        public long position() throws IOException {
            return this.channel.position();
        }

        @Override
        public SeekableByteChannel position(long position) throws IOException {
            this.channel.position(position);
            Platform.runLater(() -> FileAccessItem.this.addSeek(position));
            return this;
        }

        @Override
        public long size() throws IOException {
            return this.channel.size();
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            FileAccessItem.this.fileSize = this.channel.truncate(size).size();
            return this;
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            Platform.runLater((Runnable)FileAccessItem.this);
            this.channel.close();
        }
    }
}

