/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.control;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.gui.control.FormatApplicator;

final class FormatTableCell<S, T>
extends TableCell<S, T> {
    private final FormatApplicator<T> textConverter;
    private TextField editor;
    private final Trigger<S> insertTrigger;

    public FormatTableCell(FormatApplicator<T> textConverter, Trigger<S> insertTrigger) {
        this.textConverter = textConverter;
        this.insertTrigger = insertTrigger;
        this.setAlignment(Pos.CENTER_LEFT);
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        String text = null;
        TextField g = null;
        if (!empty) {
            if (this.isEditing()) {
                g = this.editor;
                if (g != null) {
                    this.textConverter.format(g, item);
                }
            } else if (item != null) {
                text = this.textConverter.toString(item);
            }
        }
        this.setText(text);
        this.setGraphic((Node)g);
    }

    public void startEdit() {
        String text;
        super.startEdit();
        String string = text = this.insertTrigger != null ? this.insertTrigger.initialText : null;
        if (text == null) {
            text = this.getText();
        }
        if (this.editor != null) {
            this.editor.pseudoClassStateChanged(Styles.ERROR, false);
            this.editor.setText(text);
        } else {
            this.editor = new TextField(text);
            this.editor.setOnAction(event -> {
                event.consume();
                T value = this.textConverter.parse(this.editor);
                if (value != null) {
                    this.commitEdit(value);
                }
            });
            this.editor.setOnKeyReleased(event -> {
                if (event.getCode() == KeyCode.ESCAPE) {
                    event.consume();
                    this.cancelEdit();
                }
            });
        }
        this.setText(null);
        this.setGraphic((Node)this.editor);
        this.editor.requestFocus();
        if (this.insertTrigger.initialText == null) {
            this.editor.selectAll();
        } else {
            this.editor.deselect();
            this.editor.end();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setGraphic(null);
        this.setText(this.textConverter.toString(this.getItem()));
    }

    static final class Trigger<S>
    implements EventHandler<KeyEvent> {
        private final TableColumn<S, ?> column;
        private char minusSign;
        private char zeroDigit;
        String initialText;

        public Trigger(TableColumn<S, ?> column, Format format) {
            this.column = column;
            if (format instanceof DecimalFormat) {
                DecimalFormatSymbols symbols = ((DecimalFormat)format).getDecimalFormatSymbols();
                this.minusSign = symbols.getMinusSign();
                this.zeroDigit = symbols.getZeroDigit();
            }
        }

        public void registerTo(TableView<S> target) {
            target.addEventHandler(KeyEvent.KEY_TYPED, (EventHandler)this);
            target.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
                if (event.getCode() == KeyCode.F2) {
                    TablePosition cell;
                    TableView table = this.column.getTableView();
                    if (table.getEditingCell() == null && (cell = table.getFocusModel().getFocusedCell()) != null) {
                        table.edit(cell.getRow(), this.column);
                    }
                    event.consume();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(KeyEvent event) {
            char c;
            String t;
            TableView table = this.column.getTableView();
            if (table.getEditingCell() == null && (t = event.getCharacter()).length() == 1 && ((c = t.charAt(0)) >= '0' && c <= '9' || c == this.minusSign || c == this.zeroDigit)) {
                int row = table.getItems().size() - 1;
                table.getSelectionModel().select(row);
                try {
                    this.initialText = t;
                    table.edit(row, this.column);
                }
                finally {
                    this.initialText = null;
                }
                event.consume();
            }
        }
    }
}

