/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.util.Callback;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.PropertyValueFormatter;
import org.apache.sis.internal.gui.PropertyView;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.InternationalString;

@DefaultProperty(value="content")
public class MetadataTree
extends TreeTableView<TreeTable.Node> {
    private final TreeTableColumn<TreeTable.Node, String> nameColumn;
    private final TreeTableColumn<TreeTable.Node, Object> valueColumn;
    private TableColumn<?> valueSourceColumn;
    public final ObjectProperty<TreeTable> contentProperty;
    private PropertyView propertyViewer;
    private Dialog<Void> propertyDialog;
    private final Formatter formatter;

    public MetadataTree() {
        this(null);
    }

    public MetadataTree(MetadataSummary controller) {
        this(controller, false);
        this.setRowFactory(Row::new);
        this.setShowRoot(false);
    }

    MetadataTree(MetadataSummary controller, boolean standard) {
        Vocabulary vocabulary = controller != null ? controller.vocabulary : Vocabulary.getResources((Locale)null);
        this.formatter = new Formatter(vocabulary.getLocale());
        this.contentProperty = new ContentProperty(this);
        this.nameColumn = new TreeTableColumn(vocabulary.getString((short)238));
        this.valueColumn = new TreeTableColumn(vocabulary.getString((short)213));
        this.nameColumn.setCellValueFactory(MetadataTree::getPropertyName);
        this.valueColumn.setCellValueFactory((Callback)this.formatter);
        this.setColumnResizePolicy(CONSTRAINED_RESIZE_POLICY);
        this.getColumns().setAll((Object[])new TreeTableColumn[]{this.nameColumn, this.valueColumn});
        this.contentProperty.addListener(MetadataTree::applyChange);
    }

    final Locale getLocale() {
        return this.formatter.getLocale();
    }

    public final void setContent(TreeTable data) {
        this.contentProperty.setValue((Object)data);
    }

    public final TreeTable getContent() {
        return (TreeTable)this.contentProperty.getValue();
    }

    private static void applyChange(ObservableValue<? extends TreeTable> property, TreeTable oldValue, TreeTable newValue) {
        MetadataTree s = (MetadataTree)((Object)((ContentProperty)property).getBean());
        if (s.propertyViewer != null) {
            s.propertyViewer.clear();
        }
        Item root = null;
        if (newValue != null) {
            root = new Item(newValue.getRoot());
            root.setExpanded(true);
        }
        s.setRoot(root);
    }

    private static <T> T getValue(TreeTableColumn.CellDataFeatures<TreeTable.Node, ?> cell, TableColumn<T> column) {
        TreeTable.Node node = (TreeTable.Node)cell.getValue().getValue();
        return node.getValue(column);
    }

    private static ObservableValue<String> getPropertyName(TreeTableColumn.CellDataFeatures<TreeTable.Node, String> cell) {
        String text;
        CharSequence value = MetadataTree.getValue(cell, TableColumn.NAME);
        if (value instanceof InternationalString) {
            MetadataTree view = (MetadataTree)cell.getTreeTableView();
            text = ((InternationalString)value).toString(view.getLocale());
        } else {
            text = value != null ? value.toString() : null;
        }
        return new ReadOnlyStringWrapper(text);
    }

    private void showPropertyValue(Object value) {
        if (this.propertyViewer == null) {
            this.propertyViewer = new PropertyView(this.formatter);
            this.propertyDialog = new Dialog();
            this.propertyDialog.setResizable(true);
            this.propertyDialog.setTitle(Resources.forLocale(this.getLocale()).getString((short)68));
            this.propertyDialog.initOwner(this.getScene().getWindow());
            DialogPane pane = this.propertyDialog.getDialogPane();
            pane.contentProperty().bind(this.propertyViewer.view);
            pane.getButtonTypes().add((Object)ButtonType.CLOSE);
        }
        this.propertyViewer.set(value, null);
        this.propertyDialog.show();
    }

    private static final class Formatter
    extends PropertyValueFormatter
    implements Callback<TreeTableColumn.CellDataFeatures<TreeTable.Node, Object>, ObservableValue<Object>> {
        Formatter(Locale locale) {
            super(new StringBuilder(), locale);
        }

        public ObservableValue<Object> call(TreeTableColumn.CellDataFeatures<TreeTable.Node, Object> cell) {
            MetadataTree view = (MetadataTree)cell.getTreeTableView();
            Object value = MetadataTree.getValue(cell, view.valueSourceColumn);
            if (value instanceof IdentifiedObject) {
                value = IdentifiedObjects.getDisplayName((IdentifiedObject)((IdentifiedObject)value), (Locale)this.getLocale());
            }
            try {
                this.clear();
                StringBuilder buffer = (StringBuilder)this.out;
                buffer.setLength(0);
                this.appendValue(value);
                this.flush();
                value = buffer.toString();
            }
            catch (IOException e) {
                Logging.unexpectedException(Logger.getLogger("org.apache.sis.gui"), Formatter.class, "call", e);
            }
            return new ReadOnlyObjectWrapper(value);
        }
    }

    private static final class ContentProperty
    extends SimpleObjectProperty<TreeTable> {
        private static final TableColumn<?>[] VALUES_COLUMNS = new TableColumn[]{TableColumn.VALUE, TableColumn.VALUE_AS_NUMBER, TableColumn.VALUE_AS_TEXT};

        ContentProperty(MetadataTree bean) {
            super((Object)bean, "content");
        }

        public void set(TreeTable data) {
            if (data != null) {
                List<TableColumn<?>> columns = data.getColumns();
                if (columns.contains(TableColumn.NAME)) {
                    for (TableColumn<?> value : VALUES_COLUMNS) {
                        if (!columns.contains(value)) continue;
                        ((MetadataTree)((Object)this.getBean())).valueSourceColumn = value;
                        break;
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
            super.set((Object)data);
        }
    }

    private static final class Item
    extends TreeItem<TreeTable.Node> {
        private final boolean isLeaf;

        Item(TreeTable.Node node) {
            super((Object)node);
            this.isLeaf = node.isLeaf() || node.getChildren().isEmpty();
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public ObservableList<TreeItem<TreeTable.Node>> getChildren() {
            ObservableList children = super.getChildren();
            if (children.isEmpty()) {
                Collection<TreeTable.Node> data = ((TreeTable.Node)this.getValue()).getChildren();
                ArrayList<Item> wrappers = new ArrayList<Item>(data.size());
                for (TreeTable.Node child : data) {
                    wrappers.add(new Item(child));
                }
                children.setAll(wrappers);
            }
            return children;
        }
    }

    static class Row
    extends TreeTableRow<TreeTable.Node>
    implements EventHandler<ActionEvent> {
        protected final ContextMenu menu;
        private final MenuItem view;
        private final MenuItem copy;

        Row(TreeTableView<TreeTable.Node> owner) {
            MetadataTree md = (MetadataTree)owner;
            Resources localized = Resources.forLocale(md.getLocale());
            this.view = new MenuItem(localized.getString((short)67));
            this.copy = new MenuItem(localized.getString((short)11));
            this.menu = new ContextMenu(new MenuItem[]{this.view, this.copy});
            this.copy.setOnAction((EventHandler)this);
            this.view.setOnAction(h -> ((MetadataTree)this.getTreeTableView()).showPropertyValue(this.getValue()));
        }

        protected void updateItem(TreeTable.Node item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setContextMenu(empty ? null : this.menu);
            boolean disabled = empty || this.getValue() == null;
            this.view.setDisable(disabled);
            this.copy.setDisable(disabled);
        }

        private Object getValue() {
            TreeTable.Node node = (TreeTable.Node)this.getItem();
            if (node != null) {
                Object obj = node.getUserObject();
                return obj != null ? obj : node.getValue(((MetadataTree)this.getTreeTableView()).valueSourceColumn);
            }
            return null;
        }

        public void handle(ActionEvent event) {
            Object value = this.getValue();
            if (value != null) {
                ClipboardContent content = new ClipboardContent();
                content.putString(Row.toString(value));
                Clipboard.getSystemClipboard().setContent((Map)content);
            }
        }

        static String toString(Object obj) {
            if (obj instanceof Throwable) {
                return ExceptionReporter.getStackTrace((Throwable)obj);
            }
            return obj.toString();
        }
    }
}

