/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.feature.j2d.EmptyShape;
import org.apache.sis.internal.feature.j2d.FlatShape;
import org.apache.sis.internal.gui.control.ColorRamp;
import org.apache.sis.internal.gui.control.ValueColorMapper;
import org.apache.sis.internal.processing.isoline.Isolines;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class IsolineRenderer {
    private final CoverageCanvas canvas;
    private Band[] bands;

    public IsolineRenderer(CoverageCanvas canvas) {
        if (canvas.isolines != null) {
            throw new IllegalArgumentException();
        }
        this.canvas = canvas;
        canvas.isolines = this;
    }

    private boolean isEmpty() {
        if (this.bands != null) {
            for (Band band : this.bands) {
                for (ValueColorMapper.Step level : band.steps) {
                    if (!level.visible.get()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    final void clear() {
        assert (Platform.isFxApplicationThread());
        if (this.bands != null) {
            for (Band band : this.bands) {
                band.clear();
            }
        }
    }

    public void setIsolineTables(List<ObservableList<ValueColorMapper.Step>> tables) {
        if (this.bands != null) {
            for (Band band : this.bands) {
                band.dispose();
            }
        }
        this.bands = null;
        if (tables != null && !tables.isEmpty()) {
            this.bands = new Band[tables.size()];
            for (int i = 0; i < this.bands.length; ++i) {
                this.bands[i] = new Band(tables.get(i));
            }
        }
    }

    final Snapshot[] prepare() {
        assert (Platform.isFxApplicationThread());
        if (this.isEmpty()) {
            return null;
        }
        Snapshot[] snapshots = new Snapshot[this.bands.length];
        HashSet<Double> keep = new HashSet<Double>();
        for (int i = 0; i < snapshots.length; ++i) {
            snapshots[i] = this.bands[i].prepare(keep);
        }
        return snapshots;
    }

    static Future<Isolines[]> generate(Snapshot[] snapshots, RenderedImage data, MathTransform gridToCRS) throws TransformException {
        assert (!Platform.isFxApplicationThread());
        double[][] levels = null;
        int numBands = ImageUtilities.getNumBands((RenderedImage)data);
        int numViews = Math.min(numBands, snapshots.length);
        for (int i = 0; i < numViews; ++i) {
            Snapshot s = snapshots[i];
            int n = s.missingLevels.size();
            if (n == 0) continue;
            if (levels == null) {
                levels = new double[numBands][];
                Arrays.fill((Object[])levels, ArraysExt.EMPTY_DOUBLE);
            }
            double[] values = new double[n];
            for (Double value : s.missingLevels.keySet()) {
                values[--n] = value;
            }
            assert (n == 0) : n;
            levels[i] = values;
        }
        if (levels != null) {
            return Isolines.parallelGenerate((RenderedImage)data, levels, (MathTransform)gridToCRS);
        }
        return null;
    }

    static void complete(Snapshot[] snapshots, Future<Isolines[]> newIsolines) throws ExecutionException, InterruptedException {
        int i;
        Isolines[] isolines = newIsolines.get();
        int n = Math.min(snapshots.length, isolines.length);
        for (i = 0; i < n; ++i) {
            snapshots[i].complete(isolines[i]);
        }
        while (i < snapshots.length) {
            snapshots[i++].clear();
        }
    }

    private final class Band
    implements ListChangeListener<ValueColorMapper.Step>,
    ChangeListener<Object> {
        final ObservableList<ValueColorMapper.Step> steps;
        private Map<Double, Shape> isolines;

        Band(ObservableList<ValueColorMapper.Step> steps) {
            this.steps = steps;
            this.addListeners((List<? extends ValueColorMapper.Step>)steps);
            steps.addListener((ListChangeListener)this);
        }

        final void clear() {
            this.isolines = null;
        }

        final void dispose() {
            this.clear();
            this.removeListeners((List<? extends ValueColorMapper.Step>)this.steps);
        }

        public void onChanged(ListChangeListener.Change<? extends ValueColorMapper.Step> change) {
            while (change.next()) {
                if (change.wasPermutated() || change.wasUpdated()) continue;
                this.removeListeners(change.getRemoved());
                this.addListeners(change.getAddedSubList());
            }
            IsolineRenderer.this.canvas.requestRepaint();
        }

        private void removeListeners(List<? extends ValueColorMapper.Step> list) {
            for (ValueColorMapper.Step step : list) {
                step.value.removeListener((ChangeListener)this);
                step.color.removeListener((ChangeListener)this);
                step.visible.removeListener((ChangeListener)this);
            }
        }

        private void addListeners(List<? extends ValueColorMapper.Step> list) {
            for (ValueColorMapper.Step step : list) {
                step.value.addListener((ChangeListener)this);
                step.color.addListener((ChangeListener)this);
                step.visible.addListener((ChangeListener)this);
            }
        }

        public void changed(ObservableValue<?> property, Object oldValue, Object newValue) {
            IsolineRenderer.this.canvas.requestRepaint();
        }

        final Snapshot prepare(Set<Double> keep) {
            if (this.isolines == null) {
                this.isolines = new HashMap<Double, Shape>();
            }
            Snapshot s = new Snapshot(this.isolines, this.steps.size());
            for (ValueColorMapper.Step level : this.steps) {
                ColorRamp cr;
                Double value = level.value.get();
                if (value.isNaN()) continue;
                keep.add(value);
                if (!level.visible.get() || (cr = (ColorRamp)level.color.get()) == null || cr.isTransparent()) continue;
                s.add(value, cr.colors[0]);
            }
            this.isolines.keySet().retainAll(keep);
            keep.clear();
            return s;
        }
    }

    static final class Snapshot {
        private final Map<Double, Shape> isolines;
        private final Map<Double, Integer> missingLevels;
        private Map<Double, Shape> newIsolines;
        private final Shape[] shapes;
        private final int[] colors;
        private int count;

        private Snapshot(Map<Double, Shape> isolines, int capacity) {
            this.isolines = isolines;
            this.missingLevels = new HashMap<Double, Integer>();
            this.shapes = new Shape[capacity];
            this.colors = new int[capacity];
        }

        private void clear() {
            this.isolines.clear();
            this.missingLevels.clear();
            this.newIsolines = null;
            Arrays.fill(this.shapes, null);
            this.count = 0;
        }

        private void add(Double value, int color) {
            Shape shape = this.isolines.putIfAbsent(value, (Shape)EmptyShape.INSTANCE);
            if (shape == null) {
                this.missingLevels.put(value, this.count);
            }
            this.shapes[this.count] = shape;
            this.colors[this.count] = color;
            ++this.count;
        }

        private void complete(Isolines isolines) {
            this.newIsolines = isolines.polylines();
            for (Map.Entry<Double, Shape> entry : this.newIsolines.entrySet()) {
                Integer j = this.missingLevels.get(entry.getKey());
                if (j == null) continue;
                this.shapes[j.intValue()] = entry.getValue();
            }
        }

        final void paint(Graphics2D target, Rectangle2D areaOfInterest) {
            for (int i = 0; i < this.count; ++i) {
                Shape shape = this.shapes[i];
                if (shape == null || areaOfInterest != null && shape instanceof FlatShape && (shape = ((FlatShape)shape).fastClip(areaOfInterest)) == null) continue;
                target.setColor(new Color(this.colors[i], true));
                target.draw(shape);
            }
        }

        final void commit() {
            assert (Platform.isFxApplicationThread());
            if (this.newIsolines != null) {
                this.isolines.putAll(this.newIsolines);
            }
        }
    }
}

