/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.OptionalInt;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.internal.gui.RecentChoices;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.util.Numbers;

final class CellFormat
extends SimpleStringProperty {
    private static final String SYMBOL_NaN = "\u2b1a";
    private String classicFormatPattern;
    private final NumberFormat cellFormat = NumberFormat.getInstance();
    private final FieldPosition formatField = new FieldPosition(0);
    private final StringBuffer buffer = new StringBuffer();
    private double lastValue;
    private String lastValueAsText;
    boolean dataTypeIsInteger;
    private boolean isAdjusting;

    CellFormat(GridView bean) {
        super((Object)bean, "cellFormatPattern");
        this.updatePropertyValue();
    }

    final boolean hasPattern() {
        return this.cellFormat instanceof DecimalFormat;
    }

    private void updatePropertyValue() {
        if (this.cellFormat instanceof DecimalFormat) {
            super.setValue(((DecimalFormat)this.cellFormat).toLocalizedPattern());
        }
    }

    public void setValue(String pattern) {
        if (this.cellFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.cellFormat).applyLocalizedPattern(pattern);
            this.updatePropertyValue();
            ((GridView)((Object)this.getBean())).contentChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPatternSelected(ComboBox<String> choices, String newValue) {
        if (!this.isAdjusting) {
            boolean error;
            String message;
            try {
                this.isAdjusting = true;
                this.setValue(newValue);
                message = null;
                error = false;
            }
            catch (IllegalArgumentException e) {
                message = e.getLocalizedMessage();
                error = true;
            }
            finally {
                this.isAdjusting = false;
            }
            Tooltip tooltip = null;
            if (message != null) {
                tooltip = choices.getTooltip();
                if (tooltip != null) {
                    tooltip.setText(message);
                } else {
                    tooltip = new Tooltip(message);
                    tooltip.setShowDelay(Duration.seconds((double)0.1));
                }
            }
            choices.setTooltip(tooltip);
            choices.getEditor().pseudoClassStateChanged(Styles.ERROR, error);
        }
    }

    final ComboBox<String> createEditor() {
        if (!this.hasPattern()) {
            return null;
        }
        int min = this.cellFormat.getMinimumFractionDigits();
        int max = this.cellFormat.getMaximumFractionDigits();
        Object[] patterns = new String[max + 2];
        patterns[max + 1] = this.getValue();
        this.cellFormat.setMinimumFractionDigits(max);
        for (int n2 = max; n2 >= 0; --n2) {
            this.cellFormat.setMaximumFractionDigits(n2);
            patterns[n2] = ((DecimalFormat)this.cellFormat).toLocalizedPattern();
        }
        this.cellFormat.setMinimumFractionDigits(min);
        this.cellFormat.setMaximumFractionDigits(max);
        ComboBox choices = new ComboBox();
        choices.setEditable(true);
        choices.getItems().setAll(patterns);
        choices.getSelectionModel().selectFirst();
        choices.getSelectionModel().selectedItemProperty().addListener((e, o, n) -> this.onPatternSelected((ComboBox<String>)choices, (String)n));
        this.addListener((e, o, n) -> RecentChoices.setInList(choices, n));
        return choices;
    }

    final void configure(RenderedImage image, int band) {
        if (this.dataTypeIsInteger) {
            this.cellFormat.setMaximumFractionDigits(0);
        } else {
            int n = CellFormat.getFractionDigits(image, band).orElse(1);
            if (n > 6 || n < -9) {
                if (this.cellFormat instanceof DecimalFormat) {
                    if (this.classicFormatPattern == null) {
                        DecimalFormat df = (DecimalFormat)this.cellFormat;
                        this.classicFormatPattern = df.toPattern();
                        df.applyPattern("0.000E00");
                    }
                    n = 3;
                }
            } else if (this.classicFormatPattern != null) {
                ((DecimalFormat)this.cellFormat).applyPattern(this.classicFormatPattern);
                this.classicFormatPattern = null;
            }
            if (n < 0) {
                n = 0;
            }
            this.cellFormat.setMinimumFractionDigits(n);
            this.cellFormat.setMaximumFractionDigits(n);
        }
        this.buffer.setLength(0);
        this.formatCell(this.lastValue);
        this.updatePropertyValue();
    }

    private static OptionalInt getFractionDigits(RenderedImage image, int band) {
        double resolution;
        Object property = image.getProperty("org.apache.sis.SampleResolution");
        if (property != null && Numbers.isNumber(property.getClass().getComponentType()) && band < Array.getLength(property) && (resolution = Math.abs(((Number)Array.get(property, band)).doubleValue())) > 0.0 && resolution <= Double.MAX_VALUE) {
            return OptionalInt.of(DecimalFunctions.fractionDigitsForDelta(resolution, false));
        }
        return OptionalInt.empty();
    }

    final String format(Raster tile, int x, int y, int b) {
        this.buffer.setLength(0);
        if (this.dataTypeIsInteger) {
            int integer = tile.getSample(x, y, b);
            double value = integer;
            if (Double.doubleToRawLongBits(value) != Double.doubleToRawLongBits(this.lastValue)) {
                this.lastValueAsText = this.cellFormat.format(integer, this.buffer, this.formatField).toString();
                this.lastValue = value;
            }
        } else {
            double value = tile.getSampleDouble(x, y, b);
            if (Double.doubleToRawLongBits(value) != Double.doubleToRawLongBits(this.lastValue)) {
                this.formatCell(value);
                this.lastValue = value;
            }
        }
        return this.lastValueAsText;
    }

    private void formatCell(double value) {
        this.lastValueAsText = Double.isNaN(value) ? SYMBOL_NaN : this.cellFormat.format(value, this.buffer, this.formatField).toString();
    }

    final String format(Number value) {
        this.buffer.setLength(0);
        return this.cellFormat.format(value, this.buffer, this.formatField).toString();
    }

    final String format(NumberFormat headerFormat, long value) {
        this.buffer.setLength(0);
        return headerFormat.format(value, this.buffer, this.formatField).toString();
    }
}

