/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.StringJoiner;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import org.apache.sis.gui.dataset.ResourceEvent;
import org.apache.sis.gui.dataset.ResourceExplorer;
import org.apache.sis.internal.gui.RecentChoices;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.util.ArraysExt;

final class RecentFiles
implements EventHandler<ActionEvent> {
    static final int MAX_COUNT = 10;
    private final ObservableList<MenuItem> items;
    private final ResourceExplorer explorer;
    private final File[] allFiles;

    private RecentFiles(ResourceExplorer explorer, Menu menu) {
        this.explorer = explorer;
        this.items = menu.getItems();
        this.allFiles = new File[10];
        CharSequence[] paths = RecentChoices.getFiles();
        MenuItem[] menus = new MenuItem[paths.length];
        int limit = Math.min(paths.length, 10);
        int count = 0;
        for (int i = 0; i < limit; ++i) {
            File file;
            String path = paths[i].toString();
            if (path.isBlank()) continue;
            this.allFiles[count] = file = new File(path);
            menus[count++] = this.createItem(file);
        }
        this.items.setAll((Object[])ArraysExt.resize(menus, count));
    }

    static Menu create(ResourceExplorer explorer, Resources localized) {
        Menu menu = new Menu(localized.getString((short)54));
        RecentFiles handler = new RecentFiles(explorer, menu);
        explorer.setOnResourceLoaded((EventHandler<ResourceEvent>)((EventHandler)e -> handler.touched((ResourceEvent)e, false)));
        explorer.setOnResourceClosed((EventHandler<ResourceEvent>)((EventHandler)e -> handler.touched((ResourceEvent)e, true)));
        return menu;
    }

    private MenuItem createItem(File file) {
        MenuItem item = new MenuItem(file.getName());
        item.setUserData((Object)file);
        item.setOnAction((EventHandler)this);
        return item;
    }

    private void touched(ResourceEvent event, boolean closed) {
        File f;
        int i;
        File file;
        Path path = event.getResourcePath();
        try {
            file = path.toFile();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int size = this.items.size();
        MenuItem item = null;
        for (i = 0; i < size; ++i) {
            if (!file.equals(((MenuItem)this.items.get(i)).getUserData())) continue;
            item = (MenuItem)this.items.remove(i);
            break;
        }
        if (closed) {
            if (item == null) {
                if (size >= 10) {
                    item = (MenuItem)this.items.remove(size - 1);
                    item.setText(file.getName());
                    item.setUserData((Object)file);
                } else {
                    item = this.createItem(file);
                }
            }
            this.items.add(0, item);
        }
        i = 0;
        while ((f = this.allFiles[i]) != null && !file.equals(f) && ++i < 9) {
        }
        System.arraycopy(this.allFiles, 0, this.allFiles, 1, i);
        this.allFiles[0] = file;
        StringJoiner s = new StringJoiner(System.lineSeparator());
        for (File f2 : this.allFiles) {
            if (f2 == null) break;
            s.add(f2.getPath());
        }
        RecentChoices.setFiles(s.toString());
    }

    public void handle(ActionEvent event) {
        Object file = ((MenuItem)event.getSource()).getUserData();
        this.explorer.loadResources(Collections.singleton(file));
    }
}

