/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.stream;

import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.apache.sis.internal.stream.DoubleStreamWrapper;

public final class PaginedDoubleStream
extends DoubleStreamWrapper {
    private Stream<?> root;

    public PaginedDoubleStream(DoubleStream doubleStream, Stream<?> stream) {
        super(doubleStream);
        this.root = stream;
    }

    @Override
    public DoubleStream skip(long l) {
        this.root = this.root.skip(l);
        return this;
    }

    @Override
    public DoubleStream limit(long l) {
        this.root = this.root.limit(l);
        return this;
    }

    @Override
    public long count() {
        return this.root.count();
    }

    @Override
    public DoubleStream map(DoubleUnaryOperator doubleUnaryOperator) {
        return new PaginedDoubleStream(super.map(doubleUnaryOperator), this.root);
    }

    @Override
    public DoubleStream distinct() {
        return this.delegate().distinct();
    }

    @Override
    public DoubleStream unordered() {
        return (DoubleStream)this.delegate().unordered();
    }

    @Override
    public DoubleStream sorted() {
        return this.delegate().sorted();
    }

    @Override
    public DoubleStream filter(DoublePredicate doublePredicate) {
        return this.delegate().filter(doublePredicate);
    }
}

