/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.stream;

import java.util.Spliterator;
import java.util.stream.StreamSupport;
import org.apache.sis.internal.stream.StreamWrapper;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.BackingStoreException;

public abstract class DeferredStream<T>
extends StreamWrapper<T> {
    private final CloseHandler closeHandler;

    protected DeferredStream(int n, boolean bl) {
        this.source = StreamSupport.stream(this::terminal, n, bl);
        this.closeHandler = new CloseHandler();
        this.source.onClose(this.closeHandler);
        this.toClose = this.source;
    }

    private Spliterator<T> terminal() {
        this.source = null;
        try {
            return this.createSourceIterator();
        }
        catch (Exception exception) {
            BackingStoreException backingStoreException = exception instanceof BackingStoreException ? (BackingStoreException)exception : new BackingStoreException(Exceptions.unwrap(exception));
            throw backingStoreException;
        }
    }

    protected abstract Spliterator<T> createSourceIterator() throws Exception;

    protected final void setCloseHandler(AutoCloseable autoCloseable) {
        this.closeHandler.handler = autoCloseable;
    }

    private static final class CloseHandler
    implements Runnable {
        AutoCloseable handler;

        private CloseHandler() {
        }

        @Override
        public void run() {
            AutoCloseable autoCloseable = this.handler;
            this.handler = null;
            if (autoCloseable != null) {
                try {
                    autoCloseable.close();
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new BackingStoreException(exception);
                }
            }
        }
    }
}

