/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.postgis;

import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.sql.feature.InfoStatements;
import org.apache.sis.internal.sql.postgis.Band;
import org.apache.sis.internal.sql.postgis.RasterFormat;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public final class RasterReader
extends RasterFormat {
    private AffineTransform2D gridToCRS;
    public CoordinateReferenceSystem defaultCRS;
    private int srid;
    private Band[] bands;
    private transient SampleModel cachedModel;
    private ByteBuffer buffer;

    public RasterReader(InfoStatements infoStatements) {
        super(infoStatements);
    }

    public void reset() {
        this.gridToCRS = null;
        this.bands = null;
        this.srid = 0;
    }

    public AffineTransform2D getGridToCRS() {
        return this.gridToCRS;
    }

    public int getSRID() {
        return this.srid;
    }

    private boolean needsTransferFunction() {
        for (Band band : this.bands) {
            if (band.noDataValue == null && (band.getDataBufferType() & 8) == 0) continue;
            return true;
        }
        return false;
    }

    private static RasterFormatException malformed(ChannelDataInput channelDataInput) {
        return new RasterFormatException(Errors.format((short)139, "WKB", channelDataInput.filename));
    }

    public WritableRaster readAsRaster(ChannelDataInput channelDataInput) throws IOException {
        SampleModel sampleModel;
        DataBuffer dataBuffer;
        int n;
        int n2;
        Object[] objectArray;
        int n3;
        ByteOrder byteOrder;
        switch (channelDataInput.readUnsignedByte()) {
            case 0: {
                byteOrder = ByteOrder.BIG_ENDIAN;
                break;
            }
            case 1: {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            default: {
                throw RasterReader.malformed(channelDataInput);
            }
        }
        channelDataInput.buffer.order(byteOrder);
        int n4 = channelDataInput.readUnsignedShort();
        if (n4 != 0) {
            throw new IOException(Errors.format((short)159, "WKB", n4));
        }
        int n5 = channelDataInput.readUnsignedShort();
        double d = channelDataInput.readDouble();
        double d2 = channelDataInput.readDouble();
        double d3 = channelDataInput.readDouble();
        double d4 = channelDataInput.readDouble();
        double d5 = channelDataInput.readDouble();
        double d6 = channelDataInput.readDouble();
        this.gridToCRS = new AffineTransform2D(d, d6, d5, d2, d3, d4);
        this.srid = channelDataInput.readInt();
        if (n5 == 0) {
            return null;
        }
        int n6 = channelDataInput.readUnsignedShort();
        int n7 = channelDataInput.readUnsignedShort();
        Band[] bandArray = new Band[n5];
        for (int i = 0; i < n5; ++i) {
            Object[] objectArray2;
            Band band = new Band(channelDataInput.readUnsignedByte());
            n3 = band.getDataBufferType();
            switch (n3) {
                case 0: {
                    objectArray = channelDataInput.readUnsignedByte();
                    break;
                }
                case 8: {
                    objectArray = channelDataInput.readByte();
                    break;
                }
                case 2: {
                    objectArray = channelDataInput.readShort();
                    break;
                }
                case 1: {
                    objectArray = channelDataInput.readUnsignedShort();
                    break;
                }
                case 3: {
                    objectArray = channelDataInput.readInt();
                    break;
                }
                case 11: {
                    objectArray = channelDataInput.readUnsignedInt();
                    break;
                }
                case 4: {
                    objectArray = Float.valueOf(channelDataInput.readFloat());
                    break;
                }
                case 5: {
                    objectArray = channelDataInput.readDouble();
                    break;
                }
                default: {
                    throw RasterReader.malformed(channelDataInput);
                }
            }
            if (band.hasNodata()) {
                band.noDataValue = objectArray;
            }
            if (band.isOffline()) {
                throw new RasterFormatException("Offline raster data is not yet supported.");
            }
            n2 = band.getDataTypeSize();
            int n8 = DataBuffer.getDataTypeSize(n3);
            n = Math.toIntExact(Numerics.ceilDiv(JDK9.multiplyFull(n6, n7) * (long)n2, (long)n8));
            switch (n3 & 0xFFFFFFF7) {
                case 1: 
                case 2: {
                    objectArray2 = channelDataInput.readShorts(n);
                    break;
                }
                case 0: {
                    objectArray2 = channelDataInput.readBytes(n);
                    break;
                }
                case 3: {
                    objectArray2 = channelDataInput.readInts(n);
                    break;
                }
                case 4: {
                    objectArray2 = band.toNaN(channelDataInput.readFloats(n));
                    break;
                }
                case 5: {
                    objectArray2 = band.toNaN(channelDataInput.readDoubles(n));
                    break;
                }
                default: {
                    throw RasterReader.malformed(channelDataInput);
                }
            }
            band.data = objectArray2;
            bandArray[i] = band;
        }
        Band band = bandArray[0];
        int n9 = band.getDataBufferType();
        n3 = Array.getLength(band.data);
        objectArray = (Object[])Array.newInstance(band.data.getClass(), n5);
        objectArray[0] = band.data;
        for (n2 = 1; n2 < n5; ++n2) {
            Band band2 = bandArray[n2];
            if (band2.getDataBufferType() != n9 || Array.getLength(band2.data) != n3) {
                throw new RasterFormatException("Bands of different types are not yet supported.");
            }
            objectArray[n2] = band2.data;
        }
        this.bands = bandArray;
        switch (n9 &= 0xFFFFFFF7) {
            case 0: {
                dataBuffer = new DataBufferByte((byte[][])objectArray, n3);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort((short[][])objectArray, n3);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort((short[][])objectArray, n3);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt((int[][])objectArray, n3);
                break;
            }
            case 4: {
                dataBuffer = new DataBufferFloat((float[][])objectArray, n3);
                break;
            }
            case 5: {
                dataBuffer = new DataBufferDouble((double[][])objectArray, n3);
                break;
            }
            default: {
                throw RasterReader.malformed(channelDataInput);
            }
        }
        n = band.getDataTypeSize();
        if (n >= 8) {
            sampleModel = new BandedSampleModel(n9, n6, n7, n5);
        } else if (n5 == 1) {
            sampleModel = new MultiPixelPackedSampleModel(n9, n6, n7, n);
        } else {
            throw new RasterFormatException("Multi-bands packed model is not yet supported.");
        }
        if (((Object)sampleModel).equals(this.cachedModel)) {
            sampleModel = this.cachedModel;
        }
        this.cachedModel = sampleModel;
        return WritableRaster.createWritableRaster(sampleModel, dataBuffer, null);
    }

    public BufferedImage readAsImage(ChannelDataInput channelDataInput) throws IOException {
        ColorModel colorModel;
        WritableRaster writableRaster = this.readAsRaster(channelDataInput);
        if (writableRaster == null) {
            return null;
        }
        SampleModel sampleModel = writableRaster.getSampleModel();
        int n = sampleModel.getDataType();
        int n2 = sampleModel.getNumBands();
        if (n2 == 3 && n == 0) {
            colorModel = ColorModelFactory.createRGB(8, false, false);
        } else {
            double d;
            double d2;
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                int n3 = ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride();
                d2 = (1 << n3) - 1;
                d = 0.0;
            } else if (n == 0) {
                d = 0.0;
                d2 = 255.0;
            } else {
                Band band = this.bands[0];
                NumberRange<?> numberRange = Vector.create(band.data, band.isUnsigned()).range();
                d = numberRange.getMinDouble();
                d2 = numberRange.getMaxDouble();
            }
            colorModel = ColorModelFactory.createGrayScale(n, n2, 0, d, d2);
        }
        return new BufferedImage(colorModel, writableRaster, false, null);
    }

    public GridCoverage readAsCoverage(ChannelDataInput channelDataInput) throws Exception {
        BufferedImage bufferedImage = this.readAsImage(channelDataInput);
        if (bufferedImage == null) {
            return null;
        }
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        int n = this.getSRID();
        if (this.spatialRefSys != null) {
            coordinateReferenceSystem = this.spatialRefSys.fetchCRS(n);
        } else if (n > 0) {
            coordinateReferenceSystem = CRS.forCode((String)("EPSG:" + n));
        }
        if (coordinateReferenceSystem == null) {
            coordinateReferenceSystem = this.defaultCRS;
        }
        GridExtent gridExtent = new GridExtent((long)bufferedImage.getWidth(), bufferedImage.getHeight());
        GridGeometry gridGeometry = new GridGeometry(gridExtent, ANCHOR, (MathTransform)this.getGridToCRS(), coordinateReferenceSystem);
        List<SampleDimension> list = null;
        if (this.needsTransferFunction()) {
            SampleDimension[] sampleDimensionArray = new SampleDimension[this.bands.length];
            SampleDimension.Builder builder = new SampleDimension.Builder();
            for (int i = 0; i < sampleDimensionArray.length; ++i) {
                Band band = this.bands[i];
                if ((band.getDataBufferType() & 8) != 0) {
                    throw new RasterFormatException("Data type not yet supported.");
                }
                sampleDimensionArray[i] = builder.setName(i + 1).setBackground(band.noDataValue).build();
                builder.clear();
            }
            list = Arrays.asList(sampleDimensionArray);
        }
        return new GridCoverage2D(gridGeometry, list, bufferedImage);
    }

    public ChannelDataInput channel(InputStream inputStream) throws IOException {
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(8192);
        }
        return new ChannelDataInput("raster", Channels.newChannel(inputStream), this.buffer, false);
    }
}

