/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.internal.sql.feature.Analyzer;
import org.apache.sis.internal.sql.feature.Column;
import org.apache.sis.internal.sql.feature.Database;
import org.apache.sis.internal.sql.feature.FeatureAdapter;
import org.apache.sis.internal.sql.feature.FeatureAnalyzer;
import org.apache.sis.internal.sql.feature.FeatureStream;
import org.apache.sis.internal.sql.feature.PrimaryKey;
import org.apache.sis.internal.sql.feature.Relation;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.opengis.geometry.Envelope;
import org.opengis.util.GenericName;

final class Table
extends AbstractFeatureSet {
    final Database<?> database;
    final DefaultFeatureType featureType;
    private final String query;
    final TableReference name;
    final Column[] attributes;
    final PrimaryKey primaryKey;
    final Relation[] importedKeys;
    final Relation[] exportedKeys;
    final boolean hasGeometry;
    final boolean hasRaster;
    private Map<String, Column> attributeToColumns;
    private FeatureAdapter adapter;
    private WeakValueHashMap<?, Object> instanceForPrimaryKeys;
    private boolean isEnvelopeAnalyzed;

    Table(Database<?> database, FeatureAnalyzer featureAnalyzer, String string) throws Exception {
        super(database.listeners, false);
        this.database = database;
        this.query = string;
        this.name = featureAnalyzer.id;
        this.importedKeys = featureAnalyzer.getForeignerKeys(Relation.Direction.IMPORT);
        this.exportedKeys = featureAnalyzer.getForeignerKeys(Relation.Direction.EXPORT);
        this.attributes = featureAnalyzer.createAttributes();
        this.primaryKey = featureAnalyzer.createAssociations(this.exportedKeys);
        this.featureType = featureAnalyzer.buildFeatureType();
        this.hasGeometry = featureAnalyzer.hasGeometry;
        this.hasRaster = featureAnalyzer.hasRaster;
    }

    Table(Table table) {
        super(table.listeners, false);
        this.database = table.database;
        this.query = table.query;
        this.name = table.name;
        this.primaryKey = table.primaryKey;
        this.attributes = table.attributes;
        this.importedKeys = table.importedKeys;
        this.exportedKeys = table.exportedKeys;
        this.featureType = table.featureType;
        this.hasGeometry = table.hasGeometry;
        this.hasRaster = table.hasRaster;
    }

    final void setDeferredSearchTables(Analyzer analyzer, Map<GenericName, Table> map) throws DataStoreException {
        block8: for (Relation.Direction direction : Relation.Direction.values()) {
            Relation[] relationArray;
            switch (direction) {
                case IMPORT: {
                    relationArray = this.importedKeys;
                    break;
                }
                case EXPORT: {
                    relationArray = this.exportedKeys;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            for (Relation relation : relationArray) {
                PrimaryKey primaryKey;
                if (!relation.isSearchTableDeferred()) continue;
                DefaultAssociationRole defaultAssociationRole = (DefaultAssociationRole)this.featureType.getProperty(relation.propertyName);
                Table table = map.get(defaultAssociationRole.getValueType().getName());
                if (table == null) {
                    throw new InternalDataStoreException(defaultAssociationRole.toString());
                }
                switch (direction) {
                    case IMPORT: {
                        primaryKey = table.primaryKey;
                        break;
                    }
                    case EXPORT: {
                        primaryKey = this.primaryKey;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)direction);
                    }
                }
                if (primaryKey == null) continue;
                relation.setSearchTable(analyzer, table, primaryKey, direction);
            }
        }
    }

    private static void appendAll(TreeTable.Node node, Relation[] relationArray, String string) {
        for (Relation relation : relationArray) {
            relation.appendTo(node, string);
        }
    }

    final void appendTo(TreeTable.Node node) {
        node = Relation.newChild(node, this.featureType.getName().toString());
        for (Column column : this.attributes) {
            TableReference.newChild(node, column.propertyName);
        }
        Table.appendAll(node, this.importedKeys, " \u2192 ");
        Table.appendAll(node, this.exportedKeys, " \u2190 ");
    }

    public String toString() {
        return TableReference.toString((Object)this, node -> this.appendTo((TreeTable.Node)node));
    }

    public final Optional<GenericName> getIdentifier() {
        return Optional.of(this.featureType.getName().toFullyQualifiedName());
    }

    public final DefaultFeatureType getType() {
        return this.featureType;
    }

    public Optional<Envelope> getEnvelope() throws DataStoreException {
        if (this.hasGeometry) {
            try {
                boolean bl = this.isEnvelopeAnalyzed;
                this.isEnvelopeAnalyzed = true;
                return Optional.ofNullable(this.database.getEstimatedExtent(this.name, this.attributes, bl));
            }
            catch (SQLException sQLException) {
                throw new DataStoreException((Throwable)sQLException);
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Column getColumn(String string) {
        Map<String, Column> map;
        Table table = this;
        synchronized (table) {
            map = this.attributeToColumns;
            if (map == null) {
                map = new HashMap<String, Column>(Containers.hashMapCapacity(this.attributes.length));
                for (Column column : this.attributes) {
                    String string2 = column.propertyName;
                    map.put(string2, column);
                    int n = string2.lastIndexOf(58);
                    if (n < 0) continue;
                    map.putIfAbsent(string2.substring(n + 1), column);
                }
                this.attributeToColumns = map;
            }
        }
        return map.get(string);
    }

    final Relation getInverseOf(Relation relation, TableReference tableReference) {
        if (this.name.equals(relation)) {
            for (Relation relation2 : this.importedKeys) {
                if (!relation2.equals(tableReference) || !relation2.isInverseOf(relation)) continue;
                return relation2;
            }
        }
        return null;
    }

    final synchronized WeakValueHashMap<?, Object> instanceForPrimaryKeys() {
        if (this.instanceForPrimaryKeys == null) {
            this.instanceForPrimaryKeys = new WeakValueHashMap(this.primaryKey.valueClass);
        }
        return this.instanceForPrimaryKeys;
    }

    final void appendFromClause(SQLBuilder sQLBuilder) {
        sQLBuilder.append(" FROM ");
        if (this.query != null) {
            sQLBuilder.append('(').append(this.query).append(") AS USER_QUERY");
        } else {
            sQLBuilder.appendIdentifier(this.name.catalog, this.name.schema, this.name.table);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final long countRows(DatabaseMetaData databaseMetaData, boolean bl, boolean bl2) throws SQLException {
        long l = -1L;
        String[] stringArray = TableReference.splitName(this.featureType.getName());
        try (ResultSet resultSet = databaseMetaData.getIndexInfo(stringArray[2], stringArray[1], stringArray[0], bl, bl2);){
            while (resultSet.next()) {
                long l2 = resultSet.getLong("CARDINALITY");
                if (resultSet.wasNull()) continue;
                if (resultSet.getShort("TYPE") == 0) {
                    long l3 = l2;
                    return l3;
                }
                if (l2 <= l) continue;
                l = l2;
            }
            return l;
        }
    }

    final synchronized FeatureAdapter adapter(Connection connection) throws SQLException, InternalDataStoreException {
        if (this.adapter == null) {
            this.adapter = new FeatureAdapter(this, connection.getMetaData());
        }
        return this.adapter;
    }

    public Stream<AbstractFeature> features(boolean bl) throws DataStoreException {
        return new FeatureStream(this, bl);
    }
}

