/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.InternationalString;

public final class Resources
extends IndexedResourceBundle {
    public Resources(URL uRL) {
        super(uRL);
    }

    @Override
    protected KeyConstants getKeyConstants() {
        return Keys.INSTANCE;
    }

    public static Resources forLocale(Locale locale) throws MissingResourceException {
        return Resources.getBundle(Resources.class, locale);
    }

    public static String format(short s) throws MissingResourceException {
        return Resources.forLocale(null).getString(s);
    }

    public static String format(short s, Object object) throws MissingResourceException {
        return Resources.forLocale(null).getString(s, object);
    }

    public static String format(short s, Object object, Object object2) throws MissingResourceException {
        return Resources.forLocale(null).getString(s, object, object2);
    }

    public static InternationalString formatInternational(short s) {
        return new International(s);
    }

    public static ResourceInternationalString formatInternational(short s, Object ... objectArray) {
        return new International(s, objectArray);
    }

    public static final class Keys
    extends KeyConstants {
        static final Keys INSTANCE = new Keys();
        public static final short CanNotFetchCRS_1 = 8;
        public static final short CanNotFindSRID_1 = 15;
        public static final short DataSource = 1;
        public static final short DuplicatedColumn_1 = 5;
        public static final short DuplicatedSRID_2 = 9;
        public static final short IllegalQualifiedName_1 = 3;
        public static final short InternalError = 6;
        public static final short MalformedForeignerKey_2 = 7;
        public static final short MappedSQLQueries = 14;
        public static final short NameAlreadyUsed_1 = 13;
        public static final short QualifiedTableNames = 2;
        public static final short SpatialExtensionNotFound_1 = 12;
        public static final short UnexpectedTypeForSRID_2 = 11;
        public static final short UnknownSRID_2 = 10;
        public static final short UnknownType_1 = 4;

        private Keys() {
        }
    }

    private static final class International
    extends ResourceInternationalString {
        private static final long serialVersionUID = 7325356372249131588L;

        International(short s) {
            super(s);
        }

        International(short s, Object object) {
            super(s, object);
        }

        @Override
        protected KeyConstants getKeyConstants() {
            return Keys.INSTANCE;
        }

        @Override
        protected IndexedResourceBundle getBundle(Locale locale) {
            return Resources.forLocale(locale);
        }
    }
}

