/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.sql.feature.Analyzer;
import org.apache.sis.internal.sql.feature.Column;
import org.apache.sis.internal.sql.feature.FeatureAnalyzer;
import org.apache.sis.internal.sql.feature.InfoStatements;
import org.apache.sis.internal.sql.feature.Relation;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.DataStoreException;
import org.opengis.util.GenericName;

final class QueryAnalyzer
extends FeatureAnalyzer {
    private final String query;
    private final Column[] columns;
    private final Map<TableReference, Map<String, Column>> columnsPerTable;

    QueryAnalyzer(Analyzer analyzer, GenericName genericName, String string, String string2) throws Exception {
        super(analyzer, new TableReference(genericName, string2));
        this.query = string;
        String string3 = analyzer.metadata.getIdentifierQuoteString();
        try (PreparedStatement preparedStatement = analyzer.metadata.getConnection().prepareStatement(string);){
            ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
            this.columns = new Column[resultSetMetaData.getColumnCount()];
            this.columnsPerTable = new HashMap<TableReference, Map<String, Column>>();
            for (int i = 1; i <= this.columns.length; ++i) {
                TableReference tableReference2;
                Map map;
                Column column;
                this.columns[i - 1] = column = new Column(resultSetMetaData, i, string3);
                String string4 = Strings.trimOrNull(resultSetMetaData.getTableName(i));
                if (string4 == null || (map = this.columnsPerTable.computeIfAbsent(tableReference2 = new TableReference(Strings.trimOrNull(resultSetMetaData.getCatalogName(i)), Strings.trimOrNull(resultSetMetaData.getSchemaName(i)), string4, null), tableReference -> new HashMap())).put(column.name, column) == null) continue;
                throw this.duplicatedColumn(column);
            }
        }
    }

    @Override
    Relation[] getForeignerKeys(Relation.Direction direction) throws SQLException, DataStoreException {
        boolean bl = direction == Relation.Direction.IMPORT;
        ArrayList<String> arrayList = bl ? new ArrayList<String>() : null;
        ArrayList<Relation> arrayList2 = new ArrayList<Relation>();
        for (Map.Entry<TableReference, Map<String, Column>> entry : this.columnsPerTable.entrySet()) {
            Set<String> set = entry.getValue().keySet();
            TableReference tableReference = entry.getKey();
            try (ResultSet resultSet = bl ? this.analyzer.metadata.getImportedKeys(tableReference.catalog, tableReference.schema, tableReference.table) : this.analyzer.metadata.getExportedKeys(tableReference.catalog, tableReference.schema, tableReference.table);){
                if (resultSet.next()) {
                    do {
                        Relation relation;
                        if (!set.containsAll((relation = new Relation(this.analyzer, direction, resultSet)).getOwnerColumns())) continue;
                        if (bl) {
                            this.addForeignerKeys(relation);
                        }
                        arrayList2.add(relation);
                    } while (!resultSet.isClosed());
                }
            }
            if (arrayList == null) continue;
            resultSet = this.analyzer.metadata.getPrimaryKeys(tableReference.catalog, tableReference.schema, tableReference.table);
            try {
                while (resultSet.next()) {
                    arrayList.add(this.analyzer.getUniqueString(resultSet, "COLUMN_NAME"));
                }
                if (set.containsAll(arrayList)) {
                    this.primaryKey.addAll(arrayList);
                    arrayList.clear();
                    continue;
                }
                this.primaryKey.clear();
                arrayList = null;
            }
            finally {
                if (resultSet == null) continue;
                resultSet.close();
            }
        }
        int n = arrayList2.size();
        return n != 0 ? arrayList2.toArray(new Relation[n]) : Relation.EMPTY;
    }

    @Override
    Column[] createAttributes() throws Exception {
        InfoStatements infoStatements = this.analyzer.spatialInformation;
        if (infoStatements != null) {
            for (Map.Entry object : this.columnsPerTable.entrySet()) {
                infoStatements.completeIntrospection((TableReference)object.getKey(), (Map)object.getValue());
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Column column : this.columns) {
            if (!this.createAttribute(column)) continue;
            arrayList.add(column);
        }
        return arrayList.toArray(new Column[arrayList.size()]);
    }
}

