/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;

abstract class PrimaryKey {
    final Class<?> valueClass;

    PrimaryKey(Class<?> clazz) {
        this.valueClass = clazz;
    }

    static PrimaryKey create(Class<?> clazz, Collection<String> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        String string = CollectionsExt.singletonOrNull(collection);
        return string != null ? new Single(clazz, string) : new Composite(clazz, collection);
    }

    public abstract List<String> getColumns();

    private static final class Single
    extends PrimaryKey {
        private final String column;

        Single(Class<?> clazz, String string) {
            super(clazz);
            this.column = string;
        }

        @Override
        public List<String> getColumns() {
            return Collections.singletonList(this.column);
        }
    }

    private static final class Composite
    extends PrimaryKey {
        private final List<String> columns;

        Composite(Class<?> clazz, Collection<String> collection) {
            super(clazz);
            this.columns = UnmodifiableArrayList.wrap(collection.toArray(new String[collection.size()]));
        }

        @Override
        public List<String> getColumns() {
            return this.columns;
        }
    }
}

