/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.LogRecord;
import javax.sql.DataSource;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.metadata.sql.Dialect;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.internal.metadata.sql.Syntax;
import org.apache.sis.internal.sql.feature.Analyzer;
import org.apache.sis.internal.sql.feature.BinaryEncoding;
import org.apache.sis.internal.sql.feature.Column;
import org.apache.sis.internal.sql.feature.GeometryGetter;
import org.apache.sis.internal.sql.feature.InfoStatements;
import org.apache.sis.internal.sql.feature.SchemaModifier;
import org.apache.sis.internal.sql.feature.SelectionClauseWriter;
import org.apache.sis.internal.sql.feature.Table;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.internal.sql.feature.ValueGetter;
import org.apache.sis.internal.sql.postgis.Postgres;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.FeatureNaming;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.sql.ResourceDefinition;
import org.apache.sis.storage.sql.SQLStore;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.collection.FrequencySortedSet;
import org.apache.sis.util.collection.TreeTable;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;

public class Database<G>
extends Syntax {
    public static final String WILDCARD = "%";
    protected final DataSource source;
    final Geometries<G> geomLibrary;
    private final boolean isByteSigned;
    private final FeatureNaming<Table> tablesByNames;
    private Table[] tables;
    private boolean isSpatial;
    private boolean hasGeometry;
    private boolean hasRaster;
    String catalogOfSpatialTables;
    String schemaOfSpatialTables;
    final boolean supportsCatalogs;
    final boolean supportsSchemas;
    private SelectionClauseWriter filterToSQL;
    public final StoreListeners listeners;
    final Cache<Integer, CoordinateReferenceSystem> cacheOfCRS;
    final WeakHashMap<CoordinateReferenceSystem, Integer> cacheOfSRID;

    protected Database(DataSource dataSource, DatabaseMetaData databaseMetaData, Geometries<G> geometries, StoreListeners storeListeners) throws SQLException {
        super(databaseMetaData, true);
        boolean bl = true;
        try (ResultSet resultSet = databaseMetaData.getTypeInfo();){
            while (resultSet.next() && (resultSet.getInt("DATA_TYPE") != -6 || !(bl = resultSet.getBoolean("UNSIGNED_ATTRIBUTE")))) {
            }
        }
        this.source = dataSource;
        this.isByteSigned = !bl;
        this.geomLibrary = geometries;
        this.listeners = storeListeners;
        this.cacheOfCRS = new Cache(7, 2L, false);
        this.cacheOfSRID = new WeakHashMap();
        this.tablesByNames = new FeatureNaming();
        this.supportsCatalogs = databaseMetaData.supportsCatalogsInDataManipulation();
        this.supportsSchemas = databaseMetaData.supportsSchemasInDataManipulation();
    }

    public static Database<?> create(SQLStore sQLStore, DataSource dataSource, Connection connection, GeometryLibrary geometryLibrary, GenericName[] genericNameArray, ResourceDefinition[] resourceDefinitionArray, SchemaModifier schemaModifier, StoreListeners storeListeners) throws Exception {
        Database database;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        Geometries<?> geometries = Geometries.implementation(geometryLibrary);
        switch (Dialect.guess((DatabaseMetaData)databaseMetaData)) {
            case POSTGRESQL: {
                database = new Postgres(dataSource, connection, databaseMetaData, geometries, storeListeners);
                break;
            }
            default: {
                database = new Database(dataSource, databaseMetaData, geometries, storeListeners);
            }
        }
        super.analyze(sQLStore, connection, genericNameArray, resourceDefinitionArray, schemaModifier);
        return database;
    }

    private void analyze(SQLStore sQLStore, Connection connection, GenericName[] genericNameArray, ResourceDefinition[] resourceDefinitionArray, SchemaModifier schemaModifier) throws Exception {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String[] stringArray = Database.getTableTypes(databaseMetaData);
        String string = "SPATIAL_REF_SYS";
        String string2 = "GEOMETRY_COLUMNS";
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            string = string.toLowerCase(Locale.US).intern();
            string2 = string2.toLowerCase(Locale.US).intern();
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(8);
        hashMap.put(string, Boolean.TRUE);
        hashMap.put(string2, Boolean.TRUE);
        this.addIgnoredTables(hashMap);
        this.isSpatial = this.hasTable(databaseMetaData, stringArray, hashMap);
        Analyzer analyzer = new Analyzer(this, connection, databaseMetaData, schemaModifier);
        LinkedHashSet<TableReference> linkedHashSet = new LinkedHashSet<TableReference>();
        for (GenericName genericName : genericNameArray) {
            String[] object = TableReference.splitName(genericName);
            try (ResultSet resultSet = databaseMetaData.getTables(object[2], object[1], object[0], stringArray);){
                while (resultSet.next()) {
                    String string3 = analyzer.getUniqueString(resultSet, "TABLE_NAME");
                    if (hashMap.containsKey(string3)) continue;
                    linkedHashSet.add(new TableReference(analyzer.getUniqueString(resultSet, "TABLE_CAT"), analyzer.getUniqueString(resultSet, "TABLE_SCHEM"), string3, analyzer.getUniqueString(resultSet, "REMARKS")));
                }
            }
        }
        ArrayList arrayList = new ArrayList(genericNameArray.length);
        for (TableReference tableReference : linkedHashSet) {
            arrayList.add(analyzer.table(tableReference, tableReference.getName(analyzer), null));
        }
        for (ResourceDefinition resourceDefinition : resourceDefinitionArray) {
            arrayList.add(analyzer.query(resourceDefinition.getName(), resourceDefinition.getQuery().get()));
        }
        for (Table table : analyzer.finish()) {
            this.tablesByNames.add((DataStore)sQLStore, table.featureType.getName(), (Object)table);
            this.hasGeometry |= table.hasGeometry;
            this.hasRaster |= table.hasRaster;
        }
        this.tables = arrayList.toArray(new Table[arrayList.size()]);
    }

    private static String[] getTableTypes(DatabaseMetaData databaseMetaData) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>(4);
        try (ResultSet resultSet = databaseMetaData.getTableTypes();){
            while (resultSet.next()) {
                String string = resultSet.getString("TABLE_TYPE");
                if (!"TABLE".equalsIgnoreCase(string) && !"VIEW".equalsIgnoreCase(string) && !"BASE TABLE".equalsIgnoreCase(string)) continue;
                hashSet.add(string);
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private boolean hasTable(DatabaseMetaData databaseMetaData, String[] stringArray, Map<String, Boolean> map) throws SQLException {
        FrequencySortedSet<Object> frequencySortedSet = new FrequencySortedSet<Object>(true);
        int n = 0;
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            String string = entry.getKey();
            boolean bl = false;
            try (ResultSet resultSet = databaseMetaData.getTables(null, null, string, stringArray);){
                while (resultSet.next()) {
                    bl = true;
                    frequencySortedSet.add(new AbstractMap.SimpleImmutableEntry<String, String>(resultSet.getString("TABLE_CAT"), resultSet.getString("TABLE_SCHEM")));
                }
            }
            if (!bl) continue;
            ++n;
        }
        if (n == 0) {
            return false;
        }
        AbstractMap.SimpleImmutableEntry simpleImmutableEntry = (AbstractMap.SimpleImmutableEntry)frequencySortedSet.first();
        if (frequencySortedSet.frequency(simpleImmutableEntry) == n) {
            this.catalogOfSpatialTables = (String)simpleImmutableEntry.getKey();
            this.schemaOfSpatialTables = (String)simpleImmutableEntry.getValue();
        }
        return true;
    }

    public final void listTables(DatabaseMetaData databaseMetaData, MetadataBuilder metadataBuilder) throws SQLException {
        for (Table table : this.tables) {
            metadataBuilder.addFeatureType(table.featureType, table.countRows(databaseMetaData, false, false));
        }
    }

    public final List<FeatureSet> tables() {
        return UnmodifiableArrayList.wrap(this.tables);
    }

    public final FeatureSet findTable(SQLStore sQLStore, String string) throws IllegalNameException {
        return (FeatureSet)this.tablesByNames.get((DataStore)sQLStore, string);
    }

    public final void appendFunctionCall(SQLBuilder sQLBuilder, String string) {
        String string2 = this.schemaOfSpatialTables;
        if (string2 != null && !string2.isEmpty()) {
            String string3 = this.catalogOfSpatialTables;
            if (string3 != null && !string3.isEmpty()) {
                sQLBuilder.appendIdentifier(string3).append('.');
            }
            sQLBuilder.appendIdentifier(string2).append('.');
        }
        sQLBuilder.append(string);
    }

    public final boolean isSpatial() {
        return this.isSpatial;
    }

    public final boolean hasGeometry() {
        return this.hasGeometry;
    }

    public final boolean hasRaster() {
        return this.hasRaster;
    }

    protected ValueGetter<?> getMapping(Column column) {
        if ("geometry".equalsIgnoreCase(column.typeName)) {
            return this.forGeometry(column);
        }
        switch (column.type) {
            case -7: 
            case 16: {
                return ValueGetter.AsBoolean.INSTANCE;
            }
            case -6: {
                if (this.isByteSigned) {
                    return ValueGetter.AsByte.INSTANCE;
                }
            }
            case 5: {
                return ValueGetter.AsShort.INSTANCE;
            }
            case 4: {
                return ValueGetter.AsInteger.INSTANCE;
            }
            case -5: {
                return ValueGetter.AsLong.INSTANCE;
            }
            case 7: {
                return ValueGetter.AsFloat.INSTANCE;
            }
            case 6: 
            case 8: {
                return ValueGetter.AsDouble.INSTANCE;
            }
            case 2: 
            case 3: {
                return ValueGetter.AsBigDecimal.INSTANCE;
            }
            case -1: 
            case 1: 
            case 12: {
                return ValueGetter.AsString.INSTANCE;
            }
            case 91: {
                return ValueGetter.AsDate.INSTANCE;
            }
            case 92: {
                return ValueGetter.AsLocalTime.INSTANCE;
            }
            case 93: {
                return ValueGetter.AsInstant.INSTANCE;
            }
            case 2013: {
                return ValueGetter.AsOffsetTime.INSTANCE;
            }
            case 2014: {
                return ValueGetter.AsOffsetDateTime.INSTANCE;
            }
            case 2004: {
                return ValueGetter.AsBytes.INSTANCE;
            }
            case 1111: 
            case 2000: {
                return this.getDefaultMapping();
            }
            case -4: 
            case -3: 
            case -2: {
                BinaryEncoding binaryEncoding = this.getBinaryEncoding(column);
                switch (binaryEncoding) {
                    case RAW: {
                        return ValueGetter.AsBytes.INSTANCE;
                    }
                    case HEXADECIMAL: {
                        return ValueGetter.AsBytes.HEXADECIMAL;
                    }
                }
                throw new AssertionError((Object)binaryEncoding);
            }
            case 2003: {
                int n = this.getArrayComponentType(column);
                ValueGetter<?> valueGetter = this.getMapping(new Column(n, column.typeName));
                if (valueGetter == ValueGetter.AsObject.INSTANCE) {
                    return ValueGetter.AsArray.INSTANCE;
                }
                return new ValueGetter.AsArray(valueGetter);
            }
        }
        return null;
    }

    protected int getArrayComponentType(Column column) {
        return 1111;
    }

    protected ValueGetter<Object> getDefaultMapping() {
        return ValueGetter.AsObject.INSTANCE;
    }

    protected BinaryEncoding getBinaryEncoding(Column column) {
        return BinaryEncoding.RAW;
    }

    protected Envelope getEstimatedExtent(TableReference tableReference, Column[] columnArray, boolean bl) throws SQLException {
        return null;
    }

    protected final ValueGetter<?> forGeometry(Column column) {
        GeometryType geometryType = column.getGeometryType().orElse(GeometryType.GEOMETRY);
        Class clazz = this.geomLibrary.getGeometryClass(geometryType).asSubclass(this.geomLibrary.rootClass);
        return new GeometryGetter(this.geomLibrary, clazz, column.getDefaultCRS().orElse(null), this.getBinaryEncoding(column));
    }

    protected InfoStatements createInfoStatements(Connection connection) {
        return new InfoStatements(this, connection);
    }

    protected void addIgnoredTables(Map<String, Boolean> map) {
    }

    protected SelectionClauseWriter getFilterToSQL() {
        return SelectionClauseWriter.DEFAULT;
    }

    final synchronized SelectionClauseWriter getFilterToSupportedSQL() {
        if (this.filterToSQL == null) {
            this.filterToSQL = this.getFilterToSQL().removeUnsupportedFunctions(this);
        }
        return this.filterToSQL;
    }

    protected final void log(LogRecord logRecord) {
        logRecord.setSourceClassName(SQLStore.class.getName());
        logRecord.setSourceMethodName("components");
        logRecord.setLoggerName("org.apache.sis.sql");
        this.listeners.warning(logRecord);
    }

    final void appendTo(TreeTable.Node node) {
        for (Table table : this.tables) {
            table.appendTo(node);
        }
    }

    public String toString() {
        return TableReference.toString((Object)this, node -> this.appendTo((TreeTable.Node)node));
    }
}

