/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.sql.feature.Analyzer;
import org.apache.sis.internal.sql.feature.ValueGetter;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class Column {
    public final String name;
    public final String label;
    String propertyName;
    public final int type;
    public final String typeName;
    private final int precision;
    public final boolean isNullable;
    private GeometryType geometryType;
    private CoordinateReferenceSystem defaultCRS;
    ValueGetter<?> valueGetter;

    Column(int n, String string) {
        this.propertyName = "element";
        this.label = "element";
        this.name = "element";
        this.type = n;
        this.typeName = string;
        this.precision = 0;
        this.isNullable = false;
    }

    Column(Analyzer analyzer, ResultSet resultSet, String string) throws SQLException {
        this.label = this.name = analyzer.getUniqueString(resultSet, "COLUMN_NAME");
        this.type = resultSet.getInt("DATA_TYPE");
        this.typeName = Column.localPart(resultSet.getString("TYPE_NAME"), string);
        this.precision = resultSet.getInt("COLUMN_SIZE");
        this.isNullable = Boolean.TRUE.equals(SQLUtilities.parseBoolean((String)resultSet.getString("IS_NULLABLE")));
        this.propertyName = this.label;
    }

    Column(ResultSetMetaData resultSetMetaData, int n, String string) throws SQLException {
        this.name = resultSetMetaData.getColumnName(n);
        this.label = resultSetMetaData.getColumnLabel(n);
        this.type = resultSetMetaData.getColumnType(n);
        this.typeName = Column.localPart(resultSetMetaData.getColumnTypeName(n), string);
        this.precision = resultSetMetaData.getPrecision(n);
        this.isNullable = resultSetMetaData.isNullable(n) == 1;
        this.propertyName = this.label;
    }

    private static String localPart(String string, String string2) throws SQLDataException {
        int n;
        int n2;
        if (string == null) {
            throw new SQLDataException(Errors.format((short)90, "TYPE_NAME"));
        }
        if (string2 != null && (n2 = string.lastIndexOf(string2)) >= 0 && (n = string.lastIndexOf(string2, n2 - 1)) >= 0 && n2 > (n += string2.length())) {
            string = string.substring(n, n2);
        }
        return string;
    }

    final void makeSpatial(Localized localized, GeometryType geometryType, CoordinateReferenceSystem coordinateReferenceSystem) throws DataStoreContentException {
        String string;
        if (this.geometryType != null && !this.geometryType.equals((Object)geometryType)) {
            string = "geometryType";
        } else if (this.defaultCRS != null && !this.defaultCRS.equals((Object)coordinateReferenceSystem)) {
            string = "defaultCRS";
        } else {
            this.geometryType = geometryType;
            this.defaultCRS = coordinateReferenceSystem;
            return;
        }
        throw new DataStoreContentException(Errors.getResources(localized.getLocale()).getString((short)164, string));
    }

    public final Optional<GeometryType> getGeometryType() {
        return Optional.ofNullable(this.geometryType);
    }

    public final Optional<CoordinateReferenceSystem> getDefaultCRS() {
        return Optional.ofNullable(this.defaultCRS);
    }

    final AttributeTypeBuilder<?> createAttribute(FeatureTypeBuilder featureTypeBuilder) {
        Class clazz = this.valueGetter.valueType;
        boolean bl = this.valueGetter instanceof ValueGetter.AsArray;
        if (bl) {
            clazz = ((ValueGetter.AsArray)this.valueGetter).cmget.valueType;
        }
        PropertyTypeBuilder propertyTypeBuilder = featureTypeBuilder.addAttribute(clazz).setName((CharSequence)this.propertyName);
        if (this.precision > 0 && this.precision != Integer.MAX_VALUE && CharSequence.class.isAssignableFrom(clazz)) {
            ((AttributeTypeBuilder)propertyTypeBuilder).setMaximalLength(this.precision);
        }
        if (bl) {
            ((AttributeTypeBuilder)propertyTypeBuilder).setMinimumOccurs(0);
            ((AttributeTypeBuilder)propertyTypeBuilder).setMaximumOccurs(Integer.MAX_VALUE);
        } else if (this.isNullable) {
            ((AttributeTypeBuilder)propertyTypeBuilder).setMinimumOccurs(0);
        }
        if (this.geometryType != null || this.defaultCRS != null) {
            ((AttributeTypeBuilder)propertyTypeBuilder).setCRS(this.defaultCRS);
        }
        return propertyTypeBuilder;
    }

    public String toString() {
        return Strings.toString(this.getClass(), new Object[]{"name", this.name, "propertyName", this.propertyName, "type", this.type, "typeName", this.typeName, "geometryType", this.geometryType, "precision", this.precision, "isNullable", this.isNullable});
    }
}

