/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.apache.sis.internal.sql.feature.Column;
import org.apache.sis.internal.sql.feature.Database;
import org.apache.sis.internal.sql.feature.InfoStatements;
import org.apache.sis.internal.sql.feature.QueryAnalyzer;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.sql.feature.SchemaModifier;
import org.apache.sis.internal.sql.feature.Table;
import org.apache.sis.internal.sql.feature.TableAnalyzer;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.internal.sql.feature.ValueGetter;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

final class Analyzer {
    final Database<?> database;
    final InfoStatements spatialInformation;
    final DatabaseMetaData metadata;
    final NameFactory nameFactory;
    private final Map<String, String> strings;
    final String escape;
    private final Map<GenericName, Table> tables;
    private final Set<ResourceInternationalString> warnings;
    private transient String catalog;
    private transient String schema;
    private transient NameSpace namespace;
    final SchemaModifier customizer;

    Analyzer(Database<?> database, Connection connection, DatabaseMetaData databaseMetaData, SchemaModifier schemaModifier) throws SQLException {
        this.database = database;
        this.tables = new HashMap<GenericName, Table>();
        this.strings = new HashMap<String, String>();
        this.warnings = new LinkedHashSet<ResourceInternationalString>();
        this.customizer = schemaModifier;
        this.metadata = databaseMetaData;
        this.escape = databaseMetaData.getSearchStringEscape();
        this.nameFactory = DefaultFactories.forBuildin(NameFactory.class);
        this.spatialInformation = database.isSpatial() ? database.createInfoStatements(connection) : null;
    }

    final String getUniqueString(ResultSet resultSet, String string) throws SQLException {
        String string2;
        String string3 = resultSet.getString(string);
        if (string3 != null && (string2 = this.strings.putIfAbsent(string3, string3)) != null) {
            string3 = string2;
        }
        return string3;
    }

    final NameSpace namespace(String string, String string2) {
        if (!Objects.equals(this.schema, string2) || !Objects.equals(this.catalog, string)) {
            if (string2 != null) {
                Object object = string == null ? this.nameFactory.createLocalName(null, (CharSequence)string2) : this.nameFactory.createGenericName(null, new CharSequence[]{string, string2});
                this.namespace = this.nameFactory.createNameSpace((GenericName)object, Collections.singletonMap("separator", "."));
            } else {
                this.namespace = null;
            }
            this.catalog = string;
            this.schema = string2;
        }
        return this.namespace;
    }

    public final Table table(TableReference tableReference, GenericName genericName, TableReference tableReference2) throws Exception {
        Table table = this.tables.get(genericName);
        if (table == null && !this.tables.containsKey(genericName)) {
            this.tables.put(genericName, null);
            table = new Table(this.database, new TableAnalyzer(this, tableReference, tableReference2), null);
            if (this.tables.put(genericName, table) != null) {
                throw new InternalDataStoreException(this.internalError());
            }
        }
        return table;
    }

    public final Table query(GenericName genericName, String string) throws Exception {
        Table table = new Table(this.database, new QueryAnalyzer(this, genericName, string, null), string);
        if (!this.tables.containsKey(genericName) && this.tables.put(genericName, table) == null) {
            return table;
        }
        throw new IllegalNameException(this.resources().getString((short)13, genericName));
    }

    final Resources resources() {
        return Resources.forLocale(this.database.listeners.getLocale());
    }

    final String internalError() {
        return this.resources().getString((short)6);
    }

    private void warning(short s, Object object) {
        this.warnings.add(Resources.formatInternational(s, object));
    }

    final Collection<Table> finish() throws DataStoreException {
        for (Table object : this.tables.values()) {
            object.setDeferredSearchTables(this, this.tables);
        }
        for (ResourceInternationalString resourceInternationalString : this.warnings) {
            this.database.log(resourceInternationalString.toLogRecord(Level.WARNING));
        }
        return this.tables.values();
    }

    final ValueGetter<?> setValueGetter(Column column) {
        ValueGetter<Object> valueGetter = this.database.getMapping(column);
        if (valueGetter == null) {
            valueGetter = this.database.getDefaultMapping();
            this.warning((short)4, column.typeName);
        }
        column.valueGetter = valueGetter;
        return valueGetter;
    }
}

