/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.landsat;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.internal.geotiff.SchemaModifier;
import org.apache.sis.internal.storage.GridResourceWrapper;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.apache.sis.metadata.iso.content.DefaultSampleDimension;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.storage.landsat.BandName;
import org.apache.sis.storage.landsat.LandsatStore;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.content.CoverageContentType;
import org.opengis.metadata.identification.Identification;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;

final class Band
extends GridResourceWrapper
implements SchemaModifier {
    private final LandsatStore parent;
    final BandName band;
    LocalName identifier;
    String filename;
    final DefaultSampleDimension sampleDimension;

    Band(LandsatStore landsatStore, BandName bandName) {
        this.parent = landsatStore;
        this.band = bandName;
        if (bandName.wavelength != 0) {
            DefaultBand defaultBand = new DefaultBand();
            defaultBand.setPeakResponse(Double.valueOf(bandName.wavelength));
            defaultBand.setBoundUnits(Units.NANOMETRE);
            this.sampleDimension = defaultBand;
        } else {
            this.sampleDimension = new DefaultSampleDimension();
        }
        this.sampleDimension.setDescription(bandName.title);
    }

    @Override
    protected final Object getSynchronizationLock() {
        return this.parent;
    }

    @Override
    protected GridCoverageResource createSource() throws DataStoreException {
        Path path = this.parent.directory != null ? this.parent.directory.resolve(this.filename) : Paths.get(this.filename, new String[0]);
        StorageConnector storageConnector = new StorageConnector(path);
        storageConnector.setOption(SchemaModifier.OPTION, this);
        return (GridCoverageResource)new GeoTiffStore(this.parent, this.parent.getProvider(), storageConnector, true).components().get(0);
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.of(this.identifier);
    }

    @Override
    public GenericName customize(int n, GenericName genericName) {
        return n == 0 ? this.identifier : genericName;
    }

    @Override
    public Metadata customize(int n, DefaultMetadata defaultMetadata) {
        if (n == 0) {
            DefaultCitation defaultCitation;
            Identification identification2;
            for (Identification identification2 : defaultMetadata.getIdentificationInfo()) {
                defaultCitation = (DefaultCitation)identification2.getCitation();
                if (defaultCitation == null) continue;
                defaultCitation.setTitle(this.band.title);
                break;
            }
            DefaultImageDescription defaultImageDescription = (DefaultImageDescription)CollectionsExt.first((Iterable)defaultMetadata.getContentInfo());
            identification2 = (DefaultAttributeGroup)CollectionsExt.first((Iterable)defaultImageDescription.getAttributeGroups());
            defaultCitation = (DefaultSampleDimension)CollectionsExt.first((Iterable)identification2.getAttributes());
            identification2.getContentTypes().add(CoverageContentType.PHYSICAL_MEASUREMENT);
            defaultCitation.setDescription(this.sampleDimension.getDescription());
            defaultCitation.setMinValue(this.sampleDimension.getMinValue());
            defaultCitation.setMaxValue(this.sampleDimension.getMaxValue());
            defaultCitation.setScaleFactor(this.sampleDimension.getScaleFactor());
            defaultCitation.setOffset(this.sampleDimension.getOffset());
            defaultCitation.setUnits(this.sampleDimension.getUnits());
            if (this.sampleDimension instanceof DefaultBand) {
                DefaultBand defaultBand = (DefaultBand)this.sampleDimension;
                DefaultBand defaultBand2 = (DefaultBand)defaultCitation;
                defaultBand2.setPeakResponse(defaultBand.getPeakResponse());
                defaultBand2.setBoundUnits(defaultBand.getBoundUnits());
            }
        }
        return defaultMetadata;
    }

    @Override
    public SampleDimension customize(int n, int n2, NumberRange<?> numberRange, SampleDimension.Builder builder) {
        if ((n | n2) == 0) {
            builder.setName((GenericName)this.identifier);
            if (numberRange != null) {
                Number number = (Number)((Object)numberRange.getMinValue());
                Number number2 = (Number)((Object)numberRange.getMaxValue());
                Double d = this.sampleDimension.getScaleFactor();
                Double d2 = this.sampleDimension.getOffset();
                if (number != null && number2 != null && d != null && d2 != null) {
                    int n3 = number.intValue();
                    if (n3 >= 0) {
                        builder.addQualitative((CharSequence)Vocabulary.formatInternational((short)140), 0);
                        if (n3 == 0) {
                            n3 = 1;
                        }
                    }
                    builder.addQuantitative((CharSequence)this.band.group.measurement, n3, number2.intValue(), d, d2, this.sampleDimension.getUnits());
                }
            }
        }
        return builder.build();
    }

    @Override
    public boolean isElectromagneticMeasurement(int n) {
        return n == 0 && this.band.wavelength != 0;
    }
}

