/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.Console;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.console.HelpCommand;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.internal.util.X364;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Locales;
import org.apache.sis.util.resources.Errors;

abstract class CommandRunner {
    static final String TEST = "TEST";
    static CommandRunner instance;
    protected final String commandName;
    private final EnumSet<Option> validOptions;
    protected final EnumMap<Option, String> options;
    protected final Locale locale;
    protected final TimeZone timezone;
    protected final Charset encoding;
    protected final boolean colors;
    protected final boolean debug;
    protected final PrintWriter out;
    protected final PrintWriter err;
    final StringBuffer outputBuffer;
    protected final List<String> files;

    CommandRunner(CommandRunner commandRunner) {
        this.commandName = commandRunner.commandName;
        this.validOptions = commandRunner.validOptions;
        this.options = commandRunner.options;
        this.locale = commandRunner.locale;
        this.timezone = commandRunner.timezone;
        this.encoding = commandRunner.encoding;
        this.colors = commandRunner.colors;
        this.debug = commandRunner.debug;
        this.out = commandRunner.out;
        this.err = commandRunner.err;
        this.outputBuffer = commandRunner.outputBuffer;
        this.files = commandRunner.files;
    }

    protected CommandRunner(int n, String[] stringArray, EnumSet<Option> enumSet) throws InvalidOptionException {
        boolean bl;
        Object object;
        Object object2;
        String string;
        this.commandName = n >= 0 ? stringArray[n] : null;
        this.validOptions = enumSet;
        this.options = new EnumMap(Option.class);
        this.files = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == n) continue;
            string = stringArray[i];
            if (string.startsWith("--")) {
                object2 = string.substring("--".length());
                Option option = Option.forLabel((String)object2);
                if (!enumSet.contains((Object)option)) {
                    throw new InvalidOptionException(Errors.format((short)148, (Object)object2), (String)object2);
                }
                object = null;
                if (option.hasValue) {
                    if (++i >= stringArray.length) {
                        throw new InvalidOptionException(Errors.format((short)88, (Object)object2), (String)object2);
                    }
                    object = stringArray[i];
                }
                if (this.options.containsKey((Object)option)) {
                    throw new InvalidOptionException(Errors.format((short)26, (Object)object2), (String)object2);
                }
                this.options.put(option, (String)object);
                continue;
            }
            this.files.add(string);
        }
        Option option = null;
        string = null;
        try {
            option = Option.DEBUG;
            this.debug = this.options.containsKey((Object)option);
            option = Option.LOCALE;
            string = this.options.get((Object)option);
            this.locale = string != null ? Locales.parse((String)string) : Locale.getDefault(Locale.Category.DISPLAY);
            option = Option.TIMEZONE;
            string = this.options.get((Object)option);
            this.timezone = string != null ? TimeZone.getTimeZone(string) : TimeZone.getDefault();
            option = Option.ENCODING;
            string = this.options.get((Object)option);
            bl = string != null;
            this.encoding = bl ? Charset.forName(string) : Charset.defaultCharset();
            option = Option.COLORS;
            string = this.options.get((Object)option);
            object2 = System.console();
            this.colors = string != null ? Option.COLORS.parseBoolean(string) : object2 != null && X364.isAnsiSupported();
        }
        catch (RuntimeException runtimeException) {
            String string2 = option.label();
            throw new InvalidOptionException(Errors.format((short)56, (Object)string2, (Object)string), string2);
        }
        if (TEST.equals(this.commandName)) {
            object = new StringWriter();
            this.outputBuffer = ((StringWriter)object).getBuffer();
            this.err = this.out = new PrintWriter((Writer)object);
        } else {
            this.outputBuffer = null;
            PrintWriter printWriter = this.err = object2 != null ? ((Console)object2).writer() : new PrintWriter(System.err, true);
            this.out = !bl && object2 != null ? ((Console)object2).writer() : (bl ? new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, this.encoding), true) : new PrintWriter(System.out, true));
        }
    }

    final boolean hasContradictoryOptions(Option ... optionArray) {
        int n = 0;
        while (n < optionArray.length) {
            Option option = optionArray[n++];
            Option option2 = optionArray[n++];
            if (!this.options.containsKey((Object)option) || !this.options.containsKey((Object)option2)) continue;
            this.err.println(Errors.format((short)91, (Object)option.label(), (Object)option2.label()));
            return true;
        }
        return false;
    }

    final boolean hasUnexpectedFileCount(int n, int n2) {
        short s;
        int n3;
        int n4 = this.files.size();
        if (n4 < n) {
            n3 = n;
            s = 127;
        } else if (n4 > n2) {
            n3 = n2;
            s = 129;
        } else {
            return false;
        }
        this.err.println(Errors.format((short)s, (Object)n3, (Object)n4));
        return true;
    }

    final boolean useStandardInput() {
        return this.files.isEmpty() && System.console() == null;
    }

    final void canNotOpen(int n, Exception exception) {
        this.error(Errors.format((short)9, (Object)this.files.get(n)), exception);
    }

    final void error(String string, Exception exception) {
        this.out.flush();
        if (this.debug) {
            exception.printStackTrace(this.err);
        } else {
            this.err.println(Exceptions.formatChainedMessages((Locale)this.locale, (String)string, (Throwable)exception));
        }
    }

    protected void help(String string) throws IOException {
        new HelpCommand(this).help(false, new String[]{string}, this.validOptions);
    }

    public abstract int run() throws Exception;
}

