package local.test;

import java.awt.image.RenderedImage;
import java.util.Random;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.opengis.referencing.operation.MathTransform;


final class Test {
    private static RenderedImage source, target;

    public static void main(String[] args) throws Exception {
        System.setErr(System.out);
        MathTransform tr = new DefaultMathTransformFactory().createFromWKT("Inverse_MT[\n" +
                "  Param_MT[\"Hotine Oblique Mercator (variant B)\",\n" +
                "    Parameter[\"semi_major\", 6378137.0, Unit[\"metre\", 1]],\n" +
                "    Parameter[\"semi_minor\", 6356752.314245179, Unit[\"metre\", 1]],\n" +
                "    Parameter[\"Latitude of projection centre\", 89.8, Unit[\"degree\", 0.017453292519943295]],\n" +
                "    Parameter[\"Longitude of projection centre\", 179.8, Unit[\"degree\", 0.017453292519943295]],\n" +
                "    Parameter[\"Azimuth of initial line\", -174, Unit[\"degree\", 0.017453292519943295]]]]");

        System.out.println(tr.inverse().transform(new DirectPosition2D(180, 90), null));
        //if (true) return;

        final Random r = new Random();
        final double x = 0.004715980030596256;
        final double y = 22338.795490272343;
        final DirectPosition2D p = new DirectPosition2D();
        DirectPosition2D t = null;
        int count = 0;
        for (int i=0; i<1000000; i++) {
            p.x = x + r.nextDouble() * 10;
            p.y = y + r.nextDouble() * 10;
            t = (DirectPosition2D) tr.transform(p, t);
            if (Double.isNaN(t.x) || Double.isNaN(t.y)) {
                System.out.println(p + "  " + t + "   " + Math.hypot(p.x - x, p.y - y));
                if (++count >= 100) break;
            }
        }
    }
}
