/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.io;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import org.apache.sis.gui.Widget;
import org.apache.sis.internal.gui.FixedHeaderColumnSize;
import org.apache.sis.internal.gui.ImmutableObjectProperty;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.io.FileAccessItem;
import org.apache.sis.internal.storage.io.ChannelFactory;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.resources.Vocabulary;

public final class FileAccessView
extends Widget
implements UnaryOperator<ChannelFactory> {
    private final TableView<FileAccessItem> table;

    public FileAccessView(Resources resources, Vocabulary vocabulary) {
        TableColumn filenameColumn = new TableColumn(vocabulary.getString((short)82));
        TableColumn accessColumn = new TableColumn(resources.getString((short)65));
        accessColumn.setSortable(false);
        accessColumn.setMinWidth(120.0);
        filenameColumn.setMinWidth(80.0);
        filenameColumn.setPrefWidth(200.0);
        filenameColumn.setCellValueFactory(cell -> new ImmutableObjectProperty<String>(((FileAccessItem)cell.getValue()).filename));
        accessColumn.setCellValueFactory(cell -> new ImmutableObjectProperty<Pane>(((FileAccessItem)cell.getValue()).accessView));
        this.table = new TableView();
        this.table.setColumnResizePolicy(FixedHeaderColumnSize.INSTANCE);
        this.table.getColumns().setAll((Object[])new TableColumn[]{filenameColumn, accessColumn});
    }

    @Override
    public Region getView() {
        return this.table;
    }

    @Override
    public ChannelFactory apply(final ChannelFactory factory) {
        return new ChannelFactory(factory.suggestDirectBuffer){

            public boolean isCoupled() {
                return factory.isCoupled();
            }

            public boolean canOpen() {
                return factory.canOpen();
            }

            public ReadableByteChannel readable(String filename, StoreListeners listeners) throws DataStoreException, IOException {
                ReadableByteChannel channel = factory.readable(filename, listeners);
                if (channel instanceof SeekableByteChannel) {
                    FileAccessItem item = new FileAccessItem((List<FileAccessItem>)FileAccessView.this.table.getItems(), filename);
                    Platform.runLater(() -> item.owner.add(item));
                    FileAccessItem fileAccessItem = item;
                    Objects.requireNonNull(fileAccessItem);
                    return fileAccessItem.new FileAccessItem.Observer((SeekableByteChannel)channel);
                }
                return channel;
            }

            public WritableByteChannel writable(String filename, StoreListeners listeners) throws DataStoreException, IOException {
                return factory.writable(filename, listeners);
            }
        };
    }
}

