/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.control;

import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import org.apache.sis.internal.gui.ImmutableObjectProperty;
import org.apache.sis.internal.gui.control.ColorCell;
import org.apache.sis.internal.gui.control.ColorRamp;

public abstract class ColorColumnHandler<S>
implements Callback<TableColumn.CellDataFeatures<S, ColorRamp>, ObservableValue<ColorRamp>> {
    protected ColorColumnHandler() {
    }

    protected abstract ColorRamp.Type applyColors(S var1, ColorRamp var2);

    protected abstract int[] getARGB(S var1);

    protected ObservableValue<ColorRamp> getObservableValue(S row) {
        int[] ARGB = this.getARGB(row);
        if (ARGB != null) {
            return new ImmutableObjectProperty<ColorRamp>(new ColorRamp(ARGB));
        }
        return null;
    }

    public final ObservableValue<ColorRamp> call(TableColumn.CellDataFeatures<S, ColorRamp> cell) {
        Object value = cell.getValue();
        return value != null ? this.getObservableValue(value) : null;
    }

    protected final void addColumnTo(TableView<S> table, String header) {
        TableColumn colors = new TableColumn(header);
        colors.setCellFactory(column -> new ColorCell(this));
        colors.setCellValueFactory((Callback)this);
        colors.setSortable(false);
        colors.setId("colors");
        table.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            TableColumn column;
            TablePosition focused;
            if (event.getCode() == KeyCode.ENTER && (focused = table.getFocusModel().getFocusedCell()) != null && ((column = focused.getTableColumn()) == null || column == colors)) {
                event.consume();
                TablePosition editing = table.getEditingCell();
                int row = (editing != null ? editing : focused).getRow();
                if (row >= 0) {
                    table.edit(row, colors);
                }
            }
        });
        table.getColumns().add((Object)colors);
        table.setEditable(true);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
    }
}

