/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.control;

import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.control.ColorColumnHandler;
import org.apache.sis.internal.gui.control.ColorRamp;

final class ColorCell<S>
extends TableCell<S, ColorRamp>
implements EventHandler<ActionEvent> {
    private static final double WIDTH_ADJUST = -9.0;
    private static final double HEIGHT = 16.0;
    private final ColorColumnHandler<S> handler;
    private ColorRamp.Type type;
    private ColorPicker colorPicker;
    private ComboBox<ColorRamp> colorRampChooser;
    private Rectangle colorView;

    ColorCell(ColorColumnHandler<S> handler) {
        this.handler = handler;
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.setOnMouseClicked(ColorCell::mouseClicked);
    }

    private static void mouseClicked(MouseEvent event) {
        if (event.getButton() == MouseButton.PRIMARY && ((ColorCell)((Object)event.getSource())).requestEdit()) {
            event.consume();
        }
    }

    private boolean controlNotFocused() {
        return !(this.colorPicker != null && this.colorPicker.isFocused() || this.colorRampChooser != null && this.colorRampChooser.isFocused());
    }

    private ComboBoxBase<?> showControlButton() {
        ComboBox<ColorRamp> control;
        Node current = this.getGraphic();
        if (current instanceof ComboBoxBase) {
            return (ComboBoxBase)current;
        }
        assert (this.controlNotFocused());
        if (this.type == null) {
            control = null;
        } else {
            boolean isNewControl;
            switch (this.type) {
                default: {
                    throw new AssertionError((Object)this.type);
                }
                case SOLID: {
                    isNewControl = this.colorPicker == null;
                    if (isNewControl) {
                        this.colorPicker = new ColorPicker();
                        this.colorPicker.setMaxWidth(Double.MAX_VALUE);
                        this.updateColorPicker((ColorRamp)this.getItem());
                    }
                    control = this.colorPicker;
                    break;
                }
                case GRADIENT: {
                    isNewControl = this.colorRampChooser == null;
                    if (isNewControl) {
                        this.colorRampChooser = new ComboBox();
                        this.colorRampChooser.setEditable(false);
                        this.colorRampChooser.setMaxWidth(Double.MAX_VALUE);
                        this.colorRampChooser.setCellFactory(column -> new RampChoice());
                        this.colorRampChooser.getItems().setAll((Object[])new ColorRamp[]{ColorRamp.GRAYSCALE, ColorRamp.BELL});
                        this.updateColorRampChooser((ColorRamp)this.getItem());
                    }
                    control = this.colorRampChooser;
                }
            }
            if (isNewControl) {
                control.setOnAction((EventHandler)this);
            }
        }
        this.setGraphic((Node)control);
        return control;
    }

    private Rectangle createRectangle(double adjust) {
        Rectangle gr = new Rectangle();
        gr.setHeight(16.0);
        gr.widthProperty().bind((ObservableValue)this.widthProperty().add(adjust));
        return gr;
    }

    private void updateColorPicker(ColorRamp item) {
        this.colorPicker.setValue((Object)(item != null ? item.color() : null));
    }

    private void updateColorRampChooser(ColorRamp item) {
        if (item != null) {
            ObservableList items = this.colorRampChooser.getItems();
            int i = items.indexOf((Object)item);
            if (i < 0) {
                i = items.size();
                items.add((Object)item);
            }
            this.colorRampChooser.getSelectionModel().select(i);
        } else {
            this.colorRampChooser.getSelectionModel().clearSelection();
        }
    }

    protected final void updateItem(ColorRamp colors, boolean empty) {
        Object item;
        TableRow row;
        super.updateItem((Object)colors, empty);
        this.type = null;
        if (!empty && (row = this.getTableRow()) != null && (item = row.getItem()) != null) {
            this.type = this.handler.applyColors(item, colors);
        }
        if (this.type != null) {
            switch (this.type) {
                default: {
                    throw new AssertionError((Object)this.type);
                }
                case SOLID: {
                    if (this.colorPicker == null) break;
                    this.updateColorPicker(colors);
                    break;
                }
                case GRADIENT: {
                    if (this.colorRampChooser == null) break;
                    this.updateColorRampChooser(colors);
                }
            }
        }
        if (!(this.getGraphic() instanceof Control)) {
            this.setColorItem(colors);
        }
    }

    private void setColorItem(ColorRamp colors) {
        Paint paint;
        assert (this.controlNotFocused());
        Rectangle view = null;
        if (colors != null && (paint = colors.paint()) != null) {
            if (this.colorView == null) {
                this.colorView = this.createRectangle(-9.0);
            }
            view = this.colorView;
            view.setFill(paint);
        }
        this.setGraphic((Node)view);
    }

    private void hideControlButton() {
        Node control = this.getGraphic();
        if (control instanceof Control) {
            if (control.isFocused()) {
                this.getTableView().requestFocus();
            }
            this.setColorItem((ColorRamp)this.getItem());
        }
    }

    private boolean requestEdit() {
        if (this.isEditing()) {
            ColorCell.popup(this.showControlButton());
            return false;
        }
        int row = this.getTableRow().getIndex();
        TableView table = this.getTableView();
        table.getSelectionModel().select(row);
        table.edit(row, this.getTableColumn());
        return true;
    }

    public final void startEdit() {
        ComboBoxBase<?> control = this.showControlButton();
        super.startEdit();
        ColorCell.popup(control);
    }

    private static void popup(ComboBoxBase<?> control) {
        if (control != null) {
            control.requestFocus();
            control.show();
        }
    }

    public final void cancelEdit() {
        super.cancelEdit();
        this.hideControlButton();
    }

    public final void handle(ActionEvent event) {
        if (this.isEditing()) {
            Object value = ((ComboBoxBase)event.getSource()).getValue();
            ColorRamp colors = value instanceof Color ? new ColorRamp(GUIUtilities.toARGB((Color)value)) : (ColorRamp)value;
            this.commitEdit(colors);
        }
        this.hideControlButton();
    }

    private final class RampChoice
    extends ListCell<ColorRamp> {
        RampChoice() {
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.setMaxWidth(Double.POSITIVE_INFINITY);
        }

        protected void updateItem(ColorRamp colors, boolean empty) {
            super.updateItem((Object)colors, empty);
            if (colors == null) {
                this.setGraphic(null);
            } else {
                Rectangle r = (Rectangle)this.getGraphic();
                if (r == null) {
                    r = ColorCell.this.createRectangle(-40.0);
                    this.setGraphic((Node)r);
                }
                r.setFill(colors.paint());
            }
        }
    }
}

