/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Logger;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;

public final class Styles
extends Static {
    public static final String STYLESHEET = "org/apache/sis/gui/pseudo-classes.css";
    public static final int SCROLLBAR_WIDTH = 20;
    public static final int CHECKBOX_WIDTH = 40;
    public static final int ROW_HEIGHT = 30;
    public static final Color NORMAL_TEXT = Color.BLACK;
    public static final Color SELECTED_TEXT = Color.WHITE;
    public static final Color LOADING_TEXT = Color.BLUE;
    public static final Color CODE_TEXT = Color.LIGHTSLATEGREY;
    public static final Color OUTDATED_TEXT = Color.GRAY;
    public static final Color ERROR_TEXT = Color.RED;
    public static final Color EXPANDED_ROW = Color.GAINSBORO;
    public static final Color GROUP_BORDER = Color.SILVER;
    public static final Color SELECTION_BACKGROUND = Color.LIGHTBLUE;
    public static final PseudoClass ERROR = PseudoClass.getPseudoClass((String)"error");
    public static final String ERROR_DETAILS_ICON = "\u2139\ufe0f";
    public static final String WARNING_ICON = "\u26a0\ufe0f";
    public static final Insets FORM_INSETS = new Insets(12.0);

    private Styles() {
    }

    public static Image loadIcon(Class<?> caller, String method, String file) {
        Exception error;
        Image image;
        try (InputStream in = caller.getResourceAsStream(file);){
            image = new Image(in);
            error = image.getException();
        }
        catch (IOException e) {
            image = null;
            error = e;
        }
        if (error != null) {
            Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.gui"), caller, (String)method, (Throwable)error);
        }
        return image;
    }

    public static GridPane createControlGrid(int row, Label ... controls) {
        GridPane gp = new GridPane();
        ColumnConstraints labelColumn = new ColumnConstraints();
        ColumnConstraints controlColumn = new ColumnConstraints();
        labelColumn.setHgrow(Priority.NEVER);
        controlColumn.setHgrow(Priority.ALWAYS);
        gp.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{labelColumn, controlColumn});
        gp.setPadding(FORM_INSETS);
        gp.setVgap(9.0);
        gp.setHgap(9.0);
        for (Label label : controls) {
            if (label == null) continue;
            Node control = label.getLabelFor();
            GridPane.setConstraints((Node)label, (int)0, (int)row);
            GridPane.setConstraints((Node)control, (int)1, (int)row);
            gp.getChildren().addAll((Object[])new Node[]{label, control});
            label.setMinWidth(Double.NEGATIVE_INFINITY);
            ++row;
        }
        return gp;
    }

    public static void setAllRowToSameHeight(GridPane gp) {
        Object[] constraints = new RowConstraints[gp.getRowCount()];
        RowConstraints c = new RowConstraints();
        c.setPercentHeight(100.0 / (double)constraints.length);
        Arrays.fill(constraints, c);
        gp.getRowConstraints().setAll(constraints);
    }
}

