/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.StringJoiner;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.metadata.IdentificationInfo;
import org.apache.sis.gui.metadata.RepresentationInfo;
import org.apache.sis.gui.metadata.Section;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

@DefaultProperty(value="metadata")
public class MetadataSummary
extends Widget {
    private final ScrollPane content;
    final Vocabulary vocabulary = Vocabulary.getResources((Locale)null);
    private NumberFormat numberFormat;
    private DateFormat dateFormat;
    private static Image worldMap;
    private static boolean worldMapLoaded;
    private Getter getter;
    public final ObjectProperty<Metadata> metadataProperty;
    private ExceptionReporter error;
    private final TitledPane[] information = new TitledPane[]{new TitledPane(this.vocabulary.getString((short)173), (Node)new IdentificationInfo(this)), new TitledPane(this.vocabulary.getString((short)184), (Node)new RepresentationInfo(this))};

    public MetadataSummary() {
        this.content = new ScrollPane((Node)new VBox());
        this.content.setFitToWidth(true);
        this.metadataProperty = new SimpleObjectProperty((Object)this, "metadata");
        this.metadataProperty.addListener(MetadataSummary::applyChange);
    }

    private IdentificationInfo getIdentificationInfo() {
        return (IdentificationInfo)this.information[0].getContent();
    }

    private ObservableList<Node> getChildren() {
        return ((VBox)this.content.getContent()).getChildren();
    }

    @Override
    public final Region getView() {
        return this.content;
    }

    final NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getInstance();
        }
        return this.numberFormat;
    }

    final DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateTimeInstance(1, 2);
        }
        return this.dateFormat;
    }

    public void setMetadata(Resource resource) {
        assert (Platform.isFxApplicationThread());
        if (this.getter != null) {
            this.getter.cancel(false);
            this.getter = null;
        }
        if (resource == null) {
            this.setMetadata((Metadata)null);
        } else {
            this.getter = new Getter(resource);
            BackgroundThreads.execute((Runnable)((Object)this.getter));
        }
    }

    public final void setMetadata(Metadata metadata) {
        assert (Platform.isFxApplicationThread());
        this.metadataProperty.set((Object)metadata);
    }

    public final Metadata getMetadata() {
        return (Metadata)this.metadataProperty.get();
    }

    public final void setError(Throwable exception) {
        ArgumentChecks.ensureNonNull((String)"exception", (Object)exception);
        this.setMetadata((Metadata)null);
        if (this.error == null) {
            this.error = new ExceptionReporter(exception);
        } else {
            this.error.setException(exception);
        }
        ObservableList<Node> children = this.getChildren();
        children.setAll((Object[])new Node[]{this.error.getView()});
    }

    private static void applyChange(ObservableValue<? extends Metadata> property, Metadata oldValue, Metadata metadata) {
        MetadataSummary s = (MetadataSummary)((SimpleObjectProperty)property).getBean();
        s.getter = null;
        s.error = null;
        if (metadata != oldValue) {
            ObservableList<Node> children = s.getChildren();
            if (!children.isEmpty() && !(children.get(0) instanceof Section)) {
                children.clear();
            }
            int i = 0;
            for (TitledPane pane : s.information) {
                boolean isPresent;
                Section info = (Section)pane.getContent();
                info.setInformation(metadata);
                boolean isEmpty = info.isEmpty();
                boolean bl = isPresent = i < children.size() && children.get(i) == pane;
                if (isEmpty == isPresent) {
                    if (isEmpty) {
                        children.remove(i);
                    } else {
                        children.add(i, (Object)pane);
                    }
                }
                if (isEmpty) continue;
                ++i;
            }
        }
    }

    static Image getWorldMap() {
        assert (Platform.isFxApplicationThread());
        if (!worldMapLoaded) {
            worldMapLoaded = true;
            worldMap = Styles.loadIcon(MetadataSummary.class, "getWorldMap", "WorldMap360x180.png");
        }
        return worldMap;
    }

    final String string(Collection<? extends CodeList<?>> codes) {
        StringJoiner buffer = new StringJoiner(", ");
        for (CodeList<?> c : codes) {
            String text = this.string(Types.getCodeTitle(c));
            if (text == null) continue;
            buffer.add(text);
        }
        return buffer.length() != 0 ? buffer.toString() : null;
    }

    final String string(InternationalString i18n) {
        return i18n != null ? Strings.trimOrNull((String)i18n.toString(this.vocabulary.getLocale())) : null;
    }

    private final class Getter
    extends Task<Metadata> {
        private final Resource resource;

        Getter(Resource resource) {
            this.resource = resource;
        }

        protected Metadata call() throws DataStoreException {
            return this.resource.getMetadata();
        }

        protected void succeeded() {
            if (MetadataSummary.this.getter == this) {
                try {
                    MetadataSummary.this.setMetadata((Metadata)this.getValue());
                    if (this.resource instanceof Aggregate) {
                        MetadataSummary.this.getIdentificationInfo().completeMissingGeographicBounds((Aggregate)this.resource);
                    }
                }
                finally {
                    MetadataSummary.this.getter = null;
                }
            }
        }

        protected void failed() {
            if (MetadataSummary.this.getter == this) {
                MetadataSummary.this.getter = null;
                MetadataSummary.this.setError(this.getException());
            }
        }
    }
}

