/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import javafx.concurrent.Task;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.gui.metadata.Section;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.CharSequences;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicDescription;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;

final class IdentificationInfo
extends Section<Identification> {
    private static final double MAP_WIDTH = 360.0;
    private static final double MAP_HEIGHT = 180.0;
    private static final double MIN_RECT_SIZE = 6.0;
    private final Label title = new Label();
    private Canvas extentOnMap;
    private boolean isWorld;
    private boolean mapWasVisible;
    private Task<?> aggregateWalker;

    IdentificationInfo(MetadataSummary owner) {
        super(owner);
        this.title.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)15.0));
        this.add((Node)this.title, 0, 0, 2, 1);
        this.extentOnMap = new Canvas();
        this.add((Node)this.extentOnMap, 0, 0, 2, 1);
        IdentificationInfo.setHalignment((Node)this.extentOnMap, (HPos)HPos.CENTER);
        this.finished();
    }

    private void clearWorldMap() {
        if (!this.isWorldMapEmpty()) {
            int p = this.linesStartIndex() - 1;
            assert (this.getChildren().get(p) == this.extentOnMap);
            this.extentOnMap = new Canvas();
            this.getChildren().set(p, (Object)this.extentOnMap);
            IdentificationInfo.setColumnSpan((Node)this.extentOnMap, (Integer)2);
            IdentificationInfo.setHalignment((Node)this.extentOnMap, (HPos)HPos.CENTER);
        }
    }

    private boolean isWorldMapEmpty() {
        return this.extentOnMap.getWidth() == 0.0 && this.extentOnMap.getHeight() == 0.0;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isWorldMapEmpty();
    }

    final void completeMissingGeographicBounds(final Aggregate resource) {
        if (!this.isWorld && this.isWorldMapEmpty() && !super.isEmpty() && this.numPages() == 1) {
            if (this.mapWasVisible) {
                this.drawMapBackground();
            }
            this.aggregateWalker = new Task<Set<GeographicBoundingBox>>(){

                protected Set<GeographicBoundingBox> call() throws DataStoreException {
                    LinkedHashSet<GeographicBoundingBox> boxes = new LinkedHashSet<GeographicBoundingBox>();
                    for (Resource child : resource.components()) {
                        Metadata metadata = child.getMetadata();
                        if (this.isCancelled()) break;
                        if (metadata == null) continue;
                        for (Identification id : CollectionsExt.nonNull((Collection)metadata.getIdentificationInfo())) {
                            if (!(id instanceof DataIdentification)) continue;
                            for (Extent extent : ((DataIdentification)id).getExtents()) {
                                GeographicBoundingBox b = Extents.getGeographicBoundingBox((Extent)extent);
                                if (b == null) continue;
                                boxes.add(b);
                            }
                        }
                    }
                    return boxes;
                }

                protected void succeeded() {
                    IdentificationInfo.this.aggregateWalker = null;
                    IdentificationInfo.this.drawOnMap((Set)this.getValue());
                }

                protected void failed() {
                    IdentificationInfo.this.aggregateWalker = null;
                    IdentificationInfo.this.owner.setError(this.getException());
                }
            };
            BackgroundThreads.execute((Runnable)this.aggregateWalker);
        }
    }

    @Override
    void setInformation(Metadata metadata) {
        Collection info;
        if (this.aggregateWalker != null) {
            this.aggregateWalker.cancel(false);
            this.aggregateWalker = null;
        }
        if (metadata == null) {
            this.clearWorldMap();
            info = null;
        } else {
            info = metadata.getIdentificationInfo();
        }
        this.setInformation(CollectionsExt.nonNull((Collection)info), Identification[]::new);
    }

    @Override
    void buildContent(Identification info) {
        DataIdentification dataInfo;
        this.mapWasVisible = !this.isWorldMapEmpty();
        this.isWorld = false;
        this.clearWorldMap();
        String text = null;
        Citation citation = info.getCitation();
        if (citation != null && (text = this.owner.string(citation.getTitle())) == null) {
            text = Citations.getIdentifier((Citation)citation);
        }
        if (text == null) {
            text = this.owner.vocabulary.getString((short)210);
        } else if (CharSequences.isUnicodeIdentifier(text)) {
            text = CharSequences.camelCaseToSentence((CharSequence)text).toString();
        }
        this.title.setText(text);
        if (citation != null) {
            StringJoiner buffer = new StringJoiner(", ");
            for (Identifier id : citation.getIdentifiers()) {
                buffer.add(IdentifiedObjects.toString((Identifier)id));
            }
            if (buffer.length() != 0) {
                this.addLine((short)100, buffer.toString());
            }
        }
        int label = 1;
        text = this.owner.string(info.getAbstract());
        if (text == null) {
            label = 164;
            text = this.owner.string(info.getPurpose());
            if (text == null) {
                for (String c : CollectionsExt.nonNull((Collection)info.getCredits())) {
                    text = c;
                    if (text == null) continue;
                    label = 42;
                    break;
                }
            }
        }
        this.addLine((short)label, text);
        DataIdentification dataIdentification = dataInfo = info instanceof DataIdentification ? (DataIdentification)info : null;
        if (dataInfo != null) {
            this.addLine((short)198, this.owner.string(CollectionsExt.nonNull((Collection)dataInfo.getTopicCategories())));
        }
        if (citation != null) {
            Object date = null;
            label = 52;
            for (CitationDate c : CollectionsExt.nonNull((Collection)citation.getDates())) {
                Date cd = c.getDate();
                if (cd == null) continue;
                DateType type = c.getDateType();
                if (DateType.PUBLICATION.equals((Object)type) || DateType.valueOf((String)"RELEASED").equals((Object)type)) {
                    label = 163;
                    date = cd;
                    break;
                }
                boolean isCreation = DateType.CREATION.equals((Object)type);
                if (date != null && !isCreation) continue;
                label = isCreation ? 41 : 52;
                date = cd;
            }
            if (date != null) {
                this.addLine((short)label, this.owner.getDateFormat().format((Date)date));
            }
        }
        if (dataInfo != null) {
            this.addLine((short)204, this.owner.string(CollectionsExt.nonNull((Collection)dataInfo.getSpatialRepresentationTypes())));
        }
        for (Format format : CollectionsExt.nonNull((Collection)info.getResourceFormats())) {
            text = this.owner.string(format.getSpecification());
            if (text == null) continue;
            this.addLine((short)85, text);
            break;
        }
        text = null;
        Identifier identifier = null;
        if (dataInfo != null) {
            for (Extent extent : CollectionsExt.nonNull((Collection)dataInfo.getExtents())) {
                if (extent == null) continue;
                if (text == null) {
                    text = this.owner.string(extent.getDescription());
                }
                for (GeographicExtent ge : CollectionsExt.nonNull((Collection)extent.getGeographicElements())) {
                    if (identifier == null && ge instanceof GeographicDescription) {
                        identifier = ((GeographicDescription)ge).getGeographicIdentifier();
                    }
                    if (this.isWorld || !(ge instanceof GeographicBoundingBox)) continue;
                    this.isWorld = this.drawOnMap((GeographicBoundingBox)ge);
                }
            }
        }
        if (text == null) {
            text = IdentifiedObjects.toString(identifier);
        }
        if (this.isWorld) {
            this.clearWorldMap();
            if (text == null) {
                text = this.owner.vocabulary.getString((short)225);
            }
        }
        this.addLine((short)81, text);
        IdentificationInfo.setRowIndex((Node)this.extentOnMap, (Integer)this.nextRowIndex());
    }

    private void drawOnMap(Set<GeographicBoundingBox> boxes) {
        if (boxes.isEmpty()) {
            this.clearWorldMap();
            return;
        }
        for (GeographicBoundingBox box : boxes) {
            this.isWorld = this.drawOnMap(box);
            if (!this.isWorld) continue;
            this.clearWorldMap();
            return;
        }
    }

    private boolean drawOnMap(GeographicBoundingBox bbox) {
        double west;
        double north = Latitude.clamp((double)bbox.getNorthBoundLatitude());
        double south = Latitude.clamp((double)bbox.getSouthBoundLatitude());
        double east = bbox.getEastBoundLongitude();
        if (Math.abs(east - (west = bbox.getWestBoundLongitude())) >= 359.9999998200144) {
            if (north >= 89.9999999100072 && south <= -89.9999999100072) {
                return true;
            }
            west = -180.0;
            east = 180.0;
        } else {
            if (west != 180.0) {
                west = Longitude.normalize((double)west);
            }
            if (east != 180.0) {
                east = Longitude.normalize((double)east);
            }
            if (east < west) {
                east += 360.0;
            }
        }
        if (north >= south && Double.isFinite(east) && Double.isFinite(west)) {
            double wi;
            boolean crossAntimeridian;
            double x = 180.0 + west;
            double y = 90.0 - north;
            double w = east - west;
            double h = north - south;
            if (w < 6.0) {
                x -= (6.0 - w) / 2.0;
                w = 6.0;
            }
            if (h < 6.0) {
                y -= (6.0 - h) / 2.0;
                h = 6.0;
            }
            boolean bl = crossAntimeridian = (w -= (wi = Math.min(w, 360.0 - x))) > 0.0;
            if (this.isWorldMapEmpty()) {
                this.drawMapBackground();
            }
            GraphicsContext gc = this.extentOnMap.getGraphicsContext2D();
            gc.setStroke((Paint)Color.DARKBLUE);
            gc.setGlobalAlpha(0.1);
            gc.fillRect(x, y, wi, h);
            if (crossAntimeridian) {
                gc.fillRect(0.0, y, w, h);
            }
            gc.setGlobalAlpha(1.0);
            if (!crossAntimeridian) {
                gc.strokeRect(x, y, wi, h);
            } else {
                double xw = x + wi;
                double yh = y + h;
                gc.strokePolyline(new double[]{xw, x, x, xw}, new double[]{y, y, yh, yh}, 4);
                gc.strokePolyline(new double[]{0.0, w, w, 0.0}, new double[]{y, y, yh, yh}, 4);
            }
        }
        return false;
    }

    private boolean drawMapBackground() {
        Image image = MetadataSummary.getWorldMap();
        if (image == null) {
            return false;
        }
        this.extentOnMap.setWidth(image.getWidth());
        this.extentOnMap.setHeight(image.getHeight());
        this.extentOnMap.getGraphicsContext2D().drawImage(image, 0.0, 0.0);
        return true;
    }
}

