/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.util.function.Predicate;
import java.util.logging.Logger;
import javafx.concurrent.Task;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

abstract class OperationFinder
extends Task<MathTransform> {
    private final GridGeometry dataGeometry;
    private final Envelope areaOfInterest;
    private final CoordinateReferenceSystem sourceCRS;
    private final CoordinateReferenceSystem targetCRS;
    private boolean sourceIsGrid;
    private boolean targetIsGrid;
    private CoordinateOperation operation;

    protected OperationFinder(MapCanvas canvas, Envelope areaOfInterest, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        this.dataGeometry = OperationFinder.dataGeometry(canvas);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.areaOfInterest = areaOfInterest;
    }

    private static GridGeometry dataGeometry(MapCanvas canvas) {
        GridCoverage coverage;
        if (canvas instanceof CoverageCanvas && (coverage = ((CoverageCanvas)canvas).getCoverage()) != null) {
            return coverage.getGridGeometry();
        }
        return null;
    }

    protected MathTransform call() throws Exception {
        DefaultGeographicBoundingBox bbox = null;
        if (this.areaOfInterest != null) {
            try {
                bbox = new DefaultGeographicBoundingBox();
                bbox.setBounds(this.areaOfInterest);
            }
            catch (TransformException e) {
                bbox = null;
                Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.gui"), this.getCallerClass(), (String)this.getCallerMethod(), (Throwable)e);
            }
        }
        MathTransform before = null;
        MathTransform after = null;
        CoordinateReferenceSystem source = this.sourceCRS;
        CoordinateReferenceSystem target = this.targetCRS;
        if (this.dataGeometry != null && this.dataGeometry.isDefined(9)) {
            this.sourceIsGrid = OperationFinder.isGridCRS(source);
            if (this.sourceIsGrid) {
                before = this.dataGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
                source = this.dataGeometry.getCoordinateReferenceSystem();
            }
            if (this.targetIsGrid = OperationFinder.isGridCRS(target)) {
                after = this.dataGeometry.getGridToCRS(PixelInCell.CELL_CENTER).inverse();
                target = this.dataGeometry.getCoordinateReferenceSystem();
            }
        }
        this.operation = CRS.findOperation((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target, (GeographicBoundingBox)bbox);
        MathTransform transform = this.operation.getMathTransform();
        if (before != null) {
            transform = MathTransforms.concatenate(before, (MathTransform)transform);
        }
        if (after != null) {
            transform = MathTransforms.concatenate((MathTransform)transform, after);
        }
        return transform;
    }

    static CoordinateReferenceSystem toGeospatial(CoordinateReferenceSystem crs, MapCanvas canvas) {
        GridGeometry dataGeometry;
        if (OperationFinder.isGridCRS(crs) && (dataGeometry = OperationFinder.dataGeometry(canvas)) != null && dataGeometry.isDefined(1)) {
            crs = dataGeometry.getCoordinateReferenceSystem();
        }
        return crs;
    }

    private static boolean isGridCRS(CoordinateReferenceSystem crs) {
        return crs instanceof SingleCRS && CommonCRS.Engineering.GRID.datum().equals((Object)((SingleCRS)crs).getDatum());
    }

    public final CoordinateOperation getOperation() {
        return this.operation;
    }

    public final CoordinateReferenceSystem getTargetCRS() {
        CoordinateReferenceSystem crs;
        if (!this.targetIsGrid && (crs = this.operation.getTargetCRS()) != null) {
            return crs;
        }
        return this.targetCRS;
    }

    final Predicate<MapCanvas> fullOperationSearchRequired() {
        return this.sourceIsGrid | this.targetIsGrid ? new UpdateCheck(this.dataGeometry) : null;
    }

    protected abstract Class<?> getCallerClass();

    protected abstract String getCallerMethod();

    private static final class UpdateCheck
    implements Predicate<MapCanvas> {
        private final GridGeometry dataGeometry;

        UpdateCheck(GridGeometry dataGeometry) {
            this.dataGeometry = dataGeometry;
        }

        @Override
        public boolean test(MapCanvas canvas) {
            return !this.dataGeometry.equals((Object)OperationFinder.dataGeometry(canvas));
        }
    }
}

