/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.gui.referencing.PositionableProjection;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class MapMenu
extends ContextMenu {
    private final MapCanvas canvas;
    private MapCanvas.MenuHandler menuHandler;
    private int defined;
    private static final int CRS = 1;
    private static final int COPY = 2;

    public MapMenu(MapCanvas canvas) {
        ArgumentChecks.ensureNonNull((String)"canvas", (Object)((Object)canvas));
        this.canvas = canvas;
    }

    private MapCanvas.MenuHandler startNewMenuItems(int mask) {
        if ((this.defined & mask) != 0) {
            throw new IllegalStateException();
        }
        this.defined |= mask;
        if (this.menuHandler == null) {
            MapCanvas mapCanvas = this.canvas;
            Objects.requireNonNull(mapCanvas);
            this.menuHandler = mapCanvas.new MapCanvas.MenuHandler(this);
        }
        return this.menuHandler;
    }

    public void addReferenceSystems(RecentReferenceSystems preferences) {
        ArgumentChecks.ensureNonNull((String)"preferences", (Object)preferences);
        MapCanvas.MenuHandler handler = this.startNewMenuItems(1);
        Menu systemChoices = preferences.createMenuItems(handler);
        handler.selectedCrsProperty = RecentReferenceSystems.getSelectedProperty(systemChoices);
        handler.positionables = new ToggleGroup();
        Resources resources = Resources.forLocale(this.canvas.getLocale());
        Menu localSystems = new Menu(resources.getString((short)43));
        for (PositionableProjection projection : PositionableProjection.values()) {
            RadioMenuItem item = new RadioMenuItem(projection.toString());
            item.setToggleGroup(handler.positionables);
            item.setOnAction(e -> handler.createProjectedCRS(projection));
            localSystems.getItems().add((Object)item);
        }
        this.getItems().addAll((Object[])new MenuItem[]{systemChoices, localSystems});
        this.canvas.addPropertyChangeListener("objectiveCRS", handler);
    }

    public void addCopyOptions(StatusBar format) {
        ArgumentChecks.ensureNonNull((String)"format", (Object)format);
        MapCanvas.MenuHandler handler = this.startNewMenuItems(2);
        Resources resources = Resources.forLocale(this.canvas.getLocale());
        MenuItem coordinates = resources.menu((short)50, (EventHandler<ActionEvent>)((EventHandler)event -> {
            try {
                String text = format.formatCoordinates(handler.x, handler.y);
                ClipboardContent content = new ClipboardContent();
                content.putString(text);
                Clipboard.getSystemClipboard().setContent((Map)content);
            }
            catch (RuntimeException | TransformException e) {
                ExceptionReporter.show(this.getOwnerWindow(), ((MenuItem)event.getSource()).getText(), null, e);
            }
        }));
        this.getItems().add((Object)coordinates);
    }

    public Optional<ObservableObjectValue<String>> selectedReferenceSystem() {
        ObjectProperty<ReferenceSystem> selectedCrsProperty;
        if (this.menuHandler != null && (selectedCrsProperty = this.menuHandler.selectedCrsProperty) != null) {
            return Optional.of(new SelectedCRS(selectedCrsProperty, this.canvas.getLocale()));
        }
        return Optional.empty();
    }

    private static final class SelectedCRS
    extends ObjectBinding<String> {
        private final ObjectProperty<ReferenceSystem> selectedSystem;
        private final Locale locale;

        SelectedCRS(ObjectProperty<ReferenceSystem> selectedSystem, Locale locale) {
            this.selectedSystem = selectedSystem;
            this.locale = locale;
            this.bind(new Observable[]{selectedSystem});
        }

        protected String computeValue() {
            return IdentifiedObjects.getDisplayName((IdentifiedObject)((IdentifiedObject)this.selectedSystem.get()), (Locale)this.locale);
        }
    }
}

