/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.sis.gui.dataset.LoadEvent;
import org.apache.sis.gui.dataset.PathAction;
import org.apache.sis.gui.dataset.ResourceEvent;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.DataStoreOpener;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class ResourceTree
extends TreeView<Resource> {
    final Locale locale = Locale.getDefault();
    public final ObjectProperty<EventHandler<ResourceEvent>> onResourceLoaded;
    public final ObjectProperty<EventHandler<ResourceEvent>> onResourceClosed;
    private final Queue<Item.Completer> pendingItems = new LinkedList<Item.Completer>();

    public ResourceTree() {
        this.setCellFactory(v -> new Cell());
        this.setOnDragOver(ResourceTree::onDragOver);
        this.setOnDragDropped(this::onDragDropped);
        this.onResourceLoaded = new SimpleObjectProperty((Object)this, "onResourceLoaded");
        this.onResourceClosed = new SimpleObjectProperty((Object)this, "onResourceClosed");
    }

    public Resource getResource() {
        TreeItem item = this.getRoot();
        return item == null ? null : (Resource)item.getValue();
    }

    public void setResource(Resource resource) {
        this.setRoot(resource == null ? null : new Item(resource));
        this.setShowRoot(!(resource instanceof Root));
    }

    public boolean addResource(Resource resource) {
        assert (Platform.isFxApplicationThread());
        if (resource == null) {
            return false;
        }
        Root addTo = null;
        TreeItem item = this.getRoot();
        if (item != null) {
            Resource root = (Resource)item.getValue();
            if (root == resource) {
                return false;
            }
            if (root instanceof Root) {
                addTo = (Root)root;
            }
        }
        if (addTo == null) {
            TreeItem group = new TreeItem();
            this.setShowRoot(false);
            this.setRoot(group);
            addTo = new Root((TreeItem<Resource>)group, (TreeItem<Resource>)item);
            group.setValue((Object)addTo);
        }
        return addTo.add(resource);
    }

    public void loadResource(Object source) {
        if (source != null) {
            if (source instanceof Resource) {
                this.addResource((Resource)source);
            } else {
                DataStoreOpener opener = new DataStoreOpener(source);
                DataStore existing = opener.fromCache();
                if (existing != null) {
                    this.addResource((Resource)existing);
                } else {
                    opener.setOnSucceeded(event -> this.addLoadedResource((DataStore)event.getSource().getValue(), source));
                    opener.setOnFailed(event -> ExceptionReporter.show((Node)this, event));
                    BackgroundThreads.execute((Runnable)((Object)opener));
                }
            }
        }
    }

    private void addLoadedResource(DataStore store, Object source) {
        boolean added = this.addResource((Resource)store);
        EventHandler handler = (EventHandler)this.onResourceLoaded.getValue();
        if (handler != null) {
            Path path;
            try {
                path = IOUtilities.toPathOrNull((Object)source);
            }
            catch (IllegalArgumentException | FileSystemNotFoundException e) {
                ResourceTree.recoverableException("loadResource", e);
                return;
            }
            if (path != null) {
                if (added) {
                    ((Item)this.findOrRemove((Resource)store, (boolean)false)).path = path;
                }
                handler.handle((Event)new LoadEvent(this, path));
            }
        }
    }

    private void onDragDropped(DragEvent event) {
        Dragboard db = event.getDragboard();
        List files = db.getFiles();
        boolean success = false;
        if (files != null) {
            for (File file : files) {
                this.loadResource(file);
            }
            success = true;
        } else {
            String url = db.getUrl();
            if (url != null) {
                try {
                    this.loadResource(new URL(url));
                    success = true;
                }
                catch (MalformedURLException e) {
                    int start = url.lastIndexOf(47, url.length() - 2) + 1;
                    int stop = url.indexOf(63, start);
                    if (stop <= 0) {
                        stop = url.length();
                    }
                    ExceptionReporter.canNotReadFile((Node)this, url.substring(start, stop), e);
                }
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private static void onDragOver(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasFiles() || db.hasUrl()) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
        }
        event.consume();
    }

    public void removeAndClose(Resource resource) {
        TreeItem<Resource> item = this.findOrRemove(resource, true);
        if (item != null && resource instanceof DataStore) {
            DataStore store = (DataStore)resource;
            DataStoreOpener.removeAndClose(store, (Node)this);
            EventHandler handler = (EventHandler)this.onResourceClosed.get();
            if (handler != null) {
                Path path = null;
                if (item instanceof Item) {
                    path = ((Item)item).path;
                }
                if (path == null) {
                    try {
                        path = store.getOpenParameters().map(p -> IOUtilities.toPathOrNull((Object)p.parameter("location").getValue())).orElse(null);
                    }
                    catch (IllegalArgumentException | FileSystemNotFoundException e) {
                        ResourceTree.recoverableException("removeAndClose", e);
                    }
                }
                if (path != null) {
                    handler.handle((Event)new ResourceEvent(this, path, ResourceEvent.CLOSED));
                }
            }
        }
    }

    private TreeItem<Resource> findOrRemove(Resource resource, boolean remove) {
        assert (Platform.isFxApplicationThread());
        if (resource != null) {
            Resource root;
            TreeItem item;
            if (remove) {
                ObservableList items = this.getSelectionModel().getSelectedItems();
                int i = items.size();
                while (--i >= 0) {
                    if (((TreeItem)items.get(i)).getValue() != resource) continue;
                    this.getSelectionModel().clearSelection(i);
                }
            }
            if ((item = this.getRoot()) != null && (root = (Resource)item.getValue()) != null) {
                if (root == resource) {
                    if (remove) {
                        this.setRoot(null);
                    }
                    return item;
                }
                if (root instanceof Root) {
                    return ((Root)root).contains(resource, remove);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String findLabel(Resource resource, Locale locale, boolean qualified) throws DataStoreException {
        block16: {
            if (resource != null) {
                Long logID = LogHandler.loadingStart(resource);
                try {
                    String name;
                    if (resource instanceof DataStore && (name = Strings.trimOrNull((String)((DataStore)resource).getDisplayName())) != null) {
                        String string = name;
                        return string;
                    }
                    name = qualified ? (GenericName)resource.getIdentifier().orElse(null) : null;
                    Collection identifications = null;
                    Metadata metadata = resource.getMetadata();
                    if (metadata != null && (identifications = metadata.getIdentificationInfo()) != null) {
                        for (Object identification : identifications) {
                            String t;
                            Citation citation = identification.getCitation();
                            if (citation == null || (t = ResourceTree.string(citation.getTitle(), locale)) == null || name != null && t.equals(name.toString())) continue;
                            String string = t;
                            return string;
                        }
                    }
                    if (!qualified) {
                        name = resource.getIdentifier().orElse(null);
                    }
                    if (name != null) {
                        String t;
                        if (qualified) {
                            name = name.toFullyQualifiedName();
                        }
                        if ((t = ResourceTree.string(name.toInternationalString(), locale)) != null) {
                            Object identification;
                            identification = t;
                            return identification;
                        }
                    }
                    if (identifications == null) break block16;
                    for (Object identification : identifications) {
                        String t = Citations.getIdentifier((Citation)identification.getCitation());
                        if (t == null) continue;
                        String string = t;
                        return string;
                    }
                }
                finally {
                    LogHandler.loadingStop(logID);
                }
            }
        }
        return Vocabulary.getResources((Locale)locale).getString((short)208);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchLabel(Item.Completer item) {
        boolean isEmpty;
        Queue<Item.Completer> queue = this.pendingItems;
        synchronized (queue) {
            isEmpty = this.pendingItems.isEmpty();
            this.pendingItems.add(item);
        }
        if (isEmpty) {
            BackgroundThreads.execute(() -> {
                while (true) {
                    Item.Completer c;
                    Queue<Item.Completer> queue = this.pendingItems;
                    synchronized (queue) {
                        c = this.pendingItems.poll();
                    }
                    if (c == null) break;
                    c.fetch(this.locale);
                }
            });
        }
    }

    final Resources localized() {
        return Resources.forLocale(this.locale);
    }

    private static String string(InternationalString i18n, Locale locale) {
        return i18n != null ? Strings.trimOrNull((String)i18n.toString(locale)) : null;
    }

    private static String string(Throwable failure, Locale locale) {
        String text = Strings.trimOrNull((String)Exceptions.getLocalizedMessage((Throwable)failure, (Locale)locale));
        if (text == null) {
            text = Classes.getShortClassName((Object)failure);
        }
        return text;
    }

    private static void recoverableException(String method, Exception e) {
        Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.gui"), ResourceTree.class, (String)method, (Throwable)e);
    }

    static void unexpectedException(String method, Exception e) {
        Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.gui"), ResourceTree.class, (String)method, (Throwable)e);
    }

    private static final class Item
    extends TreeItem<Resource> {
        Path path;
        String label;
        boolean isLoading;
        Throwable error;
        private final boolean isLeaf;
        private boolean isChildrenKnown;

        Item() {
            this.isLeaf = true;
            this.isLoading = true;
        }

        Item(Throwable exception) {
            this.isLeaf = true;
            this.error = exception;
        }

        Item(Resource resource) {
            super((Object)resource);
            this.isLoading = true;
            this.isLeaf = !(resource instanceof Aggregate);
            LogHandler.installListener(resource);
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public ObservableList<TreeItem<Resource>> getChildren() {
            ObservableList children = super.getChildren();
            if (!this.isChildrenKnown) {
                this.isChildrenKnown = true;
                Resource resource = (Resource)this.getValue();
                if (resource instanceof Aggregate) {
                    BackgroundThreads.execute((Runnable)((Object)new GetChildren((Aggregate)resource)));
                    children.add((Object)new Item());
                }
            }
            return children;
        }

        private final class GetChildren
        extends Task<List<TreeItem<Resource>>> {
            private final Aggregate resource;

            GetChildren(Aggregate resource) {
                this.resource = resource;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<TreeItem<Resource>> call() throws DataStoreException {
                ArrayList<TreeItem<Resource>> items = new ArrayList<TreeItem<Resource>>();
                Long id = LogHandler.loadingStart((Resource)this.resource);
                try {
                    for (Resource component : this.resource.components()) {
                        items.add(new Item(component));
                    }
                }
                finally {
                    LogHandler.loadingStop(id);
                }
                return items;
            }

            protected void succeeded() {
                Item.super.getChildren().setAll((Collection)this.getValue());
            }

            protected void failed() {
                Item.super.getChildren().setAll((Object[])new TreeItem[]{new Item(this.getException())});
            }
        }

        final class Completer
        implements Runnable {
            private final Resource resource;
            private String result;
            private Throwable failure;

            Completer(Resource resource) {
                this.resource = resource;
            }

            final void fetch(Locale locale) {
                try {
                    this.result = ResourceTree.findLabel(this.resource, locale, false);
                }
                catch (Throwable e) {
                    this.failure = e;
                }
                Platform.runLater((Runnable)this);
            }

            @Override
            public void run() {
                Item.this.isLoading = false;
                Item.this.label = this.result;
                Item.this.error = this.failure;
                GUIUtilities.forceCellUpdate(Item.this);
            }
        }
    }

    private static final class Root
    implements Aggregate {
        private final List<TreeItem<Resource>> components;

        Root(TreeItem<Resource> group, TreeItem<Resource> previous) {
            this.components = group.getChildren();
            if (previous != null) {
                this.components.add(previous);
            }
        }

        TreeItem<Resource> contains(Resource resource, boolean remove) {
            int i = this.components.size();
            while (--i >= 0) {
                TreeItem<Resource> item = this.components.get(i);
                if (item.getValue() != resource) continue;
                return remove ? this.components.remove(i) : item;
            }
            return null;
        }

        boolean add(Resource resource) {
            int i = this.components.size();
            while (--i >= 0) {
                if (this.components.get(i).getValue() != resource) continue;
                return false;
            }
            return this.components.add(new Item(resource));
        }

        public Collection<Resource> components() {
            return new AbstractList<Resource>(){

                @Override
                public int size() {
                    return components.size();
                }

                @Override
                public Resource get(int index) {
                    return (Resource)components.get(index).getValue();
                }
            };
        }

        public Optional<GenericName> getIdentifier() {
            return Optional.empty();
        }

        public Metadata getMetadata() {
            return null;
        }

        public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        }

        public <T extends StoreEvent> void removeListener(Class<T> eventType, StoreListener<? super T> listener) {
        }
    }

    private static final class Cell
    extends TreeCell<Resource> {
        private static final int COPY_PATH = 0;
        private static final int OPEN_FOLDER = 1;
        private static final int CLOSE = 2;

        Cell() {
        }

        protected void updateItem(Resource resource, boolean empty) {
            TreeItem t;
            super.updateItem((Object)resource, empty);
            Color color = Styles.NORMAL_TEXT;
            String text = null;
            Button more = null;
            ContextMenu menu = null;
            if (!empty && (t = this.getTreeItem()) instanceof Item) {
                ResourceTree tree = (ResourceTree)this.getTreeView();
                Item item = (Item)t;
                text = item.label;
                if (item.isLoading) {
                    color = Styles.LOADING_TEXT;
                    if (text == null) {
                        text = item.label = tree.localized().getString((short)24);
                        if (resource != null) {
                            Item item2 = item;
                            Objects.requireNonNull(item2);
                            tree.fetchLabel(item2.new Item.Completer(resource));
                        }
                    }
                } else {
                    Throwable error = item.error;
                    if (error != null) {
                        color = Styles.ERROR_TEXT;
                        if (text == null) {
                            text = resource != null ? Vocabulary.getResources((Locale)tree.locale).getString((short)208) : ResourceTree.string(error, tree.locale);
                            item.label = text;
                        }
                        if ((more = (Button)this.getGraphic()) == null) {
                            more = new Button("\u2139\ufe0f");
                        }
                        more.setOnAction(e -> {
                            Resources localized = tree.localized();
                            ExceptionReporter.show((Node)tree, localized.getString((short)17), localized.getString((short)7), error);
                        });
                    }
                }
                if (tree.findOrRemove(resource, false) != null) {
                    Object path;
                    menu = this.getContextMenu();
                    if (menu == null) {
                        menu = new ContextMenu();
                        Resources localized = tree.localized();
                        Object[] items = new MenuItem[]{localized.menu((short)51, new PathAction(this, false)), localized.menu((short)66, new PathAction(this, true)), localized.menu((short)10, (EventHandler<ActionEvent>)((EventHandler)e -> ((ResourceTree)this.getTreeView()).removeAndClose((Resource)this.getItem())))};
                        menu.getItems().setAll(items);
                    }
                    try {
                        path = URIDataStore.location((Resource)resource);
                    }
                    catch (DataStoreException e2) {
                        path = null;
                        ResourceTree.unexpectedException("updateItem", (Exception)((Object)e2));
                    }
                    ((MenuItem)menu.getItems().get(0)).setDisable(!IOUtilities.isKindOfPath((Object)path));
                    ((MenuItem)menu.getItems().get(1)).setDisable(PathAction.isBrowseDisabled || IOUtilities.toFile((Object)path) == null);
                }
            }
            this.setText(text);
            this.setTextFill((Paint)(this.isSelected() ? Styles.SELECTED_TEXT : color));
            this.setGraphic((Node)more);
            this.setContextMenu(menu);
        }
    }
}

