/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.apache.sis.gui.dataset.ResourceTree;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.storage.ResourceOnFileSystem;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;

final class PathAction
implements EventHandler<ActionEvent> {
    private final TreeCell<Resource> cell;
    private final boolean browser;
    static final boolean isBrowseDisabled = !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE_FILE_DIR);

    PathAction(TreeCell<Resource> source, boolean browser) {
        this.cell = source;
        this.browser = browser;
    }

    /*
     * Unable to fully structure code
     */
    public void handle(ActionEvent event) {
        resource = (Resource)this.cell.getItem();
        try {
            path = URIDataStore.location((Resource)resource);
        }
        catch (DataStoreException e) {
            ExceptionReporter.show(this.cell, null, null, (Throwable)e);
            return;
        }
        file = path;
        uri = null;
        try {
            if (path instanceof URI) {
                uri = path;
                file = new File((URI)path);
            } else if (path instanceof URL) {
                uri = path;
                file = new File(((URL)path).toURI());
            } else if (path instanceof File) {
                uri = ((File)path).toURI();
            } else if (path instanceof Path) {
                uri = ((Path)path).toUri();
                file = ((Path)path).toFile();
            } else if (path instanceof CharSequence) {
                uri = new URI(path.toString());
            } else {
                file = "";
            }
        }
        catch (IllegalArgumentException | UnsupportedOperationException | URISyntaxException var6_7) {
            // empty catch block
        }
        if (this.browser) {
            if (file instanceof File) {
                try {
                    Desktop.getDesktop().browseFileDirectory((File)file);
                }
                catch (Exception e) {
                    ExceptionReporter.show((Node)this.cell.getTreeView(), null, null, (Throwable)e);
                }
            }
            return;
        }
        files = null;
        if (resource instanceof ResourceOnFileSystem) {
            try {
                components = ((ResourceOnFileSystem)resource).getComponentFiles();
                if (components == null) ** GOTO lbl62
                files = new ArrayList<File>(components.length);
                for (Path p : components) {
                    try {
                        if (p == null) continue;
                        files.add(p.toFile());
                    }
                    catch (UnsupportedOperationException var12_16) {
                        // empty catch block
                    }
                }
            }
            catch (DataStoreException e) {
                ResourceTree.unexpectedException("copy", (Exception)e);
            }
        } else if (file instanceof File) {
            files = Collections.singletonList((File)file);
        }
lbl62:
        // 6 sources

        content = new ClipboardContent();
        content.putString(file.toString());
        if (files != null) {
            content.putFiles(files);
        }
        if (uri != null) {
            content.putUrl(uri.toString());
        }
        Clipboard.getSystemClipboard().setContent((Map)content);
    }
}

