/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.image.RenderedImage;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.sis.gui.coverage.IsolineRenderer;
import org.apache.sis.gui.coverage.Stretching;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.internal.map.coverage.RenderingData;
import org.apache.sis.internal.processing.image.Isolines;
import org.apache.sis.storage.DataStoreException;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class StyledRenderingData
extends RenderingData {
    Stretching selectedDerivative = Stretching.NONE;

    StyledRenderingData(ErrorHandler errorHandler) {
        super(errorHandler);
    }

    final RenderedImage recolor() throws DataStoreException {
        RenderedImage image = this.getSourceImage();
        if (this.selectedDerivative != Stretching.NONE) {
            Map modifiers = this.statistics();
            if (this.selectedDerivative == Stretching.AUTOMATIC) {
                modifiers.put("multStdDev", 3);
            }
            image = this.processor.stretchColorRamp(image, modifiers);
        }
        return image;
    }

    final Future<Isolines[]> generate(IsolineRenderer.Snapshot[] isolines) throws TransformException {
        if (isolines == null) {
            return null;
        }
        MathTransform centerToObjective = this.getDataToObjective(PixelInCell.CELL_CENTER);
        return IsolineRenderer.generate(isolines, this.getSourceImage(), centerToObjective);
    }

    public StyledRenderingData clone() {
        return (StyledRenderingData)super.clone();
    }
}

