/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.WeakHashMap;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.map.coverage.MultiResolutionCoverageLoader;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;

final class MultiResolutionImageLoader
extends MultiResolutionCoverageLoader {
    static final int BIDIMENSIONAL = 2;
    private static final double SLICE_RATIO = 0.0;
    private static final WeakHashMap<GridCoverageResource, MultiResolutionImageLoader> CACHE = new WeakHashMap();

    private MultiResolutionImageLoader(GridCoverageResource resource) throws DataStoreException {
        super(resource, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MultiResolutionCoverageLoader getInstance(GridCoverageResource resource, MultiResolutionCoverageLoader cached) throws DataStoreException {
        if (cached == null || cached.resource != resource) {
            WeakHashMap<GridCoverageResource, MultiResolutionImageLoader> weakHashMap = CACHE;
            synchronized (weakHashMap) {
                cached = CACHE.get(resource);
            }
            if (cached == null) {
                MultiResolutionImageLoader loader = new MultiResolutionImageLoader(resource);
                WeakHashMap<GridCoverageResource, MultiResolutionImageLoader> weakHashMap2 = CACHE;
                synchronized (weakHashMap2) {
                    cached = CACHE.putIfAbsent(resource, loader);
                }
                if (cached == null) {
                    cached = loader;
                }
            }
        }
        return cached;
    }

    protected GridGeometry getReadDomain(GridGeometry subgrid) {
        return MultiResolutionImageLoader.slice(subgrid);
    }

    static GridGeometry slice(GridGeometry gg) {
        if (gg != null && gg.getDimension() > 2 && gg.isDefined(4)) {
            gg = MultiResolutionImageLoader.slice(gg.derive(), gg.getExtent()).build();
        }
        return gg;
    }

    static GridDerivation slice(GridDerivation subgrid, GridExtent extent) {
        int dimension = extent.getDimension();
        if (dimension <= 2) {
            return subgrid;
        }
        int[] sliceDimensions = new int[2];
        int k = 0;
        for (int i = 0; i < dimension; ++i) {
            if (extent.getLow(i) == extent.getHigh(i)) continue;
            sliceDimensions[k] = i;
            if (++k >= 2) break;
        }
        return subgrid.sliceByRatio(0.0, sliceDimensions);
    }
}

