/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.image.RenderedImage;
import java.util.Optional;
import java.util.concurrent.FutureTask;
import javafx.scene.Node;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.gui.coverage.MultiResolutionImageLoader;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.operation.MathTransform;

public class ImageRequest {
    final GridCoverageResource resource;
    private volatile GridCoverage coverage;
    private final GridGeometry domain;
    private final int[] range;
    private GridExtent sliceExtent;

    ImageRequest(GridCoverageResource source, GridCoverage data) {
        this.resource = source;
        this.coverage = data;
        this.domain = null;
        this.range = null;
    }

    public ImageRequest(GridCoverageResource source, GridGeometry domain, int ... range) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        this.resource = source;
        this.domain = domain;
        this.range = range != null && range.length != 0 ? range : null;
    }

    public ImageRequest(GridCoverage source, GridExtent sliceExtent) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        this.resource = null;
        this.domain = null;
        this.range = null;
        this.coverage = source;
        this.sliceExtent = sliceExtent;
    }

    public final Optional<GridCoverage> getCoverage() {
        return Optional.ofNullable(this.coverage);
    }

    public final Optional<GridGeometry> getDomain() {
        return Optional.ofNullable(this.domain);
    }

    public final Optional<int[]> getRange() {
        return Optional.ofNullable(this.range);
    }

    public final Optional<GridExtent> getSliceExtent() {
        return Optional.ofNullable(this.sliceExtent);
    }

    public final void setSliceExtent(GridExtent sliceExtent) {
        this.sliceExtent = sliceExtent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized RenderedImage load(FutureTask<?> task) throws DataStoreException {
        GridCoverage cv = this.coverage;
        Long id = LogHandler.loadingStart((Resource)this.resource);
        try {
            GridGeometry gg;
            if (cv == null) {
                cv = MultiResolutionImageLoader.getInstance(this.resource, null).getOrLoad(this.domain, this.range);
            }
            this.coverage = cv = cv.forConvertedValues(true);
            if (task.isCancelled()) {
                RenderedImage renderedImage = null;
                return renderedImage;
            }
            GridExtent ex = this.sliceExtent;
            if (ex == null && (gg = cv.getGridGeometry()).getDimension() > 2) {
                ex = MultiResolutionImageLoader.slice(gg.derive(), gg.getExtent()).getIntersection();
            }
            RenderedImage renderedImage = cv.render(ex);
            return renderedImage;
        }
        finally {
            LogHandler.loadingStop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void configure(StatusBar bar) {
        Long id = LogHandler.loadingStart((Resource)this.resource);
        try {
            GridCoverage cv = this.coverage;
            GridExtent ex = this.sliceExtent;
            bar.applyCanvasGeometry(cv != null ? cv.getGridGeometry() : null);
            if (ex != null) {
                double[] origin = new double[ex.getDimension()];
                for (int i = 0; i < origin.length; ++i) {
                    origin[i] = ex.getLow(i);
                }
                bar.localToObjectiveCRS.set((Object)MathTransforms.concatenate((MathTransform)MathTransforms.translation((double[])origin), (MathTransform)((MathTransform)bar.localToObjectiveCRS.get())));
            }
        }
        finally {
            LogHandler.loadingStop(id);
        }
    }

    final void reportError(Node owner, Throwable exception) {
        if (this.resource instanceof StoreListeners) {
            ExceptionReporter.canNotReadFile(owner, ((StoreListeners)this.resource).getSourceName(), exception);
        } else {
            ExceptionReporter.canNotUseResource(owner, exception);
        }
    }
}

