/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.control.Cell;
import javafx.scene.control.skin.CellSkinBase;
import javafx.scene.text.Text;
import org.apache.sis.gui.coverage.GridCell;
import org.apache.sis.gui.coverage.GridRow;
import org.apache.sis.gui.coverage.GridViewSkin;

final class GridRowSkin
extends CellSkinBase<GridRow> {
    GridRowSkin(GridRow owner) {
        super((Cell)owner);
        this.setRowIndex(owner.getIndex());
    }

    final void setRowIndex(int index) {
        Text header = (Text)this.getChildren().get(0);
        header.setText(((GridRow)this.getSkinnable()).view.formatHeaderValue(index, true));
    }

    protected void layoutChildren(double x, double y, double width, double height) {
        ObservableList children = this.getChildren();
        GridRow row = (GridRow)this.getSkinnable();
        GridViewSkin layout = (GridViewSkin)row.view.getSkin();
        double pos = layout.leftPosition;
        ((Text)children.get(0)).resizeRelocate(pos, y, layout.headerWidth, height);
        pos += layout.headerWidth;
        double cellWidth = layout.cellWidth;
        double available = layout.cellInnerWidth;
        double limit = layout.rightPosition;
        int column = layout.firstVisibleColumn;
        int childIndex = 0;
        ArrayList<GridCell> newChildren = null;
        int count = children.size();
        while (pos < limit) {
            GridCell cell;
            if (++childIndex < count) {
                cell = (GridCell)((Object)children.get(childIndex));
            } else {
                cell = new GridCell();
                cell.setAlignment(Pos.CENTER_RIGHT);
                if (newChildren == null) {
                    newChildren = new ArrayList<GridCell>(1 + (int)((limit - pos) / cellWidth));
                }
                newChildren.add(cell);
            }
            String value = row.getSampleValue(column++);
            cell.updateItem(value, value == "");
            cell.resizeRelocate(pos, 0.0, available, height);
            pos += cellWidth;
        }
        if (newChildren != null) {
            children.addAll(newChildren);
        } else if (++childIndex < count) {
            children.remove(childIndex, count);
        }
    }
}

