/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.Collection;
import java.util.Locale;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Slider;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.gui.coverage.BandRangeTable;
import org.apache.sis.gui.coverage.BandSelectionListener;
import org.apache.sis.gui.coverage.CoverageExplorer;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.gui.coverage.ViewAndControls;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.Vocabulary;

final class GridControls
extends ViewAndControls {
    private final GridView view;
    private final TitledPane[] controls;
    private final TableView<SampleDimension> sampleDimensions;

    GridControls(CoverageExplorer owner) {
        super(owner);
        this.view = new GridView(this, owner.referenceSystems);
        Vocabulary vocabulary = Vocabulary.getResources((Locale)owner.getLocale());
        this.sampleDimensions = new BandRangeTable(this.view.cellFormat).create(vocabulary);
        BandSelectionListener.bind(this.view.bandProperty, this.sampleDimensions.getSelectionModel());
        GridPane gp = Styles.createControlGrid(0, GridControls.label((IndexedResourceBundle)vocabulary, (short)224, (Control)GridControls.createSlider(this.view.cellWidth, 30.0, 200.0)), GridControls.label((IndexedResourceBundle)vocabulary, (short)98, (Control)GridControls.createSlider(this.view.cellHeight, 10.0, 50.0)), GridControls.label((IndexedResourceBundle)vocabulary, (short)85, this.view.cellFormat.createEditor()));
        Styles.setAllRowToSameHeight(gp);
        VBox displayPane = new VBox(new Node[]{GridControls.labelOfGroup((IndexedResourceBundle)vocabulary, (short)178, this.sampleDimensions, true), this.sampleDimensions, GridControls.labelOfGroup((IndexedResourceBundle)vocabulary, (short)24, (Region)gp, false), gp});
        this.controls = new TitledPane[]{new TitledPane(vocabulary.getString((short)67), (Node)displayPane)};
    }

    private static Slider createSlider(DoubleProperty property, double min, double max) {
        Slider slider = new Slider(min, max, property.getValue().doubleValue());
        property.bind((ObservableValue)slider.valueProperty());
        slider.setShowTickMarks(false);
        return slider;
    }

    final void notifyDataChanged(GridCoverageResource source, GridCoverage data) {
        ObservableList items = this.sampleDimensions.getItems();
        if (data != null) {
            items.setAll((Collection)data.getSampleDimensions());
            this.sampleDimensions.getSelectionModel().clearAndSelect(this.view.getBand());
        } else {
            items.clear();
        }
        this.owner.notifyDataChanged(source, data);
    }

    @Override
    final void load(ImageRequest request) {
        this.view.setImage(request);
    }

    @Override
    final Region view() {
        return this.view;
    }

    @Override
    final TitledPane[] controlPanes() {
        return this.controls;
    }
}

