/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.apache.sis.coverage.Category;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.internal.coverage.j2d.Colorizer;
import org.apache.sis.internal.gui.ImmutableObjectProperty;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.control.ColorColumnHandler;
import org.apache.sis.internal.gui.control.ColorRamp;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

final class CoverageStyling
extends ColorColumnHandler<Category>
implements Function<Category, Color[]> {
    private final Map<String, int[]> customizedColors = new HashMap<String, int[]>();
    private final Function<Category, Color[]> fallback;
    private final CoverageCanvas canvas;

    CoverageStyling(CoverageCanvas canvas) {
        Function<Category, Color[]> c;
        this.canvas = canvas;
        if (canvas != null && (c = canvas.getCategoryColors()) != null) {
            this.fallback = c;
            return;
        }
        this.fallback = Colorizer.GRAYSCALE;
    }

    private void clear(ObservableList<Category> items) {
        Object[] content = (Category[])items.toArray((Object[])new Category[items.size()]);
        items.clear();
        this.customizedColors.clear();
        items.setAll(content);
        if (this.canvas != null) {
            this.canvas.setCategoryColors(null);
        }
    }

    private static String key(Category category) {
        return category.getName().toString(Locale.ENGLISH);
    }

    final void setARGB(Category category, int[] colors) {
        String key = CoverageStyling.key(category);
        int[] old = colors != null && colors.length != 0 ? this.customizedColors.put(key, colors) : this.customizedColors.remove(key);
        if (this.canvas != null && !Arrays.equals(colors, old)) {
            this.canvas.setCategoryColors(this);
        }
    }

    @Override
    protected int[] getARGB(Category category) {
        Color[] colors;
        int[] ARGB = this.customizedColors.get(CoverageStyling.key(category));
        if (ARGB == null && (colors = this.fallback.apply(category)) != null) {
            ARGB = new int[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                ARGB[i] = colors[i].getRGB();
            }
        }
        return ARGB;
    }

    @Override
    public Color[] apply(Category category) {
        int[] ARGB = this.customizedColors.get(CoverageStyling.key(category));
        if (ARGB != null) {
            Color[] colors = new Color[ARGB.length];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = new Color(ARGB[i], true);
            }
            return colors;
        }
        return this.fallback.apply(category);
    }

    @Override
    protected ColorRamp.Type applyColors(Category category, ColorRamp colors) {
        this.setARGB(category, colors != null ? colors.colors : null);
        return category.isQuantitative() ? ColorRamp.Type.GRADIENT : ColorRamp.Type.SOLID;
    }

    final TableView<Category> createCategoryTable(Resources resources, Vocabulary vocabulary) {
        TableColumn name = new TableColumn(vocabulary.getString((short)139));
        name.setCellValueFactory(CoverageStyling::getCategoryName);
        name.setCellFactory(CoverageStyling::createNameCell);
        name.setEditable(false);
        name.setId("name");
        TableView table = new TableView();
        table.getColumns().add((Object)name);
        this.addColumnTo(table, vocabulary.getString((short)228));
        MenuItem reset = new MenuItem(resources.getString((short)55));
        reset.setOnAction(e -> this.clear((ObservableList<Category>)table.getItems()));
        table.setContextMenu(new ContextMenu(new MenuItem[]{reset}));
        return table;
    }

    private static TableCell<Category, String> createNameCell(TableColumn<Category, String> column) {
        TableCell cell = (TableCell)TableColumn.DEFAULT_CELL_FACTORY.call(column);
        cell.setAlignment(Pos.CENTER_LEFT);
        return cell;
    }

    private static ObservableValue<String> getCategoryName(TableColumn.CellDataFeatures<Category, String> cell) {
        InternationalString name = ((Category)cell.getValue()).getName();
        return name != null ? new ImmutableObjectProperty<String>(name.toString()) : null;
    }
}

