/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.Shapes2D;
import org.apache.sis.gui.coverage.ImagePropertyExplorer;
import org.apache.sis.gui.coverage.IsolineRenderer;
import org.apache.sis.gui.coverage.MultiResolutionImageLoader;
import org.apache.sis.gui.coverage.Stretching;
import org.apache.sis.gui.coverage.StyledRenderingData;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.gui.map.MapCanvasAWT;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.image.Interpolation;
import org.apache.sis.internal.coverage.j2d.TileErrorHandler;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.internal.map.coverage.RenderingWorkaround;
import org.apache.sis.internal.processing.image.Isolines;
import org.apache.sis.io.TableAppender;
import org.apache.sis.measure.Units;
import org.apache.sis.portrayal.RenderException;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

@DefaultProperty(value="coverage")
public class CoverageCanvas
extends MapCanvasAWT {
    private static final int OVERFLOW_SAFETY_MARGIN = 10000000;
    static final boolean TRACE = false;
    public final ObjectProperty<GridCoverageResource> resourceProperty;
    public final ObjectProperty<GridCoverage> coverageProperty;
    private boolean isCoverageAdjusting;
    @Deprecated
    public final ObjectProperty<GridExtent> sliceExtentProperty;
    public final ObjectProperty<Interpolation> interpolationProperty;
    private StyledRenderingData data = new StyledRenderingData(report -> {
        this.errorReport = report.getDescription();
    });
    private final Map<Stretching, RenderedImage> derivedImages = new EnumMap<Stretching, RenderedImage>(Stretching.class);
    private RenderedImage resampledImage;
    private ImagePropertyExplorer propertyExplorer;
    StatusBar statusBar;
    private volatile LogRecord errorReport;
    IsolineRenderer isolines;

    public CoverageCanvas() {
        this(Locale.getDefault());
    }

    CoverageCanvas(Locale locale) {
        super(locale);
        this.resourceProperty = new SimpleObjectProperty((Object)this, "resource");
        this.coverageProperty = new SimpleObjectProperty((Object)this, "coverage");
        this.sliceExtentProperty = new SimpleObjectProperty((Object)this, "sliceExtent");
        this.interpolationProperty = new SimpleObjectProperty((Object)this, "interpolation", (Object)this.data.processor.getInterpolation());
        this.resourceProperty.addListener((p, o, n) -> this.onPropertySpecified((GridCoverageResource)n, null, this.coverageProperty));
        this.coverageProperty.addListener((p, o, n) -> this.onPropertySpecified(null, (GridCoverage)n, this.resourceProperty));
        this.sliceExtentProperty.addListener((p, o, n) -> this.onPropertySpecified(this.getResource(), this.getCoverage(), null));
        this.interpolationProperty.addListener((p, o, n) -> this.onInterpolationSpecified((Interpolation)n));
    }

    final ImagePropertyExplorer createPropertyExplorer() {
        this.propertyExplorer = new ImagePropertyExplorer(this.getLocale(), (ObjectProperty<Background>)this.fixedPane.backgroundProperty());
        this.propertyExplorer.setImage(this.resampledImage, this.getVisibleImageBounds());
        return this.propertyExplorer;
    }

    final Region getView() {
        return this.fixedPane;
    }

    final GridCoverageResource getResourceIfAdjusting() {
        return this.isCoverageAdjusting ? this.getResource() : null;
    }

    public final GridCoverageResource getResource() {
        return (GridCoverageResource)this.resourceProperty.get();
    }

    public final void setResource(GridCoverageResource resource) {
        this.resourceProperty.set((Object)resource);
    }

    public final GridCoverage getCoverage() {
        return (GridCoverage)this.coverageProperty.get();
    }

    public final void setCoverage(GridCoverage coverage) {
        this.coverageProperty.set((Object)coverage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCoverage(GridCoverageResource resource, GridCoverage coverage) {
        if (this.getResource() != resource || this.getCoverage() != coverage) {
            boolean p = this.isCoverageAdjusting;
            try {
                this.isCoverageAdjusting = true;
                this.setResource(resource);
                this.setCoverage(coverage);
            }
            finally {
                this.isCoverageAdjusting = p;
            }
            this.onPropertySpecified(resource, coverage, null);
        }
    }

    @Deprecated
    public final GridExtent getSliceExtent() {
        return (GridExtent)this.sliceExtentProperty.get();
    }

    @Deprecated
    public final void setSliceExtent(GridExtent sliceExtent) {
        this.sliceExtentProperty.set((Object)sliceExtent);
    }

    public final Interpolation getInterpolation() {
        return (Interpolation)this.interpolationProperty.get();
    }

    public final void setInterpolation(Interpolation interpolation) {
        assert (Platform.isFxApplicationThread());
        this.interpolationProperty.set((Object)interpolation);
    }

    final Function<Category, Color[]> getCategoryColors() {
        return this.data.processor.getCategoryColors();
    }

    final void setCategoryColors(Function<Category, Color[]> colors) {
        this.data.processor.setCategoryColors(colors);
        this.resampledImage = null;
        this.requestRepaint();
    }

    final void setBackground(javafx.scene.paint.Color color) {
        this.fixedPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, null, null)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectiveCRS(CoordinateReferenceSystem newValue, DirectPosition anchor) throws RenderException {
        Long id = LogHandler.loadingStart((Resource)this.getResource());
        try {
            super.setObjectiveCRS(newValue, anchor);
        }
        finally {
            LogHandler.loadingStop(id);
        }
        this.clearIsolines();
    }

    public void setGridGeometry(GridGeometry newValue) throws RenderException {
        Long id = LogHandler.loadingStart((Resource)this.getResource());
        try {
            super.setGridGeometry(newValue);
        }
        finally {
            LogHandler.loadingStop(id);
        }
        this.clearIsolines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPropertySpecified(final GridCoverageResource resource, final GridCoverage coverage, ObjectProperty<?> toClear) {
        if (this.isCoverageAdjusting) {
            return;
        }
        if (toClear != null) {
            try {
                this.isCoverageAdjusting = true;
                toClear.set(null);
            }
            finally {
                this.isCoverageAdjusting = false;
            }
        }
        if (resource == null && coverage == null) {
            this.runAfterRendering(this::clear);
        } else {
            BackgroundThreads.execute((Runnable)new Task<Envelope>(){
                private GridGeometry domain;
                private List<SampleDimension> ranges;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Envelope call() throws Exception {
                    Long id = LogHandler.loadingStart((Resource)resource);
                    try {
                        if (coverage != null) {
                            this.domain = coverage.getGridGeometry();
                            this.ranges = coverage.getSampleDimensions();
                        } else {
                            this.domain = resource.getGridGeometry();
                            this.ranges = resource.getSampleDimensions();
                        }
                        this.domain = MultiResolutionImageLoader.slice(this.domain);
                        if (this.domain != null) {
                            if (this.domain.isDefined(2)) {
                                Envelope envelope = this.domain.getEnvelope();
                                return envelope;
                            }
                            if (this.domain.isDefined(4)) {
                                GeneralEnvelope ge = this.domain.getExtent().toEnvelope((MathTransform)MathTransforms.identity((int)2));
                                ge.setCoordinateReferenceSystem((CoordinateReferenceSystem)CommonCRS.Engineering.DISPLAY.crs());
                                GeneralEnvelope generalEnvelope = ge;
                                return generalEnvelope;
                            }
                        }
                        Envelope envelope = null;
                        return envelope;
                    }
                    finally {
                        LogHandler.loadingStop(id);
                    }
                }

                protected void succeeded() {
                    CoverageCanvas.this.runAfterRendering(() -> CoverageCanvas.this.setNewSource((Envelope)this.getValue(), this.domain, this.ranges));
                }

                protected void failed() {
                    Throwable ex = this.getException();
                    CoverageCanvas.this.errorOccurred(ex);
                    ExceptionReporter.canNotUseResource((Node)CoverageCanvas.this.fixedPane, ex);
                }
            });
        }
    }

    private void setNewSource(Envelope bounds, GridGeometry domain, List<SampleDimension> ranges) {
        this.clearError();
        this.clearIsolines();
        this.resampledImage = null;
        this.derivedImages.clear();
        this.data.clear();
        this.data.setCoverageSpace(domain, ranges);
        this.setObjectiveBounds(bounds);
        this.requestRepaint();
    }

    private void clearIsolines() {
        if (this.isolines != null) {
            this.isolines.clear();
        }
    }

    private void onInterpolationSpecified(Interpolation newValue) {
        this.data.processor.setInterpolation(newValue);
        this.resampledImage = null;
        this.requestRepaint();
    }

    @Override
    protected MapCanvasAWT.Renderer createRenderer() {
        return this.data.getSourceImage() != null || this.getResource() != null ? new Worker(this) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheRenderingData(Worker worker) {
        LogRecord report;
        this.data = worker.data;
        if (worker.coverageChanged) {
            this.derivedImages.clear();
        }
        this.derivedImages.put(this.data.selectedDerivative, worker.recoloredImage);
        this.resampledImage = worker.resampledImage;
        if (this.propertyExplorer != null) {
            this.propertyExplorer.setImage(this.resampledImage, worker.getVisibleImageBounds());
        }
        if (this.statusBar != null) {
            Object value = this.resampledImage.getProperty("org.apache.sis.PositionalAccuracy");
            Quantity<Length> accuracy = null;
            if (value instanceof Quantity[]) {
                for (Quantity q : (Quantity[])value) {
                    if (!Units.isLinear((Unit)q.getUnit())) continue;
                    accuracy = q.asType(Length.class);
                    accuracy = GUIUtilities.shorter(accuracy, accuracy.getUnit().getConverterTo(Units.METRE).convert(accuracy.getValue().doubleValue()));
                    break;
                }
            }
            this.statusBar.setLowestAccuracy(accuracy);
        }
        if ((report = this.errorReport) != null) {
            this.errorReport = null;
            this.errorOccurred(report.getThrown());
        }
        if (worker.coverageChanged && !this.isCoverageAdjusting) {
            try {
                this.isCoverageAdjusting = true;
                this.setCoverage(worker.coverage);
            }
            finally {
                this.isCoverageAdjusting = false;
            }
        }
    }

    private Rectangle getVisibleImageBounds() {
        Envelope2D displayBounds = this.getDisplayBounds();
        if (displayBounds != null) {
            try {
                AffineTransform resampledToDisplay = this.data.getTransform(this.getObjectiveToDisplay());
                return (Rectangle)AffineTransforms2D.inverseTransform((AffineTransform)resampledToDisplay, (Rectangle2D)displayBounds, (Rectangle2D)new Rectangle());
            }
            catch (NoninvertibleTransformException e) {
                CoverageCanvas.unexpectedException(e);
            }
        }
        return null;
    }

    private Rectangle2D getAreaOfInterest() throws TransformException {
        Envelope2D displayBounds = this.getDisplayBounds();
        if (displayBounds == null) {
            return null;
        }
        return Shapes2D.transform((MathTransform2D)MathTransforms.bidimensional((MathTransform)this.getObjectiveToDisplay().inverse()), (Rectangle2D)displayBounds, null);
    }

    final void setStyling(Stretching selection) {
        if (this.data.selectedDerivative != selection) {
            this.data.selectedDerivative = selection;
            this.resampledImage = null;
            this.requestRepaint();
        }
    }

    private static void unexpectedException(Exception e) {
        Logging.unexpectedException((Logger)Logging.getLogger((String)"org.apache.sis.gui"), CoverageCanvas.class, (String)"render", (Throwable)e);
    }

    @Override
    protected void clear() {
        this.setNewSource(null, null, null);
        super.clear();
    }

    private static void trace(String format, Object ... arguments) {
    }

    public String toString() {
        if (!Platform.isFxApplicationThread()) {
            return super.toString();
        }
        String lineSeparator = System.lineSeparator();
        StringBuilder buffer = new StringBuilder(1000);
        TableAppender table = new TableAppender((Appendable)buffer);
        table.setMultiLinesCells(true);
        try {
            Rectangle source;
            table.nextLine('\u2550');
            this.getGridGeometry().getGeographicExtent().ifPresent(bbox -> table.append((CharSequence)String.format("Canvas geographic bounding box (\u03bb,\u0278):%nMax: % 10.5f\u00b0  % 10.5f\u00b0%nMin: % 10.5f\u00b0  % 10.5f\u00b0", bbox.getEastBoundLongitude(), bbox.getNorthBoundLatitude(), bbox.getWestBoundLongitude(), bbox.getSouthBoundLatitude())).appendHorizontalSeparator());
            Rectangle2D aoi = this.getAreaOfInterest();
            DirectPosition poi = this.getPointOfInterest(true);
            if (aoi != null && poi != null) {
                table.append((CharSequence)String.format("A/P of interest in objective CRS (x,y):%nMax: %, 16.4f  %, 16.4f%nPOI: %, 16.4f  %, 16.4f%nMin: %, 16.4f  %, 16.4f%n", aoi.getMaxX(), aoi.getMaxY(), poi.getOrdinate(0), poi.getOrdinate(1), aoi.getMinX(), aoi.getMinY())).appendHorizontalSeparator();
            }
            if ((source = this.data.objectiveToData(aoi)) != null) {
                table.append((CharSequence)"Extent in source coverage:").append((CharSequence)lineSeparator).append((CharSequence)String.valueOf(new GridExtent(source))).append((CharSequence)lineSeparator).nextLine();
            }
            table.nextLine('\u2550');
            table.flush();
        }
        catch (IOException | RenderException | TransformException e) {
            buffer.append(e).append(lineSeparator);
        }
        return buffer.toString();
    }

    private static final class Worker
    extends MapCanvasAWT.Renderer {
        private final GridCoverageResource resource;
        private GridCoverage coverage;
        private boolean coverageChanged;
        @Deprecated
        private final GridExtent sliceExtent;
        private final StyledRenderingData data;
        private final CoordinateReferenceSystem objectiveCRS;
        private final LinearTransform objectiveToDisplay;
        private final Envelope2D displayBounds;
        private Rectangle2D objectiveAOI;
        private final DirectPosition objectivePOI;
        private RenderedImage recoloredImage;
        private RenderedImage resampledImage;
        private RenderedImage prefetchedImage;
        private AffineTransform resampledToDisplay;
        private IsolineRenderer.Snapshot[] isolines;

        Worker(CoverageCanvas canvas) {
            Insets margin;
            this.resource = canvas.getResource();
            this.coverage = canvas.getCoverage();
            this.data = canvas.data.clone();
            this.sliceExtent = canvas.getSliceExtent();
            this.objectiveCRS = canvas.getObjectiveCRS();
            this.objectiveToDisplay = canvas.getObjectiveToDisplay();
            this.displayBounds = canvas.getDisplayBounds();
            this.objectivePOI = canvas.getPointOfInterest(true);
            this.recoloredImage = canvas.derivedImages.get((Object)this.data.selectedDerivative);
            if (this.data.validateCRS(this.objectiveCRS)) {
                this.resampledImage = canvas.resampledImage;
            }
            if ((margin = (Insets)canvas.imageMargin.get()) != null) {
                double top = margin.getTop();
                double left = margin.getLeft();
                this.displayBounds.x -= left;
                this.displayBounds.width += left + margin.getRight();
                this.displayBounds.y -= top;
                this.displayBounds.height += top + margin.getBottom();
            }
            if (canvas.isolines != null) {
                try {
                    this.isolines = canvas.isolines.prepare();
                    this.objectiveAOI = Shapes2D.transform((MathTransform2D)MathTransforms.bidimensional((MathTransform)this.objectiveToDisplay.inverse()), (Rectangle2D)this.displayBounds, null);
                }
                catch (TransformException e) {
                    CoverageCanvas.unexpectedException((Exception)((Object)e));
                }
            }
        }

        final Rectangle getVisibleImageBounds() {
            try {
                return (Rectangle)AffineTransforms2D.inverseTransform((AffineTransform)this.resampledToDisplay, (Rectangle2D)this.displayBounds, (Rectangle2D)new Rectangle());
            }
            catch (NoninvertibleTransformException e) {
                CoverageCanvas.unexpectedException(e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void render() throws Exception {
            Long id = LogHandler.loadingStart((Resource)this.resource);
            try {
                boolean isValid;
                this.data.setObjectiveCRS(this.objectiveCRS);
                if (this.resource != null) {
                    this.data.coverageLoader = MultiResolutionImageLoader.getInstance(this.resource, this.data.coverageLoader);
                    this.coverage = this.data.ensureCoverageLoaded(this.objectiveToDisplay, this.objectivePOI);
                    boolean bl = this.coverageChanged = this.coverage != null;
                }
                if (this.data.ensureImageLoaded(this.coverage, this.sliceExtent)) {
                    this.recoloredImage = null;
                }
                boolean bl = isValid = this.resampledImage != null;
                if (isValid) {
                    this.resampledToDisplay = this.data.getTransform(this.objectiveToDisplay);
                    boolean bl2 = isValid = (this.resampledToDisplay.getType() & 0xFFFFFFFE) == 0;
                    if (isValid) {
                        boolean bl3 = isValid = Math.max(Math.abs(this.resampledToDisplay.getTranslateX()), Math.abs(this.resampledToDisplay.getTranslateY())) < 2.137483647E9;
                    }
                }
                if (!isValid) {
                    if (this.recoloredImage == null) {
                        this.recoloredImage = this.data.recolor();
                    }
                    this.resampledImage = this.data.resampleAndConvert(this.recoloredImage, this.objectiveToDisplay, this.objectivePOI);
                    this.resampledToDisplay = this.data.getTransform(this.objectiveToDisplay);
                }
                Future<Isolines[]> newIsolines = this.data.generate(this.isolines);
                this.prefetchedImage = this.data.prefetch(this.resampledImage, this.resampledToDisplay, this.displayBounds);
                if (newIsolines != null) {
                    IsolineRenderer.complete(this.isolines, newIsolines);
                }
            }
            finally {
                LogHandler.loadingStop(id);
            }
        }

        @Override
        protected void paint(Graphics2D gr) {
            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            if (this.prefetchedImage instanceof TileErrorHandler.Executor) {
                ((TileErrorHandler.Executor)this.prefetchedImage).execute(() -> gr.drawRenderedImage(RenderingWorkaround.wrap((RenderedImage)this.prefetchedImage), this.resampledToDisplay), new TileErrorHandler(this.data.processor.getErrorHandler(), CoverageCanvas.class, "paint"));
            } else {
                gr.drawRenderedImage(RenderingWorkaround.wrap((RenderedImage)this.prefetchedImage), this.resampledToDisplay);
            }
            if (this.isolines != null) {
                AffineTransform at = gr.getTransform();
                Stroke st = gr.getStroke();
                gr.setStroke(new BasicStroke(this.data.getDataPixelSize(this.objectivePOI) / 8.0f));
                gr.transform((AffineTransform)this.objectiveToDisplay);
                for (IsolineRenderer.Snapshot s : this.isolines) {
                    s.paint(gr, this.objectiveAOI);
                }
                gr.setTransform(at);
                gr.setStroke(st);
            }
        }

        @Override
        protected boolean commit(MapCanvas canvas) {
            ((CoverageCanvas)canvas).cacheRenderingData(this);
            if (this.isolines != null) {
                for (IsolineRenderer.Snapshot s : this.isolines) {
                    s.commit();
                }
            }
            return super.commit(canvas);
        }
    }
}

