/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui;

import java.util.Collection;
import java.util.Locale;
import java.util.function.UnaryOperator;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.apache.sis.gui.dataset.LogViewer;
import org.apache.sis.internal.gui.DataStoreOpener;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.io.FileAccessView;
import org.apache.sis.internal.storage.io.ChannelFactory;
import org.apache.sis.util.resources.Vocabulary;

final class SystemMonitor
implements EventHandler<WindowEvent> {
    private final UnaryOperator<ChannelFactory> listener;

    private SystemMonitor(UnaryOperator<ChannelFactory> listener) {
        this.listener = listener;
    }

    public void handle(WindowEvent event) {
        UnaryOperator<ChannelFactory> wrapper;
        EventType type = event.getEventType();
        if (WindowEvent.WINDOW_SHOWN.equals(type)) {
            wrapper = this.listener;
        } else if (WindowEvent.WINDOW_HIDDEN.equals(type)) {
            wrapper = null;
        } else {
            return;
        }
        DataStoreOpener.setFactoryWrapper(wrapper);
    }

    static Stage create(Stage parent, Locale locale) {
        Resources resources = Resources.forLocale(locale);
        Vocabulary vocabulary = Vocabulary.getResources((Locale)locale);
        FileAccessView files = new FileAccessView(resources, vocabulary);
        LogViewer logging = new LogViewer();
        logging.systemLogs.set(true);
        Tab fileTab = new Tab(resources.getString((short)63), (Node)files.getView());
        Tab logTab = new Tab(vocabulary.getString((short)244), (Node)logging.getView());
        fileTab.setClosable(false);
        logTab.setClosable(false);
        TabPane panes = new TabPane(new Tab[]{fileTab, logTab});
        Stage w = new Stage();
        w.setTitle(resources.getString((short)64) + " \u2014 Apache SIS");
        w.getIcons().setAll((Collection)parent.getIcons());
        w.setScene(new Scene((Parent)panes));
        w.setMinWidth(400.0);
        w.setMinHeight(500.0);
        w.setWidth(800.0);
        w.setHeight(600.0);
        SystemMonitor handler = new SystemMonitor(files);
        w.setOnShown((EventHandler)handler);
        w.setOnHidden((EventHandler)handler);
        parent.setOnHidden(e -> w.hide());
        return w;
    }
}

